/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.voiceid.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.voiceid.model.Fraudster;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class FraudsterMarshaller {
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DOMAINID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainId").build();
    private static final MarshallingInfo<String> GENERATEDFRAUDSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GeneratedFraudsterId").build();
    private static final MarshallingInfo<List> WATCHLISTIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WatchlistIds").build();
    private static final FraudsterMarshaller instance = new FraudsterMarshaller();

    public static FraudsterMarshaller getInstance() {
        return instance;
    }

    public void marshall(Fraudster fraudster, ProtocolMarshaller protocolMarshaller) {
        if (fraudster == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fraudster.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)fraudster.getDomainId(), DOMAINID_BINDING);
            protocolMarshaller.marshall((Object)fraudster.getGeneratedFraudsterId(), GENERATEDFRAUDSTERID_BINDING);
            protocolMarshaller.marshall(fraudster.getWatchlistIds(), WATCHLISTIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

