/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.transfer.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateServerRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The virtual private cloud (VPC) endpoint settings that are configured for your SFTP server. With a VPC endpoint,
     * you can restrict access to your SFTP server to resources only within your VPC. To control incoming internet
     * traffic, you will need to invoke the <code>UpdateServer</code> API and attach an Elastic IP to your server's
     * endpoint.
     * </p>
     */
    private EndpointDetails endpointDetails;
    /**
     * <p>
     * The type of VPC endpoint that you want your SFTP server to connect to. You can choose to connect to the public
     * internet or a virtual private cloud (VPC) endpoint. With a VPC endpoint, you can restrict access to your SFTP
     * server and resources only within your VPC.
     * </p>
     */
    private String endpointType;
    /**
     * <p>
     * The RSA private key as generated by the <code>ssh-keygen -N "" -f my-new-server-key</code> command.
     * </p>
     * <important>
     * <p>
     * If you aren't planning to migrate existing users from an existing SFTP server to a new AWS SFTP server, don't
     * update the host key. Accidentally changing a server's host key can be disruptive.
     * </p>
     * </important>
     * <p>
     * For more information, see
     * "https://alpha-docs-aws.amazon.com/transfer/latest/userguide/configuring-servers.html#change-host-key" in the
     * <i>AWS SFTP User Guide.</i>
     * </p>
     */
    private String hostKey;
    /**
     * <p>
     * This parameter is required when the <code>IdentityProviderType</code> is set to <code>API_GATEWAY</code>. Accepts
     * an array containing all of the information required to call a customer-supplied authentication API, including the
     * API Gateway URL. This property is not required when the <code>IdentityProviderType</code> is set to
     * <code>SERVICE_MANAGED</code>.
     * </p>
     */
    private IdentityProviderDetails identityProviderDetails;
    /**
     * <p>
     * Specifies the mode of authentication for the SFTP server. The default value is <code>SERVICE_MANAGED</code>,
     * which allows you to store and access SFTP user credentials within the AWS Transfer for SFTP service. Use the
     * <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The
     * <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication
     * using the <code>IdentityProviderDetails</code> parameter.
     * </p>
     */
    private String identityProviderType;
    /**
     * <p>
     * A value that allows the service to write your SFTP users' activity to your Amazon CloudWatch logs for monitoring
     * and auditing purposes.
     * </p>
     */
    private String loggingRole;
    /**
     * <p>
     * Key-value pairs that can be used to group and search for servers.
     * </p>
     */
    private java.util.List<Tag> tags;

    /**
     * <p>
     * The virtual private cloud (VPC) endpoint settings that are configured for your SFTP server. With a VPC endpoint,
     * you can restrict access to your SFTP server to resources only within your VPC. To control incoming internet
     * traffic, you will need to invoke the <code>UpdateServer</code> API and attach an Elastic IP to your server's
     * endpoint.
     * </p>
     * 
     * @param endpointDetails
     *        The virtual private cloud (VPC) endpoint settings that are configured for your SFTP server. With a VPC
     *        endpoint, you can restrict access to your SFTP server to resources only within your VPC. To control
     *        incoming internet traffic, you will need to invoke the <code>UpdateServer</code> API and attach an Elastic
     *        IP to your server's endpoint.
     */

    public void setEndpointDetails(EndpointDetails endpointDetails) {
        this.endpointDetails = endpointDetails;
    }

    /**
     * <p>
     * The virtual private cloud (VPC) endpoint settings that are configured for your SFTP server. With a VPC endpoint,
     * you can restrict access to your SFTP server to resources only within your VPC. To control incoming internet
     * traffic, you will need to invoke the <code>UpdateServer</code> API and attach an Elastic IP to your server's
     * endpoint.
     * </p>
     * 
     * @return The virtual private cloud (VPC) endpoint settings that are configured for your SFTP server. With a VPC
     *         endpoint, you can restrict access to your SFTP server to resources only within your VPC. To control
     *         incoming internet traffic, you will need to invoke the <code>UpdateServer</code> API and attach an
     *         Elastic IP to your server's endpoint.
     */

    public EndpointDetails getEndpointDetails() {
        return this.endpointDetails;
    }

    /**
     * <p>
     * The virtual private cloud (VPC) endpoint settings that are configured for your SFTP server. With a VPC endpoint,
     * you can restrict access to your SFTP server to resources only within your VPC. To control incoming internet
     * traffic, you will need to invoke the <code>UpdateServer</code> API and attach an Elastic IP to your server's
     * endpoint.
     * </p>
     * 
     * @param endpointDetails
     *        The virtual private cloud (VPC) endpoint settings that are configured for your SFTP server. With a VPC
     *        endpoint, you can restrict access to your SFTP server to resources only within your VPC. To control
     *        incoming internet traffic, you will need to invoke the <code>UpdateServer</code> API and attach an Elastic
     *        IP to your server's endpoint.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateServerRequest withEndpointDetails(EndpointDetails endpointDetails) {
        setEndpointDetails(endpointDetails);
        return this;
    }

    /**
     * <p>
     * The type of VPC endpoint that you want your SFTP server to connect to. You can choose to connect to the public
     * internet or a virtual private cloud (VPC) endpoint. With a VPC endpoint, you can restrict access to your SFTP
     * server and resources only within your VPC.
     * </p>
     * 
     * @param endpointType
     *        The type of VPC endpoint that you want your SFTP server to connect to. You can choose to connect to the
     *        public internet or a virtual private cloud (VPC) endpoint. With a VPC endpoint, you can restrict access to
     *        your SFTP server and resources only within your VPC.
     * @see EndpointType
     */

    public void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
    }

    /**
     * <p>
     * The type of VPC endpoint that you want your SFTP server to connect to. You can choose to connect to the public
     * internet or a virtual private cloud (VPC) endpoint. With a VPC endpoint, you can restrict access to your SFTP
     * server and resources only within your VPC.
     * </p>
     * 
     * @return The type of VPC endpoint that you want your SFTP server to connect to. You can choose to connect to the
     *         public internet or a virtual private cloud (VPC) endpoint. With a VPC endpoint, you can restrict access
     *         to your SFTP server and resources only within your VPC.
     * @see EndpointType
     */

    public String getEndpointType() {
        return this.endpointType;
    }

    /**
     * <p>
     * The type of VPC endpoint that you want your SFTP server to connect to. You can choose to connect to the public
     * internet or a virtual private cloud (VPC) endpoint. With a VPC endpoint, you can restrict access to your SFTP
     * server and resources only within your VPC.
     * </p>
     * 
     * @param endpointType
     *        The type of VPC endpoint that you want your SFTP server to connect to. You can choose to connect to the
     *        public internet or a virtual private cloud (VPC) endpoint. With a VPC endpoint, you can restrict access to
     *        your SFTP server and resources only within your VPC.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EndpointType
     */

    public CreateServerRequest withEndpointType(String endpointType) {
        setEndpointType(endpointType);
        return this;
    }

    /**
     * <p>
     * The type of VPC endpoint that you want your SFTP server to connect to. You can choose to connect to the public
     * internet or a virtual private cloud (VPC) endpoint. With a VPC endpoint, you can restrict access to your SFTP
     * server and resources only within your VPC.
     * </p>
     * 
     * @param endpointType
     *        The type of VPC endpoint that you want your SFTP server to connect to. You can choose to connect to the
     *        public internet or a virtual private cloud (VPC) endpoint. With a VPC endpoint, you can restrict access to
     *        your SFTP server and resources only within your VPC.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EndpointType
     */

    public CreateServerRequest withEndpointType(EndpointType endpointType) {
        this.endpointType = endpointType.toString();
        return this;
    }

    /**
     * <p>
     * The RSA private key as generated by the <code>ssh-keygen -N "" -f my-new-server-key</code> command.
     * </p>
     * <important>
     * <p>
     * If you aren't planning to migrate existing users from an existing SFTP server to a new AWS SFTP server, don't
     * update the host key. Accidentally changing a server's host key can be disruptive.
     * </p>
     * </important>
     * <p>
     * For more information, see
     * "https://alpha-docs-aws.amazon.com/transfer/latest/userguide/configuring-servers.html#change-host-key" in the
     * <i>AWS SFTP User Guide.</i>
     * </p>
     * 
     * @param hostKey
     *        The RSA private key as generated by the <code>ssh-keygen -N "" -f my-new-server-key</code> command.</p>
     *        <important>
     *        <p>
     *        If you aren't planning to migrate existing users from an existing SFTP server to a new AWS SFTP server,
     *        don't update the host key. Accidentally changing a server's host key can be disruptive.
     *        </p>
     *        </important>
     *        <p>
     *        For more information, see
     *        "https://alpha-docs-aws.amazon.com/transfer/latest/userguide/configuring-servers.html#change-host-key" in
     *        the <i>AWS SFTP User Guide.</i>
     */

    public void setHostKey(String hostKey) {
        this.hostKey = hostKey;
    }

    /**
     * <p>
     * The RSA private key as generated by the <code>ssh-keygen -N "" -f my-new-server-key</code> command.
     * </p>
     * <important>
     * <p>
     * If you aren't planning to migrate existing users from an existing SFTP server to a new AWS SFTP server, don't
     * update the host key. Accidentally changing a server's host key can be disruptive.
     * </p>
     * </important>
     * <p>
     * For more information, see
     * "https://alpha-docs-aws.amazon.com/transfer/latest/userguide/configuring-servers.html#change-host-key" in the
     * <i>AWS SFTP User Guide.</i>
     * </p>
     * 
     * @return The RSA private key as generated by the <code>ssh-keygen -N "" -f my-new-server-key</code> command.</p>
     *         <important>
     *         <p>
     *         If you aren't planning to migrate existing users from an existing SFTP server to a new AWS SFTP server,
     *         don't update the host key. Accidentally changing a server's host key can be disruptive.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see
     *         "https://alpha-docs-aws.amazon.com/transfer/latest/userguide/configuring-servers.html#change-host-key" in
     *         the <i>AWS SFTP User Guide.</i>
     */

    public String getHostKey() {
        return this.hostKey;
    }

    /**
     * <p>
     * The RSA private key as generated by the <code>ssh-keygen -N "" -f my-new-server-key</code> command.
     * </p>
     * <important>
     * <p>
     * If you aren't planning to migrate existing users from an existing SFTP server to a new AWS SFTP server, don't
     * update the host key. Accidentally changing a server's host key can be disruptive.
     * </p>
     * </important>
     * <p>
     * For more information, see
     * "https://alpha-docs-aws.amazon.com/transfer/latest/userguide/configuring-servers.html#change-host-key" in the
     * <i>AWS SFTP User Guide.</i>
     * </p>
     * 
     * @param hostKey
     *        The RSA private key as generated by the <code>ssh-keygen -N "" -f my-new-server-key</code> command.</p>
     *        <important>
     *        <p>
     *        If you aren't planning to migrate existing users from an existing SFTP server to a new AWS SFTP server,
     *        don't update the host key. Accidentally changing a server's host key can be disruptive.
     *        </p>
     *        </important>
     *        <p>
     *        For more information, see
     *        "https://alpha-docs-aws.amazon.com/transfer/latest/userguide/configuring-servers.html#change-host-key" in
     *        the <i>AWS SFTP User Guide.</i>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateServerRequest withHostKey(String hostKey) {
        setHostKey(hostKey);
        return this;
    }

    /**
     * <p>
     * This parameter is required when the <code>IdentityProviderType</code> is set to <code>API_GATEWAY</code>. Accepts
     * an array containing all of the information required to call a customer-supplied authentication API, including the
     * API Gateway URL. This property is not required when the <code>IdentityProviderType</code> is set to
     * <code>SERVICE_MANAGED</code>.
     * </p>
     * 
     * @param identityProviderDetails
     *        This parameter is required when the <code>IdentityProviderType</code> is set to <code>API_GATEWAY</code>.
     *        Accepts an array containing all of the information required to call a customer-supplied authentication
     *        API, including the API Gateway URL. This property is not required when the
     *        <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code>.
     */

    public void setIdentityProviderDetails(IdentityProviderDetails identityProviderDetails) {
        this.identityProviderDetails = identityProviderDetails;
    }

    /**
     * <p>
     * This parameter is required when the <code>IdentityProviderType</code> is set to <code>API_GATEWAY</code>. Accepts
     * an array containing all of the information required to call a customer-supplied authentication API, including the
     * API Gateway URL. This property is not required when the <code>IdentityProviderType</code> is set to
     * <code>SERVICE_MANAGED</code>.
     * </p>
     * 
     * @return This parameter is required when the <code>IdentityProviderType</code> is set to <code>API_GATEWAY</code>.
     *         Accepts an array containing all of the information required to call a customer-supplied authentication
     *         API, including the API Gateway URL. This property is not required when the
     *         <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code>.
     */

    public IdentityProviderDetails getIdentityProviderDetails() {
        return this.identityProviderDetails;
    }

    /**
     * <p>
     * This parameter is required when the <code>IdentityProviderType</code> is set to <code>API_GATEWAY</code>. Accepts
     * an array containing all of the information required to call a customer-supplied authentication API, including the
     * API Gateway URL. This property is not required when the <code>IdentityProviderType</code> is set to
     * <code>SERVICE_MANAGED</code>.
     * </p>
     * 
     * @param identityProviderDetails
     *        This parameter is required when the <code>IdentityProviderType</code> is set to <code>API_GATEWAY</code>.
     *        Accepts an array containing all of the information required to call a customer-supplied authentication
     *        API, including the API Gateway URL. This property is not required when the
     *        <code>IdentityProviderType</code> is set to <code>SERVICE_MANAGED</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateServerRequest withIdentityProviderDetails(IdentityProviderDetails identityProviderDetails) {
        setIdentityProviderDetails(identityProviderDetails);
        return this;
    }

    /**
     * <p>
     * Specifies the mode of authentication for the SFTP server. The default value is <code>SERVICE_MANAGED</code>,
     * which allows you to store and access SFTP user credentials within the AWS Transfer for SFTP service. Use the
     * <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The
     * <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication
     * using the <code>IdentityProviderDetails</code> parameter.
     * </p>
     * 
     * @param identityProviderType
     *        Specifies the mode of authentication for the SFTP server. The default value is
     *        <code>SERVICE_MANAGED</code>, which allows you to store and access SFTP user credentials within the AWS
     *        Transfer for SFTP service. Use the <code>API_GATEWAY</code> value to integrate with an identity provider
     *        of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL
     *        to call for authentication using the <code>IdentityProviderDetails</code> parameter.
     * @see IdentityProviderType
     */

    public void setIdentityProviderType(String identityProviderType) {
        this.identityProviderType = identityProviderType;
    }

    /**
     * <p>
     * Specifies the mode of authentication for the SFTP server. The default value is <code>SERVICE_MANAGED</code>,
     * which allows you to store and access SFTP user credentials within the AWS Transfer for SFTP service. Use the
     * <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The
     * <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication
     * using the <code>IdentityProviderDetails</code> parameter.
     * </p>
     * 
     * @return Specifies the mode of authentication for the SFTP server. The default value is
     *         <code>SERVICE_MANAGED</code>, which allows you to store and access SFTP user credentials within the AWS
     *         Transfer for SFTP service. Use the <code>API_GATEWAY</code> value to integrate with an identity provider
     *         of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint
     *         URL to call for authentication using the <code>IdentityProviderDetails</code> parameter.
     * @see IdentityProviderType
     */

    public String getIdentityProviderType() {
        return this.identityProviderType;
    }

    /**
     * <p>
     * Specifies the mode of authentication for the SFTP server. The default value is <code>SERVICE_MANAGED</code>,
     * which allows you to store and access SFTP user credentials within the AWS Transfer for SFTP service. Use the
     * <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The
     * <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication
     * using the <code>IdentityProviderDetails</code> parameter.
     * </p>
     * 
     * @param identityProviderType
     *        Specifies the mode of authentication for the SFTP server. The default value is
     *        <code>SERVICE_MANAGED</code>, which allows you to store and access SFTP user credentials within the AWS
     *        Transfer for SFTP service. Use the <code>API_GATEWAY</code> value to integrate with an identity provider
     *        of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL
     *        to call for authentication using the <code>IdentityProviderDetails</code> parameter.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IdentityProviderType
     */

    public CreateServerRequest withIdentityProviderType(String identityProviderType) {
        setIdentityProviderType(identityProviderType);
        return this;
    }

    /**
     * <p>
     * Specifies the mode of authentication for the SFTP server. The default value is <code>SERVICE_MANAGED</code>,
     * which allows you to store and access SFTP user credentials within the AWS Transfer for SFTP service. Use the
     * <code>API_GATEWAY</code> value to integrate with an identity provider of your choosing. The
     * <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL to call for authentication
     * using the <code>IdentityProviderDetails</code> parameter.
     * </p>
     * 
     * @param identityProviderType
     *        Specifies the mode of authentication for the SFTP server. The default value is
     *        <code>SERVICE_MANAGED</code>, which allows you to store and access SFTP user credentials within the AWS
     *        Transfer for SFTP service. Use the <code>API_GATEWAY</code> value to integrate with an identity provider
     *        of your choosing. The <code>API_GATEWAY</code> setting requires you to provide an API Gateway endpoint URL
     *        to call for authentication using the <code>IdentityProviderDetails</code> parameter.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IdentityProviderType
     */

    public CreateServerRequest withIdentityProviderType(IdentityProviderType identityProviderType) {
        this.identityProviderType = identityProviderType.toString();
        return this;
    }

    /**
     * <p>
     * A value that allows the service to write your SFTP users' activity to your Amazon CloudWatch logs for monitoring
     * and auditing purposes.
     * </p>
     * 
     * @param loggingRole
     *        A value that allows the service to write your SFTP users' activity to your Amazon CloudWatch logs for
     *        monitoring and auditing purposes.
     */

    public void setLoggingRole(String loggingRole) {
        this.loggingRole = loggingRole;
    }

    /**
     * <p>
     * A value that allows the service to write your SFTP users' activity to your Amazon CloudWatch logs for monitoring
     * and auditing purposes.
     * </p>
     * 
     * @return A value that allows the service to write your SFTP users' activity to your Amazon CloudWatch logs for
     *         monitoring and auditing purposes.
     */

    public String getLoggingRole() {
        return this.loggingRole;
    }

    /**
     * <p>
     * A value that allows the service to write your SFTP users' activity to your Amazon CloudWatch logs for monitoring
     * and auditing purposes.
     * </p>
     * 
     * @param loggingRole
     *        A value that allows the service to write your SFTP users' activity to your Amazon CloudWatch logs for
     *        monitoring and auditing purposes.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateServerRequest withLoggingRole(String loggingRole) {
        setLoggingRole(loggingRole);
        return this;
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for servers.
     * </p>
     * 
     * @return Key-value pairs that can be used to group and search for servers.
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for servers.
     * </p>
     * 
     * @param tags
     *        Key-value pairs that can be used to group and search for servers.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for servers.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        Key-value pairs that can be used to group and search for servers.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateServerRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for servers.
     * </p>
     * 
     * @param tags
     *        Key-value pairs that can be used to group and search for servers.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateServerRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEndpointDetails() != null)
            sb.append("EndpointDetails: ").append(getEndpointDetails()).append(",");
        if (getEndpointType() != null)
            sb.append("EndpointType: ").append(getEndpointType()).append(",");
        if (getHostKey() != null)
            sb.append("HostKey: ").append("***Sensitive Data Redacted***").append(",");
        if (getIdentityProviderDetails() != null)
            sb.append("IdentityProviderDetails: ").append(getIdentityProviderDetails()).append(",");
        if (getIdentityProviderType() != null)
            sb.append("IdentityProviderType: ").append(getIdentityProviderType()).append(",");
        if (getLoggingRole() != null)
            sb.append("LoggingRole: ").append(getLoggingRole()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateServerRequest == false)
            return false;
        CreateServerRequest other = (CreateServerRequest) obj;
        if (other.getEndpointDetails() == null ^ this.getEndpointDetails() == null)
            return false;
        if (other.getEndpointDetails() != null && other.getEndpointDetails().equals(this.getEndpointDetails()) == false)
            return false;
        if (other.getEndpointType() == null ^ this.getEndpointType() == null)
            return false;
        if (other.getEndpointType() != null && other.getEndpointType().equals(this.getEndpointType()) == false)
            return false;
        if (other.getHostKey() == null ^ this.getHostKey() == null)
            return false;
        if (other.getHostKey() != null && other.getHostKey().equals(this.getHostKey()) == false)
            return false;
        if (other.getIdentityProviderDetails() == null ^ this.getIdentityProviderDetails() == null)
            return false;
        if (other.getIdentityProviderDetails() != null && other.getIdentityProviderDetails().equals(this.getIdentityProviderDetails()) == false)
            return false;
        if (other.getIdentityProviderType() == null ^ this.getIdentityProviderType() == null)
            return false;
        if (other.getIdentityProviderType() != null && other.getIdentityProviderType().equals(this.getIdentityProviderType()) == false)
            return false;
        if (other.getLoggingRole() == null ^ this.getLoggingRole() == null)
            return false;
        if (other.getLoggingRole() != null && other.getLoggingRole().equals(this.getLoggingRole()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEndpointDetails() == null) ? 0 : getEndpointDetails().hashCode());
        hashCode = prime * hashCode + ((getEndpointType() == null) ? 0 : getEndpointType().hashCode());
        hashCode = prime * hashCode + ((getHostKey() == null) ? 0 : getHostKey().hashCode());
        hashCode = prime * hashCode + ((getIdentityProviderDetails() == null) ? 0 : getIdentityProviderDetails().hashCode());
        hashCode = prime * hashCode + ((getIdentityProviderType() == null) ? 0 : getIdentityProviderType().hashCode());
        hashCode = prime * hashCode + ((getLoggingRole() == null) ? 0 : getLoggingRole().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateServerRequest clone() {
        return (CreateServerRequest) super.clone();
    }

}
