/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.stepfunctions.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains details about a specific state machine version.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StateMachineVersionListItem" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StateMachineVersionListItem implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination of state
     * machine ARN and the version number separated by a colon (:). For example, <code>stateMachineARN:1</code>.
     * </p>
     */
    private String stateMachineVersionArn;
    /**
     * <p>
     * The creation date of a state machine version.
     * </p>
     */
    private java.util.Date creationDate;

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination of state
     * machine ARN and the version number separated by a colon (:). For example, <code>stateMachineARN:1</code>.
     * </p>
     * 
     * @param stateMachineVersionArn
     *        The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination
     *        of state machine ARN and the version number separated by a colon (:). For example,
     *        <code>stateMachineARN:1</code>.
     */

    public void setStateMachineVersionArn(String stateMachineVersionArn) {
        this.stateMachineVersionArn = stateMachineVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination of state
     * machine ARN and the version number separated by a colon (:). For example, <code>stateMachineARN:1</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination
     *         of state machine ARN and the version number separated by a colon (:). For example,
     *         <code>stateMachineARN:1</code>.
     */

    public String getStateMachineVersionArn() {
        return this.stateMachineVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination of state
     * machine ARN and the version number separated by a colon (:). For example, <code>stateMachineARN:1</code>.
     * </p>
     * 
     * @param stateMachineVersionArn
     *        The Amazon Resource Name (ARN) that identifies a state machine version. The version ARN is a combination
     *        of state machine ARN and the version number separated by a colon (:). For example,
     *        <code>stateMachineARN:1</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StateMachineVersionListItem withStateMachineVersionArn(String stateMachineVersionArn) {
        setStateMachineVersionArn(stateMachineVersionArn);
        return this;
    }

    /**
     * <p>
     * The creation date of a state machine version.
     * </p>
     * 
     * @param creationDate
     *        The creation date of a state machine version.
     */

    public void setCreationDate(java.util.Date creationDate) {
        this.creationDate = creationDate;
    }

    /**
     * <p>
     * The creation date of a state machine version.
     * </p>
     * 
     * @return The creation date of a state machine version.
     */

    public java.util.Date getCreationDate() {
        return this.creationDate;
    }

    /**
     * <p>
     * The creation date of a state machine version.
     * </p>
     * 
     * @param creationDate
     *        The creation date of a state machine version.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StateMachineVersionListItem withCreationDate(java.util.Date creationDate) {
        setCreationDate(creationDate);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStateMachineVersionArn() != null)
            sb.append("StateMachineVersionArn: ").append(getStateMachineVersionArn()).append(",");
        if (getCreationDate() != null)
            sb.append("CreationDate: ").append(getCreationDate());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StateMachineVersionListItem == false)
            return false;
        StateMachineVersionListItem other = (StateMachineVersionListItem) obj;
        if (other.getStateMachineVersionArn() == null ^ this.getStateMachineVersionArn() == null)
            return false;
        if (other.getStateMachineVersionArn() != null && other.getStateMachineVersionArn().equals(this.getStateMachineVersionArn()) == false)
            return false;
        if (other.getCreationDate() == null ^ this.getCreationDate() == null)
            return false;
        if (other.getCreationDate() != null && other.getCreationDate().equals(this.getCreationDate()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStateMachineVersionArn() == null) ? 0 : getStateMachineVersionArn().hashCode());
        hashCode = prime * hashCode + ((getCreationDate() == null) ? 0 : getCreationDate().hashCode());
        return hashCode;
    }

    @Override
    public StateMachineVersionListItem clone() {
        try {
            return (StateMachineVersionListItem) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.stepfunctions.model.transform.StateMachineVersionListItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
