/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.AddPermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        if (addPermissionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addPermissionRequest, "AmazonSNS");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2010-03-31");
        if (addPermissionRequest.getTopicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)addPermissionRequest.getTopicArn()));
        }
        if (addPermissionRequest.getLabel() != null) {
            request.addParameter("Label", StringUtils.fromString((String)addPermissionRequest.getLabel()));
        }
        List<String> aWSAccountIdsList = addPermissionRequest.getAWSAccountIds();
        int aWSAccountIdsListIndex = 1;
        for (String aWSAccountIdsListValue : aWSAccountIdsList) {
            if (aWSAccountIdsListValue != null) {
                request.addParameter("AWSAccountId.member." + aWSAccountIdsListIndex, StringUtils.fromString((String)aWSAccountIdsListValue));
            }
            ++aWSAccountIdsListIndex;
        }
        List<String> actionNamesList = addPermissionRequest.getActionNames();
        int actionNamesListIndex = 1;
        for (String actionNamesListValue : actionNamesList) {
            if (actionNamesListValue != null) {
                request.addParameter("ActionName.member." + actionNamesListIndex, StringUtils.fromString((String)actionNamesListValue));
            }
            ++actionNamesListIndex;
        }
        return request;
    }
}

