/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackagevod.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediapackagevod.model.CmafEncryption;
import com.amazonaws.services.mediapackagevod.model.HlsManifest;
import com.amazonaws.services.mediapackagevod.model.transform.CmafPackageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CmafPackage
implements Serializable,
Cloneable,
StructuredPojo {
    private CmafEncryption encryption;
    private List<HlsManifest> hlsManifests;
    private Boolean includeEncoderConfigurationInSegments;
    private Integer segmentDurationSeconds;

    public void setEncryption(CmafEncryption encryption) {
        this.encryption = encryption;
    }

    public CmafEncryption getEncryption() {
        return this.encryption;
    }

    public CmafPackage withEncryption(CmafEncryption encryption) {
        this.setEncryption(encryption);
        return this;
    }

    public List<HlsManifest> getHlsManifests() {
        return this.hlsManifests;
    }

    public void setHlsManifests(Collection<HlsManifest> hlsManifests) {
        if (hlsManifests == null) {
            this.hlsManifests = null;
            return;
        }
        this.hlsManifests = new ArrayList<HlsManifest>(hlsManifests);
    }

    public CmafPackage withHlsManifests(HlsManifest ... hlsManifests) {
        if (this.hlsManifests == null) {
            this.setHlsManifests(new ArrayList<HlsManifest>(hlsManifests.length));
        }
        for (HlsManifest ele : hlsManifests) {
            this.hlsManifests.add(ele);
        }
        return this;
    }

    public CmafPackage withHlsManifests(Collection<HlsManifest> hlsManifests) {
        this.setHlsManifests(hlsManifests);
        return this;
    }

    public void setIncludeEncoderConfigurationInSegments(Boolean includeEncoderConfigurationInSegments) {
        this.includeEncoderConfigurationInSegments = includeEncoderConfigurationInSegments;
    }

    public Boolean getIncludeEncoderConfigurationInSegments() {
        return this.includeEncoderConfigurationInSegments;
    }

    public CmafPackage withIncludeEncoderConfigurationInSegments(Boolean includeEncoderConfigurationInSegments) {
        this.setIncludeEncoderConfigurationInSegments(includeEncoderConfigurationInSegments);
        return this;
    }

    public Boolean isIncludeEncoderConfigurationInSegments() {
        return this.includeEncoderConfigurationInSegments;
    }

    public void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
        this.segmentDurationSeconds = segmentDurationSeconds;
    }

    public Integer getSegmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public CmafPackage withSegmentDurationSeconds(Integer segmentDurationSeconds) {
        this.setSegmentDurationSeconds(segmentDurationSeconds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryption() != null) {
            sb.append("Encryption: ").append(this.getEncryption()).append(",");
        }
        if (this.getHlsManifests() != null) {
            sb.append("HlsManifests: ").append(this.getHlsManifests()).append(",");
        }
        if (this.getIncludeEncoderConfigurationInSegments() != null) {
            sb.append("IncludeEncoderConfigurationInSegments: ").append(this.getIncludeEncoderConfigurationInSegments()).append(",");
        }
        if (this.getSegmentDurationSeconds() != null) {
            sb.append("SegmentDurationSeconds: ").append(this.getSegmentDurationSeconds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafPackage)) {
            return false;
        }
        CmafPackage other = (CmafPackage)obj;
        if (other.getEncryption() == null ^ this.getEncryption() == null) {
            return false;
        }
        if (other.getEncryption() != null && !other.getEncryption().equals(this.getEncryption())) {
            return false;
        }
        if (other.getHlsManifests() == null ^ this.getHlsManifests() == null) {
            return false;
        }
        if (other.getHlsManifests() != null && !other.getHlsManifests().equals(this.getHlsManifests())) {
            return false;
        }
        if (other.getIncludeEncoderConfigurationInSegments() == null ^ this.getIncludeEncoderConfigurationInSegments() == null) {
            return false;
        }
        if (other.getIncludeEncoderConfigurationInSegments() != null && !other.getIncludeEncoderConfigurationInSegments().equals(this.getIncludeEncoderConfigurationInSegments())) {
            return false;
        }
        if (other.getSegmentDurationSeconds() == null ^ this.getSegmentDurationSeconds() == null) {
            return false;
        }
        return other.getSegmentDurationSeconds() == null || other.getSegmentDurationSeconds().equals(this.getSegmentDurationSeconds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryption() == null ? 0 : this.getEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getHlsManifests() == null ? 0 : this.getHlsManifests().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeEncoderConfigurationInSegments() == null ? 0 : this.getIncludeEncoderConfigurationInSegments().hashCode());
        hashCode = 31 * hashCode + (this.getSegmentDurationSeconds() == null ? 0 : this.getSegmentDurationSeconds().hashCode());
        return hashCode;
    }

    public CmafPackage clone() {
        try {
            return (CmafPackage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CmafPackageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

