/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mailmanager.model.Relay;
import java.util.Date;

@SdkInternalApi
public class RelayMarshaller {
    private static final MarshallingInfo<Date> LASTMODIFIEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> RELAYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RelayId").build();
    private static final MarshallingInfo<String> RELAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RelayName").build();
    private static final RelayMarshaller instance = new RelayMarshaller();

    public static RelayMarshaller getInstance() {
        return instance;
    }

    public void marshall(Relay relay, ProtocolMarshaller protocolMarshaller) {
        if (relay == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)relay.getLastModifiedTimestamp(), LASTMODIFIEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)relay.getRelayId(), RELAYID_BINDING);
            protocolMarshaller.marshall((Object)relay.getRelayName(), RELAYNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

