/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iamrolesanywhere.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iamrolesanywhere.model.Tag;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImportCrlRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ByteBuffer crlData;
    private Boolean enabled;
    private String name;
    private List<Tag> tags;
    private String trustAnchorArn;

    public void setCrlData(ByteBuffer crlData) {
        this.crlData = crlData;
    }

    public ByteBuffer getCrlData() {
        return this.crlData;
    }

    public ImportCrlRequest withCrlData(ByteBuffer crlData) {
        this.setCrlData(crlData);
        return this;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public ImportCrlRequest withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ImportCrlRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public ImportCrlRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ImportCrlRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setTrustAnchorArn(String trustAnchorArn) {
        this.trustAnchorArn = trustAnchorArn;
    }

    public String getTrustAnchorArn() {
        return this.trustAnchorArn;
    }

    public ImportCrlRequest withTrustAnchorArn(String trustAnchorArn) {
        this.setTrustAnchorArn(trustAnchorArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCrlData() != null) {
            sb.append("CrlData: ").append(this.getCrlData()).append(",");
        }
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTrustAnchorArn() != null) {
            sb.append("TrustAnchorArn: ").append(this.getTrustAnchorArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportCrlRequest)) {
            return false;
        }
        ImportCrlRequest other = (ImportCrlRequest)obj;
        if (other.getCrlData() == null ^ this.getCrlData() == null) {
            return false;
        }
        if (other.getCrlData() != null && !other.getCrlData().equals(this.getCrlData())) {
            return false;
        }
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTrustAnchorArn() == null ^ this.getTrustAnchorArn() == null) {
            return false;
        }
        return other.getTrustAnchorArn() == null || other.getTrustAnchorArn().equals(this.getTrustAnchorArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCrlData() == null ? 0 : this.getCrlData().hashCode());
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTrustAnchorArn() == null ? 0 : this.getTrustAnchorArn().hashCode());
        return hashCode;
    }

    public ImportCrlRequest clone() {
        return (ImportCrlRequest)super.clone();
    }
}

