/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.frauddetector.model.BatchGetVariableError;
import com.amazonaws.services.frauddetector.model.Variable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetVariableResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Variable> variables;
    private List<BatchGetVariableError> errors;

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(Collection<Variable> variables) {
        if (variables == null) {
            this.variables = null;
            return;
        }
        this.variables = new ArrayList<Variable>(variables);
    }

    public BatchGetVariableResult withVariables(Variable ... variables) {
        if (this.variables == null) {
            this.setVariables(new ArrayList<Variable>(variables.length));
        }
        for (Variable ele : variables) {
            this.variables.add(ele);
        }
        return this;
    }

    public BatchGetVariableResult withVariables(Collection<Variable> variables) {
        this.setVariables(variables);
        return this;
    }

    public List<BatchGetVariableError> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<BatchGetVariableError> errors) {
        if (errors == null) {
            this.errors = null;
            return;
        }
        this.errors = new ArrayList<BatchGetVariableError>(errors);
    }

    public BatchGetVariableResult withErrors(BatchGetVariableError ... errors) {
        if (this.errors == null) {
            this.setErrors(new ArrayList<BatchGetVariableError>(errors.length));
        }
        for (BatchGetVariableError ele : errors) {
            this.errors.add(ele);
        }
        return this;
    }

    public BatchGetVariableResult withErrors(Collection<BatchGetVariableError> errors) {
        this.setErrors(errors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVariables() != null) {
            sb.append("Variables: ").append(this.getVariables()).append(",");
        }
        if (this.getErrors() != null) {
            sb.append("Errors: ").append(this.getErrors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetVariableResult)) {
            return false;
        }
        BatchGetVariableResult other = (BatchGetVariableResult)obj;
        if (other.getVariables() == null ^ this.getVariables() == null) {
            return false;
        }
        if (other.getVariables() != null && !other.getVariables().equals(this.getVariables())) {
            return false;
        }
        if (other.getErrors() == null ^ this.getErrors() == null) {
            return false;
        }
        return other.getErrors() == null || other.getErrors().equals(this.getErrors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVariables() == null ? 0 : this.getVariables().hashCode());
        hashCode = 31 * hashCode + (this.getErrors() == null ? 0 : this.getErrors().hashCode());
        return hashCode;
    }

    public BatchGetVariableResult clone() {
        try {
            return (BatchGetVariableResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

