/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.controlcatalog;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.controlcatalog.AWSControlCatalogAsync;
import com.amazonaws.services.controlcatalog.AWSControlCatalogAsyncClientBuilder;
import com.amazonaws.services.controlcatalog.AWSControlCatalogClient;
import com.amazonaws.services.controlcatalog.model.ListCommonControlsRequest;
import com.amazonaws.services.controlcatalog.model.ListCommonControlsResult;
import com.amazonaws.services.controlcatalog.model.ListDomainsRequest;
import com.amazonaws.services.controlcatalog.model.ListDomainsResult;
import com.amazonaws.services.controlcatalog.model.ListObjectivesRequest;
import com.amazonaws.services.controlcatalog.model.ListObjectivesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSControlCatalogAsyncClient
extends AWSControlCatalogClient
implements AWSControlCatalogAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSControlCatalogAsyncClientBuilder asyncBuilder() {
        return AWSControlCatalogAsyncClientBuilder.standard();
    }

    AWSControlCatalogAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSControlCatalogAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<ListCommonControlsResult> listCommonControlsAsync(ListCommonControlsRequest request) {
        return this.listCommonControlsAsync(request, null);
    }

    @Override
    public Future<ListCommonControlsResult> listCommonControlsAsync(ListCommonControlsRequest request, final AsyncHandler<ListCommonControlsRequest, ListCommonControlsResult> asyncHandler) {
        final ListCommonControlsRequest finalRequest = (ListCommonControlsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCommonControlsResult>(){

            @Override
            public ListCommonControlsResult call() throws Exception {
                ListCommonControlsResult result = null;
                try {
                    result = AWSControlCatalogAsyncClient.this.executeListCommonControls(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDomainsResult> listDomainsAsync(ListDomainsRequest request) {
        return this.listDomainsAsync(request, null);
    }

    @Override
    public Future<ListDomainsResult> listDomainsAsync(ListDomainsRequest request, final AsyncHandler<ListDomainsRequest, ListDomainsResult> asyncHandler) {
        final ListDomainsRequest finalRequest = (ListDomainsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDomainsResult>(){

            @Override
            public ListDomainsResult call() throws Exception {
                ListDomainsResult result = null;
                try {
                    result = AWSControlCatalogAsyncClient.this.executeListDomains(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListObjectivesResult> listObjectivesAsync(ListObjectivesRequest request) {
        return this.listObjectivesAsync(request, null);
    }

    @Override
    public Future<ListObjectivesResult> listObjectivesAsync(ListObjectivesRequest request, final AsyncHandler<ListObjectivesRequest, ListObjectivesResult> asyncHandler) {
        final ListObjectivesRequest finalRequest = (ListObjectivesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListObjectivesResult>(){

            @Override
            public ListObjectivesResult call() throws Exception {
                ListObjectivesResult result = null;
                try {
                    result = AWSControlCatalogAsyncClient.this.executeListObjectives(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

