/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectwisdom.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.connectwisdom.model.ContentSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListContentsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ContentSummary> contentSummaries;
    private String nextToken;

    public List<ContentSummary> getContentSummaries() {
        return this.contentSummaries;
    }

    public void setContentSummaries(Collection<ContentSummary> contentSummaries) {
        if (contentSummaries == null) {
            this.contentSummaries = null;
            return;
        }
        this.contentSummaries = new ArrayList<ContentSummary>(contentSummaries);
    }

    public ListContentsResult withContentSummaries(ContentSummary ... contentSummaries) {
        if (this.contentSummaries == null) {
            this.setContentSummaries(new ArrayList<ContentSummary>(contentSummaries.length));
        }
        for (ContentSummary ele : contentSummaries) {
            this.contentSummaries.add(ele);
        }
        return this;
    }

    public ListContentsResult withContentSummaries(Collection<ContentSummary> contentSummaries) {
        this.setContentSummaries(contentSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListContentsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContentSummaries() != null) {
            sb.append("ContentSummaries: ").append(this.getContentSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContentsResult)) {
            return false;
        }
        ListContentsResult other = (ListContentsResult)obj;
        if (other.getContentSummaries() == null ^ this.getContentSummaries() == null) {
            return false;
        }
        if (other.getContentSummaries() != null && !other.getContentSummaries().equals(this.getContentSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContentSummaries() == null ? 0 : this.getContentSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListContentsResult clone() {
        try {
            return (ListContentsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

