/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connectwisdom.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connectwisdom.model.Highlight;
import com.amazonaws.services.connectwisdom.model.transform.DocumentTextMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DocumentText
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Highlight> highlights;
    private String text;

    public List<Highlight> getHighlights() {
        return this.highlights;
    }

    public void setHighlights(Collection<Highlight> highlights) {
        if (highlights == null) {
            this.highlights = null;
            return;
        }
        this.highlights = new ArrayList<Highlight>(highlights);
    }

    public DocumentText withHighlights(Highlight ... highlights) {
        if (this.highlights == null) {
            this.setHighlights(new ArrayList<Highlight>(highlights.length));
        }
        for (Highlight ele : highlights) {
            this.highlights.add(ele);
        }
        return this;
    }

    public DocumentText withHighlights(Collection<Highlight> highlights) {
        this.setHighlights(highlights);
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public DocumentText withText(String text) {
        this.setText(text);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHighlights() != null) {
            sb.append("Highlights: ").append(this.getHighlights()).append(",");
        }
        if (this.getText() != null) {
            sb.append("Text: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentText)) {
            return false;
        }
        DocumentText other = (DocumentText)obj;
        if (other.getHighlights() == null ^ this.getHighlights() == null) {
            return false;
        }
        if (other.getHighlights() != null && !other.getHighlights().equals(this.getHighlights())) {
            return false;
        }
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        return other.getText() == null || other.getText().equals(this.getText());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHighlights() == null ? 0 : this.getHighlights().hashCode());
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        return hashCode;
    }

    public DocumentText clone() {
        try {
            return (DocumentText)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentTextMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

