/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.LicenseEdition;
import com.amazonaws.services.computeoptimizer.model.LicenseModel;
import com.amazonaws.services.computeoptimizer.model.LicenseName;
import com.amazonaws.services.computeoptimizer.model.MetricSource;
import com.amazonaws.services.computeoptimizer.model.transform.LicenseConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LicenseConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer numberOfCores;
    private String instanceType;
    private String operatingSystem;
    private String licenseEdition;
    private String licenseName;
    private String licenseModel;
    private String licenseVersion;
    private List<MetricSource> metricsSource;

    public void setNumberOfCores(Integer numberOfCores) {
        this.numberOfCores = numberOfCores;
    }

    public Integer getNumberOfCores() {
        return this.numberOfCores;
    }

    public LicenseConfiguration withNumberOfCores(Integer numberOfCores) {
        this.setNumberOfCores(numberOfCores);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public LicenseConfiguration withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public LicenseConfiguration withOperatingSystem(String operatingSystem) {
        this.setOperatingSystem(operatingSystem);
        return this;
    }

    public void setLicenseEdition(String licenseEdition) {
        this.licenseEdition = licenseEdition;
    }

    public String getLicenseEdition() {
        return this.licenseEdition;
    }

    public LicenseConfiguration withLicenseEdition(String licenseEdition) {
        this.setLicenseEdition(licenseEdition);
        return this;
    }

    public LicenseConfiguration withLicenseEdition(LicenseEdition licenseEdition) {
        this.licenseEdition = licenseEdition.toString();
        return this;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public LicenseConfiguration withLicenseName(String licenseName) {
        this.setLicenseName(licenseName);
        return this;
    }

    public LicenseConfiguration withLicenseName(LicenseName licenseName) {
        this.licenseName = licenseName.toString();
        return this;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public LicenseConfiguration withLicenseModel(String licenseModel) {
        this.setLicenseModel(licenseModel);
        return this;
    }

    public LicenseConfiguration withLicenseModel(LicenseModel licenseModel) {
        this.licenseModel = licenseModel.toString();
        return this;
    }

    public void setLicenseVersion(String licenseVersion) {
        this.licenseVersion = licenseVersion;
    }

    public String getLicenseVersion() {
        return this.licenseVersion;
    }

    public LicenseConfiguration withLicenseVersion(String licenseVersion) {
        this.setLicenseVersion(licenseVersion);
        return this;
    }

    public List<MetricSource> getMetricsSource() {
        return this.metricsSource;
    }

    public void setMetricsSource(Collection<MetricSource> metricsSource) {
        if (metricsSource == null) {
            this.metricsSource = null;
            return;
        }
        this.metricsSource = new ArrayList<MetricSource>(metricsSource);
    }

    public LicenseConfiguration withMetricsSource(MetricSource ... metricsSource) {
        if (this.metricsSource == null) {
            this.setMetricsSource(new ArrayList<MetricSource>(metricsSource.length));
        }
        for (MetricSource ele : metricsSource) {
            this.metricsSource.add(ele);
        }
        return this;
    }

    public LicenseConfiguration withMetricsSource(Collection<MetricSource> metricsSource) {
        this.setMetricsSource(metricsSource);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNumberOfCores() != null) {
            sb.append("NumberOfCores: ").append(this.getNumberOfCores()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getOperatingSystem() != null) {
            sb.append("OperatingSystem: ").append(this.getOperatingSystem()).append(",");
        }
        if (this.getLicenseEdition() != null) {
            sb.append("LicenseEdition: ").append(this.getLicenseEdition()).append(",");
        }
        if (this.getLicenseName() != null) {
            sb.append("LicenseName: ").append(this.getLicenseName()).append(",");
        }
        if (this.getLicenseModel() != null) {
            sb.append("LicenseModel: ").append(this.getLicenseModel()).append(",");
        }
        if (this.getLicenseVersion() != null) {
            sb.append("LicenseVersion: ").append(this.getLicenseVersion()).append(",");
        }
        if (this.getMetricsSource() != null) {
            sb.append("MetricsSource: ").append(this.getMetricsSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseConfiguration)) {
            return false;
        }
        LicenseConfiguration other = (LicenseConfiguration)obj;
        if (other.getNumberOfCores() == null ^ this.getNumberOfCores() == null) {
            return false;
        }
        if (other.getNumberOfCores() != null && !other.getNumberOfCores().equals(this.getNumberOfCores())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getOperatingSystem() == null ^ this.getOperatingSystem() == null) {
            return false;
        }
        if (other.getOperatingSystem() != null && !other.getOperatingSystem().equals(this.getOperatingSystem())) {
            return false;
        }
        if (other.getLicenseEdition() == null ^ this.getLicenseEdition() == null) {
            return false;
        }
        if (other.getLicenseEdition() != null && !other.getLicenseEdition().equals(this.getLicenseEdition())) {
            return false;
        }
        if (other.getLicenseName() == null ^ this.getLicenseName() == null) {
            return false;
        }
        if (other.getLicenseName() != null && !other.getLicenseName().equals(this.getLicenseName())) {
            return false;
        }
        if (other.getLicenseModel() == null ^ this.getLicenseModel() == null) {
            return false;
        }
        if (other.getLicenseModel() != null && !other.getLicenseModel().equals(this.getLicenseModel())) {
            return false;
        }
        if (other.getLicenseVersion() == null ^ this.getLicenseVersion() == null) {
            return false;
        }
        if (other.getLicenseVersion() != null && !other.getLicenseVersion().equals(this.getLicenseVersion())) {
            return false;
        }
        if (other.getMetricsSource() == null ^ this.getMetricsSource() == null) {
            return false;
        }
        return other.getMetricsSource() == null || other.getMetricsSource().equals(this.getMetricsSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNumberOfCores() == null ? 0 : this.getNumberOfCores().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystem() == null ? 0 : this.getOperatingSystem().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseEdition() == null ? 0 : this.getLicenseEdition().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseName() == null ? 0 : this.getLicenseName().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseModel() == null ? 0 : this.getLicenseModel().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseVersion() == null ? 0 : this.getLicenseVersion().hashCode());
        hashCode = 31 * hashCode + (this.getMetricsSource() == null ? 0 : this.getMetricsSource().hashCode());
        return hashCode;
    }

    public LicenseConfiguration clone() {
        try {
            return (LicenseConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LicenseConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

