/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.computeoptimizer.model.ExportableLambdaFunctionField;
import com.amazonaws.services.computeoptimizer.model.FileFormat;
import com.amazonaws.services.computeoptimizer.model.LambdaFunctionRecommendationFilter;
import com.amazonaws.services.computeoptimizer.model.S3DestinationConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExportLambdaFunctionRecommendationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> accountIds;
    private List<LambdaFunctionRecommendationFilter> filters;
    private List<String> fieldsToExport;
    private S3DestinationConfig s3DestinationConfig;
    private String fileFormat;
    private Boolean includeMemberAccounts;

    public List<String> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Collection<String> accountIds) {
        if (accountIds == null) {
            this.accountIds = null;
            return;
        }
        this.accountIds = new ArrayList<String>(accountIds);
    }

    public ExportLambdaFunctionRecommendationsRequest withAccountIds(String ... accountIds) {
        if (this.accountIds == null) {
            this.setAccountIds(new ArrayList<String>(accountIds.length));
        }
        for (String ele : accountIds) {
            this.accountIds.add(ele);
        }
        return this;
    }

    public ExportLambdaFunctionRecommendationsRequest withAccountIds(Collection<String> accountIds) {
        this.setAccountIds(accountIds);
        return this;
    }

    public List<LambdaFunctionRecommendationFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<LambdaFunctionRecommendationFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<LambdaFunctionRecommendationFilter>(filters);
    }

    public ExportLambdaFunctionRecommendationsRequest withFilters(LambdaFunctionRecommendationFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<LambdaFunctionRecommendationFilter>(filters.length));
        }
        for (LambdaFunctionRecommendationFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public ExportLambdaFunctionRecommendationsRequest withFilters(Collection<LambdaFunctionRecommendationFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<String> getFieldsToExport() {
        return this.fieldsToExport;
    }

    public void setFieldsToExport(Collection<String> fieldsToExport) {
        if (fieldsToExport == null) {
            this.fieldsToExport = null;
            return;
        }
        this.fieldsToExport = new ArrayList<String>(fieldsToExport);
    }

    public ExportLambdaFunctionRecommendationsRequest withFieldsToExport(String ... fieldsToExport) {
        if (this.fieldsToExport == null) {
            this.setFieldsToExport(new ArrayList<String>(fieldsToExport.length));
        }
        for (String ele : fieldsToExport) {
            this.fieldsToExport.add(ele);
        }
        return this;
    }

    public ExportLambdaFunctionRecommendationsRequest withFieldsToExport(Collection<String> fieldsToExport) {
        this.setFieldsToExport(fieldsToExport);
        return this;
    }

    public ExportLambdaFunctionRecommendationsRequest withFieldsToExport(ExportableLambdaFunctionField ... fieldsToExport) {
        ArrayList<String> fieldsToExportCopy = new ArrayList<String>(fieldsToExport.length);
        for (ExportableLambdaFunctionField value : fieldsToExport) {
            fieldsToExportCopy.add(value.toString());
        }
        if (this.getFieldsToExport() == null) {
            this.setFieldsToExport(fieldsToExportCopy);
        } else {
            this.getFieldsToExport().addAll(fieldsToExportCopy);
        }
        return this;
    }

    public void setS3DestinationConfig(S3DestinationConfig s3DestinationConfig) {
        this.s3DestinationConfig = s3DestinationConfig;
    }

    public S3DestinationConfig getS3DestinationConfig() {
        return this.s3DestinationConfig;
    }

    public ExportLambdaFunctionRecommendationsRequest withS3DestinationConfig(S3DestinationConfig s3DestinationConfig) {
        this.setS3DestinationConfig(s3DestinationConfig);
        return this;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public ExportLambdaFunctionRecommendationsRequest withFileFormat(String fileFormat) {
        this.setFileFormat(fileFormat);
        return this;
    }

    public ExportLambdaFunctionRecommendationsRequest withFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat.toString();
        return this;
    }

    public void setIncludeMemberAccounts(Boolean includeMemberAccounts) {
        this.includeMemberAccounts = includeMemberAccounts;
    }

    public Boolean getIncludeMemberAccounts() {
        return this.includeMemberAccounts;
    }

    public ExportLambdaFunctionRecommendationsRequest withIncludeMemberAccounts(Boolean includeMemberAccounts) {
        this.setIncludeMemberAccounts(includeMemberAccounts);
        return this;
    }

    public Boolean isIncludeMemberAccounts() {
        return this.includeMemberAccounts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountIds() != null) {
            sb.append("AccountIds: ").append(this.getAccountIds()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getFieldsToExport() != null) {
            sb.append("FieldsToExport: ").append(this.getFieldsToExport()).append(",");
        }
        if (this.getS3DestinationConfig() != null) {
            sb.append("S3DestinationConfig: ").append(this.getS3DestinationConfig()).append(",");
        }
        if (this.getFileFormat() != null) {
            sb.append("FileFormat: ").append(this.getFileFormat()).append(",");
        }
        if (this.getIncludeMemberAccounts() != null) {
            sb.append("IncludeMemberAccounts: ").append(this.getIncludeMemberAccounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportLambdaFunctionRecommendationsRequest)) {
            return false;
        }
        ExportLambdaFunctionRecommendationsRequest other = (ExportLambdaFunctionRecommendationsRequest)obj;
        if (other.getAccountIds() == null ^ this.getAccountIds() == null) {
            return false;
        }
        if (other.getAccountIds() != null && !other.getAccountIds().equals(this.getAccountIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getFieldsToExport() == null ^ this.getFieldsToExport() == null) {
            return false;
        }
        if (other.getFieldsToExport() != null && !other.getFieldsToExport().equals(this.getFieldsToExport())) {
            return false;
        }
        if (other.getS3DestinationConfig() == null ^ this.getS3DestinationConfig() == null) {
            return false;
        }
        if (other.getS3DestinationConfig() != null && !other.getS3DestinationConfig().equals(this.getS3DestinationConfig())) {
            return false;
        }
        if (other.getFileFormat() == null ^ this.getFileFormat() == null) {
            return false;
        }
        if (other.getFileFormat() != null && !other.getFileFormat().equals(this.getFileFormat())) {
            return false;
        }
        if (other.getIncludeMemberAccounts() == null ^ this.getIncludeMemberAccounts() == null) {
            return false;
        }
        return other.getIncludeMemberAccounts() == null || other.getIncludeMemberAccounts().equals(this.getIncludeMemberAccounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountIds() == null ? 0 : this.getAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getFieldsToExport() == null ? 0 : this.getFieldsToExport().hashCode());
        hashCode = 31 * hashCode + (this.getS3DestinationConfig() == null ? 0 : this.getS3DestinationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getFileFormat() == null ? 0 : this.getFileFormat().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeMemberAccounts() == null ? 0 : this.getIncludeMemberAccounts().hashCode());
        return hashCode;
    }

    public ExportLambdaFunctionRecommendationsRequest clone() {
        return (ExportLambdaFunctionRecommendationsRequest)super.clone();
    }
}

