/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.billingconductor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.billingconductor.model.LineItemFilterAttributeName;
import com.amazonaws.services.billingconductor.model.LineItemFilterValue;
import com.amazonaws.services.billingconductor.model.MatchOption;
import com.amazonaws.services.billingconductor.model.transform.LineItemFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LineItemFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private String attribute;
    private String matchOption;
    private List<String> values;

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public LineItemFilter withAttribute(String attribute) {
        this.setAttribute(attribute);
        return this;
    }

    public LineItemFilter withAttribute(LineItemFilterAttributeName attribute) {
        this.attribute = attribute.toString();
        return this;
    }

    public void setMatchOption(String matchOption) {
        this.matchOption = matchOption;
    }

    public String getMatchOption() {
        return this.matchOption;
    }

    public LineItemFilter withMatchOption(String matchOption) {
        this.setMatchOption(matchOption);
        return this;
    }

    public LineItemFilter withMatchOption(MatchOption matchOption) {
        this.matchOption = matchOption.toString();
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<String>(values);
    }

    public LineItemFilter withValues(String ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<String>(values.length));
        }
        for (String ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public LineItemFilter withValues(Collection<String> values) {
        this.setValues(values);
        return this;
    }

    public LineItemFilter withValues(LineItemFilterValue ... values) {
        ArrayList<String> valuesCopy = new ArrayList<String>(values.length);
        for (LineItemFilterValue value : values) {
            valuesCopy.add(value.toString());
        }
        if (this.getValues() == null) {
            this.setValues(valuesCopy);
        } else {
            this.getValues().addAll(valuesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttribute() != null) {
            sb.append("Attribute: ").append(this.getAttribute()).append(",");
        }
        if (this.getMatchOption() != null) {
            sb.append("MatchOption: ").append(this.getMatchOption()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItemFilter)) {
            return false;
        }
        LineItemFilter other = (LineItemFilter)obj;
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        if (other.getAttribute() != null && !other.getAttribute().equals(this.getAttribute())) {
            return false;
        }
        if (other.getMatchOption() == null ^ this.getMatchOption() == null) {
            return false;
        }
        if (other.getMatchOption() != null && !other.getMatchOption().equals(this.getMatchOption())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        hashCode = 31 * hashCode + (this.getMatchOption() == null ? 0 : this.getMatchOption().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public LineItemFilter clone() {
        try {
            return (LineItemFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LineItemFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

