/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appstream.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.appstream.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AssociateAppBlockBuilderAppBlockRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AssociateAppBlockBuilderAppBlockRequestMarshaller {

    private static final MarshallingInfo<String> APPBLOCKARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppBlockArn").build();
    private static final MarshallingInfo<String> APPBLOCKBUILDERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppBlockBuilderName").build();

    private static final AssociateAppBlockBuilderAppBlockRequestMarshaller instance = new AssociateAppBlockBuilderAppBlockRequestMarshaller();

    public static AssociateAppBlockBuilderAppBlockRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AssociateAppBlockBuilderAppBlockRequest associateAppBlockBuilderAppBlockRequest, ProtocolMarshaller protocolMarshaller) {

        if (associateAppBlockBuilderAppBlockRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(associateAppBlockBuilderAppBlockRequest.getAppBlockArn(), APPBLOCKARN_BINDING);
            protocolMarshaller.marshall(associateAppBlockBuilderAppBlockRequest.getAppBlockBuilderName(), APPBLOCKBUILDERNAME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
