/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.listManagement;

import com.amazon.ask.model.services.listManagement.AlexaListItem;
import com.amazon.ask.model.services.listManagement.Links;
import com.amazon.ask.model.services.listManagement.ListState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AlexaList {
    @JsonProperty(value="listId")
    private String listId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="version")
    private Long version = null;
    @JsonProperty(value="items")
    private List<AlexaListItem> items = new ArrayList<AlexaListItem>();
    @JsonProperty(value="links")
    private Links links = null;

    private AlexaList() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AlexaList(Builder builder) {
        if (builder.listId != null) {
            this.listId = builder.listId;
        }
        if (builder.name != null) {
            this.name = builder.name;
        }
        if (builder.state != null) {
            this.state = builder.state;
        }
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.items != null) {
            this.items = builder.items;
        }
        if (builder.links != null) {
            this.links = builder.links;
        }
    }

    @JsonProperty(value="listId")
    public String getListId() {
        return this.listId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public ListState getState() {
        return ListState.fromValue(this.state);
    }

    @JsonProperty(value="state")
    public String getStateAsString() {
        return this.state;
    }

    @JsonProperty(value="version")
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="items")
    public List<AlexaListItem> getItems() {
        return this.items;
    }

    @JsonProperty(value="links")
    public Links getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlexaList servicesListManagementAlexaList = (AlexaList)o;
        return Objects.equals(this.listId, servicesListManagementAlexaList.listId) && Objects.equals(this.name, servicesListManagementAlexaList.name) && Objects.equals(this.state, servicesListManagementAlexaList.state) && Objects.equals(this.version, servicesListManagementAlexaList.version) && Objects.equals(this.items, servicesListManagementAlexaList.items) && Objects.equals(this.links, servicesListManagementAlexaList.links);
    }

    public int hashCode() {
        return Objects.hash(this.listId, this.name, this.state, this.version, this.items, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlexaList {\n");
        sb.append("    listId: ").append(this.toIndentedString(this.listId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String listId;
        private String name;
        private String state;
        private Long version;
        private List<AlexaListItem> items;
        private Links links;

        private Builder() {
        }

        @JsonProperty(value="listId")
        public Builder withListId(String listId) {
            this.listId = listId;
            return this;
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="state")
        public Builder withState(String state) {
            this.state = state;
            return this;
        }

        public Builder withState(ListState state) {
            this.state = state != null ? state.toString() : null;
            return this;
        }

        @JsonProperty(value="version")
        public Builder withVersion(Long version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="items")
        public Builder withItems(List<AlexaListItem> items) {
            this.items = items;
            return this;
        }

        public Builder addItemsItem(AlexaListItem itemsItem) {
            if (this.items == null) {
                this.items = new ArrayList<AlexaListItem>();
            }
            this.items.add(itemsItem);
            return this;
        }

        @JsonProperty(value="links")
        public Builder withLinks(Links links) {
            this.links = links;
            return this;
        }

        public AlexaList build() {
            return new AlexaList(this);
        }
    }
}

