/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.presentation.aplt;

import com.amazon.ask.model.Directive;
import com.amazon.ask.model.interfaces.alexa.presentation.aplt.TargetProfile;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class RenderDocumentDirective
extends Directive {
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="targetProfile")
    private TargetProfile targetProfile = null;
    @JsonProperty(value="document")
    private Map<String, Object> document = new HashMap<String, Object>();
    @JsonProperty(value="datasources")
    private Map<String, Object> datasources = new HashMap<String, Object>();

    private RenderDocumentDirective() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private RenderDocumentDirective(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Alexa.Presentation.APLT.RenderDocument";
        if (builder.token != null) {
            this.token = builder.token;
        }
        if (builder.targetProfile != null) {
            this.targetProfile = builder.targetProfile;
        }
        if (builder.document != null) {
            this.document = builder.document;
        }
        if (builder.datasources != null) {
            this.datasources = builder.datasources;
        }
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="targetProfile")
    public TargetProfile getTargetProfile() {
        return this.targetProfile;
    }

    @JsonProperty(value="document")
    public Map<String, Object> getDocument() {
        return this.document;
    }

    @JsonProperty(value="datasources")
    public Map<String, Object> getDatasources() {
        return this.datasources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderDocumentDirective interfacesAlexaPresentationApltRenderDocumentDirective = (RenderDocumentDirective)o;
        return Objects.equals(this.token, interfacesAlexaPresentationApltRenderDocumentDirective.token) && Objects.equals((Object)this.targetProfile, (Object)interfacesAlexaPresentationApltRenderDocumentDirective.targetProfile) && Objects.equals(this.document, interfacesAlexaPresentationApltRenderDocumentDirective.document) && Objects.equals(this.datasources, interfacesAlexaPresentationApltRenderDocumentDirective.datasources) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.token, this.targetProfile, this.document, this.datasources, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RenderDocumentDirective {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    targetProfile: ").append(this.toIndentedString((Object)this.targetProfile)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    datasources: ").append(this.toIndentedString(this.datasources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String token;
        private TargetProfile targetProfile;
        private Map<String, Object> document;
        private Map<String, Object> datasources;

        private Builder() {
        }

        @JsonProperty(value="token")
        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        @JsonProperty(value="targetProfile")
        public Builder withTargetProfile(TargetProfile targetProfile) {
            this.targetProfile = targetProfile;
            return this;
        }

        @JsonProperty(value="document")
        public Builder withDocument(Map<String, Object> document) {
            this.document = document;
            return this;
        }

        public Builder putDocumentItem(String key, Object documentItem) {
            if (this.document == null) {
                this.document = new HashMap<String, Object>();
            }
            this.document.put(key, documentItem);
            return this;
        }

        @JsonProperty(value="datasources")
        public Builder withDatasources(Map<String, Object> datasources) {
            this.datasources = datasources;
            return this;
        }

        public Builder putDatasourcesItem(String key, Object datasourcesItem) {
            if (this.datasources == null) {
                this.datasources = new HashMap<String, Object>();
            }
            this.datasources.put(key, datasourcesItem);
            return this;
        }

        public RenderDocumentDirective build() {
            return new RenderDocumentDirective(this);
        }
    }
}

