/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.SupportedInterfaces;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Device {
    @JsonProperty(value="deviceId")
    private String deviceId = null;
    @JsonProperty(value="persistentEndpointId")
    private String persistentEndpointId = null;
    @JsonProperty(value="supportedInterfaces")
    private SupportedInterfaces supportedInterfaces = null;

    private Device() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Device(Builder builder) {
        if (builder.deviceId != null) {
            this.deviceId = builder.deviceId;
        }
        if (builder.persistentEndpointId != null) {
            this.persistentEndpointId = builder.persistentEndpointId;
        }
        if (builder.supportedInterfaces != null) {
            this.supportedInterfaces = builder.supportedInterfaces;
        }
    }

    @JsonProperty(value="deviceId")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="persistentEndpointId")
    public String getPersistentEndpointId() {
        return this.persistentEndpointId;
    }

    @JsonProperty(value="supportedInterfaces")
    public SupportedInterfaces getSupportedInterfaces() {
        return this.supportedInterfaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        return Objects.equals(this.deviceId, device.deviceId) && Objects.equals(this.persistentEndpointId, device.persistentEndpointId) && Objects.equals(this.supportedInterfaces, device.supportedInterfaces);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.persistentEndpointId, this.supportedInterfaces);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Device {\n");
        sb.append("    deviceId: ").append(this.toIndentedString(this.deviceId)).append("\n");
        sb.append("    persistentEndpointId: ").append(this.toIndentedString(this.persistentEndpointId)).append("\n");
        sb.append("    supportedInterfaces: ").append(this.toIndentedString(this.supportedInterfaces)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String deviceId;
        private String persistentEndpointId;
        private SupportedInterfaces supportedInterfaces;

        private Builder() {
        }

        @JsonProperty(value="deviceId")
        public Builder withDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @JsonProperty(value="persistentEndpointId")
        public Builder withPersistentEndpointId(String persistentEndpointId) {
            this.persistentEndpointId = persistentEndpointId;
            return this;
        }

        @JsonProperty(value="supportedInterfaces")
        public Builder withSupportedInterfaces(SupportedInterfaces supportedInterfaces) {
            this.supportedInterfaces = supportedInterfaces;
            return this;
        }

        public Device build() {
            return new Device(this);
        }
    }
}

