/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.AbstractGitFlowMojo;
import com.amashchenko.maven.plugin.gitflow.GitFlowVersionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;

@Mojo(name="hotfix-start", aggregator=true)
public class GitFlowHotfixStartMojo
extends AbstractGitFlowMojo {
    @Parameter(property="pushRemote", defaultValue="false")
    private boolean pushRemote;
    @Parameter(property="fromBranch")
    private String fromBranch;
    @Parameter(property="hotfixVersion")
    private String hotfixVersion;
    @Parameter(property="useSnapshotInHotfix", defaultValue="false")
    private boolean useSnapshotInHotfix;
    @Parameter(property="hotfixVersionDigitToIncrement")
    private Integer hotfixVersionDigitToIncrement;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfiguration(new String[0]);
        try {
            boolean hotfixBranchExists;
            String currentVersion;
            String defaultVersion;
            this.initGitFlowConfig();
            this.checkUncommittedChanges();
            String branchName = this.gitFlowConfig.getProductionBranch();
            String supportBranchesStr = this.gitFindBranches(this.gitFlowConfig.getSupportBranchPrefix(), false);
            String[] supportBranches = StringUtils.isNotBlank((String)supportBranchesStr) ? supportBranchesStr.split("\\r?\\n") : null;
            if (this.settings.isInteractiveMode()) {
                if (supportBranches != null && supportBranches.length > 0) {
                    String[] branches = new String[supportBranches.length + 1];
                    for (int i = 0; i < supportBranches.length; ++i) {
                        branches[i] = supportBranches[i];
                    }
                    branches[supportBranches.length] = this.gitFlowConfig.getProductionBranch();
                    ArrayList<String> numberedList = new ArrayList<String>();
                    StringBuilder str = new StringBuilder("Branches:").append(LS);
                    for (int i = 0; i < branches.length; ++i) {
                        str.append(i + 1 + ". " + branches[i] + LS);
                        numberedList.add(String.valueOf(i + 1));
                    }
                    str.append("Choose branch to hotfix");
                    String branchNumber = null;
                    try {
                        while (StringUtils.isBlank(branchNumber)) {
                            branchNumber = this.prompter.prompt(str.toString(), numberedList);
                        }
                    }
                    catch (PrompterException e) {
                        throw new MojoFailureException("hotfix-start", (Throwable)e);
                    }
                    if (branchNumber != null) {
                        int num = Integer.parseInt(branchNumber);
                        branchName = branches[num - 1];
                    }
                    if (StringUtils.isBlank((String)branchName)) {
                        throw new MojoFailureException("Branch name is blank.");
                    }
                }
            } else if (StringUtils.isNotBlank((String)this.fromBranch)) {
                if (this.fromBranch.equals(this.gitFlowConfig.getProductionBranch()) || this.contains(supportBranches, this.fromBranch)) {
                    branchName = this.fromBranch;
                } else {
                    throw new MojoFailureException("The fromBranch is not production or support branch.");
                }
            }
            this.gitCheckout(branchName);
            if (this.fetchRemote) {
                this.gitFetchRemoteAndCompareCreate(branchName);
            }
            if ((defaultVersion = new GitFlowVersionInfo(currentVersion = this.getCurrentProjectVersion(), this.getVersionPolicy()).hotfixVersion(this.tychoBuild, this.hotfixVersionDigitToIncrement)) == null) {
                throw new MojoFailureException("Cannot get default next version.");
            }
            String version = null;
            if (this.settings.isInteractiveMode()) {
                try {
                    while (version == null) {
                        version = this.prompter.prompt("What is the hotfix version? [" + defaultVersion + "]");
                        if ("".equals(version) || GitFlowVersionInfo.isValidVersion(version) && this.validBranchName(version)) continue;
                        this.getLog().info((CharSequence)"The version is not valid.");
                        version = null;
                    }
                }
                catch (PrompterException e) {
                    throw new MojoFailureException("hotfix-start", (Throwable)e);
                }
            } else {
                if (!(!StringUtils.isNotBlank((String)this.hotfixVersion) || GitFlowVersionInfo.isValidVersion(this.hotfixVersion) && this.validBranchName(this.hotfixVersion))) {
                    throw new MojoFailureException("The hotfix version '" + this.hotfixVersion + "' is not valid.");
                }
                version = this.hotfixVersion;
            }
            if (StringUtils.isBlank(version)) {
                this.getLog().info((CharSequence)"Version is blank. Using default version.");
                version = defaultVersion;
            }
            String branchVersionPart = version.replace('/', '_');
            String hotfixBranchName = this.gitFlowConfig.getHotfixBranchPrefix() + branchVersionPart;
            if (!this.gitFlowConfig.getProductionBranch().equals(branchName)) {
                hotfixBranchName = this.gitFlowConfig.getHotfixBranchPrefix() + branchName + "/" + branchVersionPart;
            }
            if (hotfixBranchExists = this.gitCheckBranchExists(hotfixBranchName)) {
                throw new MojoFailureException("Hotfix branch with that name already exists. Cannot start hotfix.");
            }
            this.gitCreateAndCheckout(hotfixBranchName, branchName);
            if (!version.equals(currentVersion)) {
                String projectVersion = version;
                if (this.useSnapshotInHotfix && !ArtifactUtils.isSnapshot((String)version)) {
                    projectVersion = version + "-" + "SNAPSHOT";
                }
                if (this.useSnapshotInHotfix && this.mavenSession.getUserProperties().get("useSnapshotInHotfix") != null) {
                    this.getLog().warn((CharSequence)"The useSnapshotInHotfix parameter is set from the command line. Don't forget to use it in the finish goal as well. It is better to define it in the project's pom file.");
                }
                this.mvnSetVersions(projectVersion);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("version", projectVersion);
                this.gitCommit(this.commitMessages.getHotfixStartMessage(), properties);
            }
            if (this.installProject) {
                this.mvnCleanInstall();
            }
            if (this.pushRemote) {
                this.gitPush(hotfixBranchName, false);
            }
        }
        catch (VersionParseException | CommandLineException e) {
            throw new MojoFailureException("hotfix-start", e);
        }
    }

    private boolean contains(String[] arr, String str) {
        if (arr != null && str != null) {
            for (String a : arr) {
                if (!str.equals(a)) continue;
                return true;
            }
        }
        return false;
    }
}

