/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.concurrent;

import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.concurrent.ReentrantLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import sun.misc.Unsafe;

@Instrumented
public class Phaser {
    private volatile long state;
    private static final int MAX_PARTIES = 65535;
    private static final int MAX_PHASE = Integer.MAX_VALUE;
    private static final int PARTIES_SHIFT = 16;
    private static final int PHASE_SHIFT = 32;
    private static final int UNARRIVED_MASK = 65535;
    private static final long PARTIES_MASK = 0xFFFF0000L;
    private static final long TERMINATION_BIT = Long.MIN_VALUE;
    private static final int ONE_ARRIVAL = 1;
    private static final int ONE_PARTY = 65536;
    private static final int EMPTY = 1;
    private final Phaser parent;
    private final Phaser root;
    private final Lock mainLock = new ReentrantLock();
    private final AtomicReference<QNode> evenQ;
    private final AtomicReference<QNode> oddQ;
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int SPINS_PER_ARRIVAL = NCPU < 2 ? 1 : 256;
    private static final Unsafe UNSAFE;
    private static final long stateOffset;

    private static int unarrivedOf(long s) {
        int counts = (int)s;
        return counts == 1 ? 0 : counts & 0xFFFF;
    }

    private static int partiesOf(long s) {
        return (int)s >>> 16;
    }

    private static int phaseOf(long s) {
        return (int)(s >>> 32);
    }

    private static int arrivedOf(long s) {
        int counts = (int)s;
        return counts == 1 ? 0 : (counts >>> 16) - (counts & 0xFFFF);
    }

    private AtomicReference<QNode> queueFor(int phase) {
        return (phase & 1) == 0 ? this.evenQ : this.oddQ;
    }

    private String badArrive(long s) {
        return "Attempted arrival of unregistered party for " + this.stateToString(s);
    }

    private String badRegister(long s) {
        return "Attempt to register more than 65535 parties for " + this.stateToString(s);
    }

    private int doArrive(boolean deregister) {
        int unarrived;
        int phase;
        long s;
        int adj = deregister ? 65537 : 1;
        Phaser root = this.root;
        while (true) {
            s = root == this ? this.state : this.reconcileState();
            phase = (int)(s >>> 32);
            int counts = (int)s;
            unarrived = (counts & 0xFFFF) - 1;
            if (phase < 0) {
                return phase;
            }
            if (counts == 1 || unarrived < 0) {
                if (root != this && this.reconcileState() != s) continue;
                throw new IllegalStateException(this.badArrive(s));
            }
            if (UNSAFE.compareAndSwapLong(this, stateOffset, s, s -= (long)adj)) break;
        }
        if (unarrived == 0) {
            long n = s & 0xFFFF0000L;
            int nextUnarrived = (int)n >>> 16;
            if (root != this) {
                return this.parent.doArrive(nextUnarrived == 0);
            }
            n = this.onAdvance(phase, nextUnarrived) ? (n |= Long.MIN_VALUE) : (nextUnarrived == 0 ? (n |= 1L) : (n |= (long)nextUnarrived));
            UNSAFE.compareAndSwapLong(this, stateOffset, s, n |= (long)(phase + 1 & Integer.MAX_VALUE) << 32);
            this.releaseWaiters(phase);
        }
        return phase;
    }

    private long reconcileState() {
        Phaser root = this.root;
        long s = this.state;
        if (root != this) {
            int phase;
            while ((phase = (int)(root.state >>> 32)) != (int)(s >>> 32)) {
                int u;
                int p = (int)s >>> 16;
                if (UNSAFE.compareAndSwapLong(this, stateOffset, s, s = (long)phase << 32 | s & 0xFFFF0000L | (long)(p == 0 ? 1 : ((u = (int)s & 0xFFFF) == 0 ? p : u)))) break;
                s = this.state;
            }
        }
        return s;
    }

    public Phaser() {
        this(null, 0);
    }

    public Phaser(int parties) {
        this(null, parties);
    }

    public Phaser(Phaser parent) {
        this(parent, 0);
    }

    public Phaser(Phaser parent, int parties) {
        if (parties >>> 16 != 0) {
            throw new IllegalArgumentException("Illegal number of parties");
        }
        int phase = 0;
        this.parent = parent;
        if (parent != null) {
            Phaser root;
            this.root = root = parent.root;
            this.evenQ = root.evenQ;
            this.oddQ = root.oddQ;
            if (parties != 0) {
                try {
                    phase = parent.doRegister(1);
                }
                catch (SuspendExecution e) {
                    throw new AssertionError((Object)e);
                }
            }
        } else {
            this.root = this;
            this.evenQ = new AtomicReference();
            this.oddQ = new AtomicReference();
        }
        this.state = parties == 0 ? 1L : (long)phase << 32 | (long)parties << 16 | (long)parties;
    }

    public int arrive() {
        return this.doArrive(false);
    }

    public int arriveAndDeregister() {
        return this.doArrive(true);
    }

    public void forceTermination() {
        long s;
        Phaser root = this.root;
        while ((s = root.state) >= 0L) {
            if (!UNSAFE.compareAndSwapLong(root, stateOffset, s, s | Long.MIN_VALUE)) continue;
            this.releaseWaiters(0);
            this.releaseWaiters(1);
            return;
        }
    }

    public final int getPhase() {
        return (int)(this.root.state >>> 32);
    }

    public int getRegisteredParties() {
        return Phaser.partiesOf(this.state);
    }

    public int getArrivedParties() {
        return Phaser.arrivedOf(this.reconcileState());
    }

    public int getUnarrivedParties() {
        return Phaser.unarrivedOf(this.reconcileState());
    }

    public Phaser getParent() {
        return this.parent;
    }

    public Phaser getRoot() {
        return this.root;
    }

    public boolean isTerminated() {
        return this.root.state < 0L;
    }

    protected boolean onAdvance(int phase, int registeredParties) {
        return registeredParties == 0;
    }

    public String toString() {
        return this.stateToString(this.reconcileState());
    }

    private String stateToString(long s) {
        return super.toString() + "[phase = " + Phaser.phaseOf(s) + " parties = " + Phaser.partiesOf(s) + " arrived = " + Phaser.arrivedOf(s) + "]";
    }

    private void releaseWaiters(int phase) {
        QNode q;
        AtomicReference<QNode> head;
        AtomicReference<QNode> atomicReference = head = (phase & 1) == 0 ? this.evenQ : this.oddQ;
        while ((q = head.get()) != null && q.phase != (int)(this.root.state >>> 32)) {
            Strand t;
            if (!head.compareAndSet(q, q.next) || (t = q.strand) == null) continue;
            q.strand = null;
            Strand.unpark(t);
        }
    }

    private int abortWait(int phase) {
        AtomicReference<QNode> head = (phase & 1) == 0 ? this.evenQ : this.oddQ;
        while (true) {
            Strand t;
            QNode q = head.get();
            int p = (int)(this.root.state >>> 32);
            if (q == null || (t = q.strand) != null && q.phase == p) {
                return p;
            }
            if (!head.compareAndSet(q, q.next) || t == null) continue;
            q.strand = null;
            Strand.unpark(t);
        }
    }

    static {
        try {
            UNSAFE = UtilUnsafe.getUnsafe();
            Class<Phaser> k = Phaser.class;
            stateOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("state"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={417, 428, 431}, suspendableCallSitesOffsetsAfterInstr={349, 580, 772}, methodStart=402, methodEnd=444, methodOptimized=false)
    private int doRegister(int var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(suspendableCallSites={567}, suspendableCallSitesOffsetsAfterInstr={84}, methodStart=567, methodEnd=569, methodOptimized=false)
    public int register() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(suspendableCallSites={599}, suspendableCallSitesOffsetsAfterInstr={127}, methodStart=595, methodEnd=601, methodOptimized=false)
    public int bulkRegister(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(suspendableCallSites={677, 679}, suspendableCallSitesOffsetsAfterInstr={302, 434}, methodStart=663, methodEnd=697, methodOptimized=false)
    public int arriveAndAwaitAdvance() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(suspendableCallSites={722}, suspendableCallSitesOffsetsAfterInstr={213}, methodStart=716, methodEnd=725, methodOptimized=false)
    public int awaitAdvance(int var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(suspendableCallSites={754}, suspendableCallSitesOffsetsAfterInstr={260}, methodStart=747, methodEnd=760, methodOptimized=false)
    public int awaitAdvanceInterruptibly(int var1_1) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Suspendable
    @Instrumented(suspendableCallSites={795}, suspendableCallSitesOffsetsAfterInstr={328}, methodStart=787, methodEnd=803, methodOptimized=false)
    public int awaitAdvanceInterruptibly(int var1_1, long var2_2, TimeUnit var4_3) throws InterruptedException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={1084}, suspendableCallSitesOffsetsAfterInstr={432}, methodStart=1054, methodEnd=1100, methodOptimized=false)
    private int internalAwaitAdvance(int var1_1, QNode var2_2) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Instrumented
    static final class QNode {
        final Phaser phaser;
        final int phase;
        final boolean interruptible;
        final boolean timed;
        boolean wasInterrupted;
        long nanos;
        long lastTime;
        volatile Strand strand;
        QNode next;

        QNode(Phaser phaser, int phase, boolean interruptible, boolean timed, long nanos) {
            this.phaser = phaser;
            this.phase = phase;
            this.interruptible = interruptible;
            this.nanos = nanos;
            this.timed = timed;
            this.lastTime = timed ? System.nanoTime() : 0L;
            this.strand = Strand.currentStrand();
        }

        public boolean isReleasable() {
            if (this.strand == null) {
                return true;
            }
            if (this.phaser.getPhase() != this.phase) {
                this.strand = null;
                return true;
            }
            if (Strand.interrupted()) {
                this.wasInterrupted = true;
            }
            if (this.wasInterrupted && this.interruptible) {
                this.strand = null;
                return true;
            }
            if (this.timed) {
                if (this.nanos > 0L) {
                    long now = System.nanoTime();
                    this.nanos -= now - this.lastTime;
                    this.lastTime = now;
                }
                if (this.nanos <= 0L) {
                    this.strand = null;
                    return true;
                }
            }
            return false;
        }

        /*
         * Exception decompiling
         */
        @Instrumented(suspendableCallSites={1160, 1162}, suspendableCallSitesOffsetsAfterInstr={101, 156}, methodStart=1156, methodEnd=1163, methodOptimized=false)
        public boolean block() throws InterruptedException, SuspendExecution {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

