/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.AnnotationVisitor;
import co.paralleluniverse.asm.ClassVisitor;
import co.paralleluniverse.asm.Handle;
import co.paralleluniverse.asm.Label;
import co.paralleluniverse.asm.MethodVisitor;
import co.paralleluniverse.asm.tree.MethodNode;
import co.paralleluniverse.fibers.instrument.Classes;
import co.paralleluniverse.fibers.instrument.InstrumentMethod;
import co.paralleluniverse.fibers.instrument.MethodDatabase;
import java.util.ArrayList;
import java.util.List;

class SuspOffsetsAfterInstrClassVisitor
extends ClassVisitor {
    private final MethodDatabase db;
    private String sourceName;
    private String className;

    SuspOffsetsAfterInstrClassVisitor(ClassVisitor cv, MethodDatabase db) {
        super(327680, cv);
        this.db = db;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        if (version < 49) {
            version = 49;
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitSource(String source, String debug) {
        this.sourceName = source;
        super.visitSource(source, debug);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x100) == 0 && !Classes.isYieldMethod(this.className, name)) {
            final MethodNode mn = new MethodNode(access, name, desc, signature, exceptions);
            final MethodVisitor outMV = super.visitMethod(access, name, desc, signature, exceptions);
            return new MethodVisitor(327680, outMV){
                private Label currLabel;
                private int prevOffset;
                private boolean instrumented;
                private boolean optimized;
                private int methodStart;
                private int methodEnd;
                private List<Integer> suspOffsetsAfterInstrL;
                private int[] suspCallSites;
                {
                    super(x0, x1);
                    this.currLabel = null;
                    this.prevOffset = -1;
                    this.optimized = false;
                    this.methodStart = -1;
                    this.methodEnd = -1;
                    this.suspOffsetsAfterInstrL = new ArrayList<Integer>();
                    this.suspCallSites = new int[0];
                }

                @Override
                public AnnotationVisitor visitAnnotation(String adesc, boolean visible) {
                    if (Classes.INSTRUMENTED_DESC.equals(adesc)) {
                        this.instrumented = true;
                        return new AnnotationVisitor(327680){

                            @Override
                            public void visit(String name, Object value) {
                                if ("methodStart".equals(name)) {
                                    methodStart = (Integer)value;
                                } else if ("methodEnd".equals(name)) {
                                    methodEnd = (Integer)value;
                                } else if ("methodOptimized".equals(name)) {
                                    optimized = (Boolean)value;
                                } else if ("suspendableCallSites".equals(name)) {
                                    1.access$302(this, (int[])value);
                                } else if (!"suspendableCallSitesOffsetsAfterInstr".equals(name)) {
                                    throw new RuntimeException("Unexpected `@Instrumented` field: " + name);
                                }
                            }
                        };
                    }
                    return super.visitAnnotation(adesc, visible);
                }

                @Override
                public void visitLocalVariable(String name, String desc, String sig, Label lStart, Label lEnd, int slot) {
                    super.visitLocalVariable(name, desc, sig, lStart, lEnd, slot);
                }

                @Override
                public void visitLabel(Label label) {
                    if (this.instrumented) {
                        this.currLabel = label;
                    }
                    super.visitLabel(label);
                }

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
                    if (this.instrumented) {
                        int type = 5;
                        if (InstrumentMethod.isSuspendableCall(SuspOffsetsAfterInstrClassVisitor.this.db, 5, opcode, owner, name, desc) && !Classes.STACK_NAME.equals(owner) && this.currLabel != null && this.currLabel.info instanceof Integer) {
                            this.addLine();
                        }
                    }
                    super.visitMethodInsn(opcode, owner, name, desc, isInterface);
                }

                @Override
                public void visitInvokeDynamicInsn(String name, String desc, Handle handle, Object ... objects) {
                    if (this.instrumented) {
                        int type = 6;
                        int opcode = 186;
                        if (InstrumentMethod.isSuspendableCall(SuspOffsetsAfterInstrClassVisitor.this.db, 6, 186, handle.getOwner(), name, desc) && !Classes.STACK_NAME.equals(handle.getOwner()) && this.currLabel != null && this.currLabel.info instanceof Integer) {
                            this.addLine();
                        }
                    }
                    super.visitInvokeDynamicInsn(name, desc, handle, objects);
                }

                @Override
                public void visitEnd() {
                    if (this.instrumented) {
                        InstrumentMethod.emitInstrumentedAnn(SuspOffsetsAfterInstrClassVisitor.this.db, outMV, mn, SuspOffsetsAfterInstrClassVisitor.this.sourceName, SuspOffsetsAfterInstrClassVisitor.this.className, this.optimized, this.methodStart, this.methodEnd, this.suspCallSites, Classes.toIntArray(this.suspOffsetsAfterInstrL));
                    }
                    super.visitEnd();
                }

                private void addLine() {
                    int currOffset = (Integer)this.currLabel.info;
                    if (currOffset > this.prevOffset) {
                        this.suspOffsetsAfterInstrL.add(currOffset);
                        this.prevOffset = currOffset;
                    }
                }

                static /* synthetic */ int[] access$302(1 x0, int[] x1) {
                    x0.suspCallSites = x1;
                    return x1;
                }
            };
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }
}

