/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.data.record;

import co.paralleluniverse.data.record.Field;
import co.paralleluniverse.data.record.FieldNotFoundException;
import co.paralleluniverse.data.record.Record;
import co.paralleluniverse.data.record.RecordArray;
import co.paralleluniverse.data.record.RecordType;
import co.paralleluniverse.data.record.SimpleRecord;
import java.util.Arrays;
import java.util.Iterator;

class SimpleRecordArray<R>
implements RecordArray<R>,
Iterable<Record<R>>,
Cloneable {
    public final RecordType<R> type;
    public final int length;
    private final int osize;
    private final int bsize;
    private final int[] offsets;
    private final Object[] oa;
    private final byte[] ba;
    private final int offset;

    public SimpleRecordArray(RecordType<R> recordType, int length) {
        this.type = recordType;
        this.length = length;
        this.offsets = recordType.getOffsets();
        this.osize = recordType.getObjectIndex() > 0 ? recordType.getObjectOffset() : 0;
        this.bsize = recordType.getPrimitiveIndex() > 0 ? recordType.getPrimitiveOffset() : 0;
        this.oa = this.osize > 0 ? new Object[this.osize * length] : null;
        this.ba = this.bsize > 0 ? new byte[this.bsize * length] : null;
        this.offset = 0;
    }

    private SimpleRecordArray(SimpleRecordArray<R> other, int offset, int length, boolean copy) {
        this.type = other.type;
        this.length = length;
        this.offsets = other.offsets;
        this.osize = other.osize;
        this.bsize = other.bsize;
        if (copy) {
            this.oa = other.oa != null ? Arrays.copyOfRange(other.oa, offset * this.osize, (offset + length) * this.osize) : null;
            this.ba = other.ba != null ? Arrays.copyOfRange(other.ba, offset * this.bsize, (offset + length) * this.bsize) : null;
            this.offset = 0;
        } else {
            this.oa = other.oa;
            this.ba = other.ba;
            this.offset = offset;
        }
    }

    @Override
    public RecordType<R> type() {
        return this.type;
    }

    protected SimpleRecordArray<R> clone() {
        return new SimpleRecordArray<R>(this, this.offset, this.length, true);
    }

    @Override
    public RecordArray.Accessor newAccessor() {
        return new AccessorRecord<R>(this.type, this.offsets, this.oa, this.ba, this.osize, this.bsize, this.offset);
    }

    @Override
    public RecordArray.Accessor reset(RecordArray.Accessor accessor) {
        ((AccessorRecord)accessor).index = -1;
        return accessor;
    }

    @Override
    public Record<R> at(RecordArray.Accessor accessor, int index) {
        if (index < 0 || index >= this.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        AccessorRecord ar = (AccessorRecord)accessor;
        ar.index = index;
        return ar;
    }

    @Override
    public Record<R> at(int index) {
        return this.at(this.newAccessor(), index);
    }

    @Override
    public RecordArray<R> slice(int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("fromIndex(" + from + ") > toIndex(" + to + ")");
        }
        return new SimpleRecordArray<R>(this, this.offset + from, to - from, false);
    }

    public RecordArray<R> clear() {
        Arrays.fill(this.oa, this.offset * this.osize, (this.offset + this.length) * this.osize, null);
        Arrays.fill(this.ba, this.offset * this.bsize, (this.offset + this.length) * this.bsize, (byte)0);
        return this;
    }

    @Override
    public Iterator<Record<R>> iterator() {
        return new Iterator<Record<R>>(){
            private final AccessorRecord<R> acc;
            {
                this.acc = (AccessorRecord)SimpleRecordArray.this.newAccessor();
            }

            @Override
            public boolean hasNext() {
                return this.acc.index + 1 < SimpleRecordArray.this.length;
            }

            @Override
            public Record<R> next() {
                ++this.acc.index;
                return this.acc;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class AccessorRecord<R>
    extends SimpleRecord<R>
    implements RecordArray.Accessor {
        private final int osize;
        private final int bsize;
        private final int offset;
        int index;

        public AccessorRecord(RecordType<R> recordType, int[] offsets, Object[] oa, byte[] ba, int osize, int bsize, int offset) {
            super(recordType, offsets, oa, ba);
            this.osize = osize;
            this.bsize = bsize;
            this.index = -1;
            this.offset = offset;
        }

        @Override
        int fieldOffset(Field<? super R, ?> field) {
            try {
                int stride = field.type() == 9 || field.type() == 19 ? this.osize : this.bsize;
                return (this.index + this.offset) * stride + this.offsets[field.id];
            }
            catch (IndexOutOfBoundsException e) {
                if (this.index < 0) {
                    throw new IllegalStateException("Accessor not pointing at an element");
                }
                throw new FieldNotFoundException(field, this);
            }
        }
    }
}

