/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.data.record;

import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.data.record.AbstractRecord;
import co.paralleluniverse.data.record.DynamicRecord;
import co.paralleluniverse.data.record.Field;
import co.paralleluniverse.data.record.FieldNotFoundException;
import co.paralleluniverse.data.record.Record;
import co.paralleluniverse.data.record.RecordType;
import java.util.Arrays;
import sun.misc.Unsafe;

class SimpleRecord<R>
extends AbstractRecord<R>
implements Record<R>,
Cloneable {
    final int[] offsets;
    private final Object[] oa;
    private final byte[] ba;
    static final Unsafe unsafe = UtilUnsafe.getUnsafe();
    private static final int base;
    private static final int baseLong;
    private static final int shift;
    private static final int BOOLEAN_SHIFT = 0;
    private static final int BYTE_SHIFT = 0;
    private static final int SHORT_SHIFT = 1;
    private static final int CHAR_SHIFT = 1;
    private static final int INT_SHIFT = 2;
    private static final int FLOAT_SHIFT = 2;
    private static final int LONG_SHIFT = 3;
    private static final int DOUBLE_SHIFT = 3;

    public SimpleRecord(RecordType<R> recordType) {
        super(recordType);
        this.offsets = recordType.getOffsets();
        this.oa = recordType.getObjectIndex() > 0 ? new Object[recordType.getObjectOffset()] : null;
        this.ba = recordType.getPrimitiveIndex() > 0 ? new byte[recordType.getPrimitiveOffset()] : null;
    }

    SimpleRecord(RecordType<R> recordType, int[] offsets, Object[] oa, byte[] ba) {
        super(recordType);
        this.offsets = offsets;
        this.oa = oa;
        this.ba = ba;
    }

    private SimpleRecord(SimpleRecord<R> other) {
        super(other.type);
        this.offsets = other.offsets;
        this.oa = other.oa != null ? Arrays.copyOf(other.oa, other.oa.length) : null;
        this.ba = other.ba != null ? Arrays.copyOf(other.ba, other.ba.length) : null;
    }

    protected SimpleRecord<R> clone() {
        return new SimpleRecord<R>(this);
    }

    int fieldOffset(Field<? super R, ?> field) {
        try {
            return this.offsets[field.id];
        }
        catch (IndexOutOfBoundsException e) {
            throw new FieldNotFoundException(field, this);
        }
    }

    @Override
    public <V> V get(Field.ObjectField<? super R, V> field) {
        return (V)this.oa[this.fieldOffset(field)];
    }

    @Override
    public <V> void set(Field.ObjectField<? super R, V> field, V value) {
        this.oa[this.fieldOffset(field)] = value;
    }

    @Override
    public <V> V get(Field.ObjectArrayField<? super R, V> field, int index) {
        if (index < 0 || index > field.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (V)this.oa[this.fieldOffset(field) + index];
    }

    @Override
    public <V> void set(Field.ObjectArrayField<? super R, V> field, int index, V value) {
        if (index < 0 || index > field.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.oa[this.fieldOffset(field) + index] = value;
    }

    @Override
    public <V> void get(Field.ObjectArrayField<? super R, V> field, V[] target, int offset) {
        System.arraycopy(this.oa, this.fieldOffset(field), target, offset, field.length);
    }

    @Override
    public <V> void set(Field.ObjectArrayField<? super R, V> field, V[] source, int offset) {
        System.arraycopy(source, offset, this.oa, this.fieldOffset(field), field.length);
    }

    @Override
    public <S, V> void set(Field.ObjectArrayField<? super R, V> field, Record<S> source, Field.ObjectArrayField<? super S, V> sourceField) {
        int i;
        this.boundsCheck(field);
        V[] array = null;
        if (source instanceof SimpleRecord) {
            System.arraycopy(((SimpleRecord)source).oa, ((SimpleRecord)source).fieldOffset(sourceField), this.oa, this.fieldOffset(field), field.length);
        } else if (source instanceof DynamicRecord && (array = ((DynamicRecord)source).get(sourceField)) != null) {
            System.arraycopy(array, 0, this.oa, this.fieldOffset(field), field.length);
        } else {
            for (i = 0; i < field.length; ++i) {
                this.oa[this.fieldOffset(field) + i] = source.get(sourceField, i);
            }
        }
        for (i = 0; i < field.length; ++i) {
            this.oa[this.fieldOffset(field) + i] = source.get(sourceField, i);
        }
    }

    private void boundsCheck(Field field) {
    }

    private void boundsCheck(Field.ArrayField field, int index) {
        this.boundsCheck(field);
        if (index < 0 || index >= field.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    @Override
    public boolean get(Field.BooleanField<? super R> field) {
        this.boundsCheck(field);
        return SimpleRecord.getBoolean(this.ba, this.fieldOffset(field));
    }

    @Override
    public void set(Field.BooleanField<? super R> field, boolean value) {
        this.boundsCheck(field);
        SimpleRecord.setBoolean(this.ba, this.fieldOffset(field), value);
    }

    @Override
    public byte get(Field.ByteField<? super R> field) {
        this.boundsCheck(field);
        return SimpleRecord.getByte(this.ba, this.fieldOffset(field));
    }

    @Override
    public void set(Field.ByteField<? super R> field, byte value) {
        this.boundsCheck(field);
        SimpleRecord.setByte(this.ba, this.fieldOffset(field), value);
    }

    @Override
    public short get(Field.ShortField<? super R> field) {
        this.boundsCheck(field);
        return SimpleRecord.getShort(this.ba, this.fieldOffset(field));
    }

    @Override
    public void set(Field.ShortField<? super R> field, short value) {
        this.boundsCheck(field);
        SimpleRecord.setShort(this.ba, this.fieldOffset(field), value);
    }

    @Override
    public int get(Field.IntField<? super R> field) {
        this.boundsCheck(field);
        return SimpleRecord.getInt(this.ba, this.fieldOffset(field));
    }

    @Override
    public void set(Field.IntField<? super R> field, int value) {
        this.boundsCheck(field);
        SimpleRecord.setInt(this.ba, this.fieldOffset(field), value);
    }

    @Override
    public long get(Field.LongField<? super R> field) {
        this.boundsCheck(field);
        return SimpleRecord.getLong(this.ba, this.fieldOffset(field));
    }

    @Override
    public void set(Field.LongField<? super R> field, long value) {
        this.boundsCheck(field);
        SimpleRecord.setLong(this.ba, this.fieldOffset(field), value);
    }

    @Override
    public float get(Field.FloatField<? super R> field) {
        this.boundsCheck(field);
        return SimpleRecord.getFloat(this.ba, this.fieldOffset(field));
    }

    @Override
    public void set(Field.FloatField<? super R> field, float value) {
        this.boundsCheck(field);
        SimpleRecord.setFloat(this.ba, this.fieldOffset(field), value);
    }

    @Override
    public double get(Field.DoubleField<? super R> field) {
        this.boundsCheck(field);
        return SimpleRecord.getDouble(this.ba, this.fieldOffset(field));
    }

    @Override
    public void set(Field.DoubleField<? super R> field, double value) {
        this.boundsCheck(field);
        SimpleRecord.setDouble(this.ba, this.fieldOffset(field), value);
    }

    @Override
    public char get(Field.CharField<? super R> field) {
        this.boundsCheck(field);
        return SimpleRecord.getChar(this.ba, this.fieldOffset(field));
    }

    @Override
    public void set(Field.CharField<? super R> field, char value) {
        this.boundsCheck(field);
        SimpleRecord.setChar(this.ba, this.fieldOffset(field), value);
    }

    @Override
    public boolean get(Field.BooleanArrayField<? super R> field, int index) {
        this.boundsCheck(field, index);
        return SimpleRecord.getBoolean(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 0));
    }

    @Override
    public void set(Field.BooleanArrayField<? super R> field, int index, boolean value) {
        this.boundsCheck(field, index);
        SimpleRecord.setBoolean(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 0), value);
    }

    @Override
    public void get(Field.BooleanArrayField<? super R> field, boolean[] target, int offset) {
        this.boundsCheck(field);
        SimpleRecord.getArray(this.ba, this.fieldOffset(field), target, offset, field.length, 0);
    }

    @Override
    public void set(Field.BooleanArrayField<? super R> field, boolean[] source, int offset) {
        this.boundsCheck(field);
        SimpleRecord.setArray(this.ba, this.fieldOffset(field), source, offset, field.length, 0);
    }

    @Override
    public <S> void set(Field.BooleanArrayField<? super R> field, Record<S> source, Field.BooleanArrayField<? super S> sourceField) {
        this.boundsCheck(field);
        boolean[] array = null;
        if (source instanceof SimpleRecord) {
            System.arraycopy(((SimpleRecord)source).ba, ((SimpleRecord)source).fieldOffset(sourceField), this.ba, this.fieldOffset(field), field.length << 0);
        } else if (source instanceof DynamicRecord && (array = ((DynamicRecord)source).get(sourceField)) != null) {
            SimpleRecord.setArray(this.ba, this.fieldOffset(field), array, 0, field.length, 0);
        } else {
            for (int i = 0; i < field.length; ++i) {
                SimpleRecord.setBoolean(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(i, 0), source.get(sourceField, i));
            }
        }
    }

    @Override
    public byte get(Field.ByteArrayField<? super R> field, int index) {
        this.boundsCheck(field, index);
        return SimpleRecord.getByte(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 0));
    }

    @Override
    public void set(Field.ByteArrayField<? super R> field, int index, byte value) {
        this.boundsCheck(field, index);
        SimpleRecord.setByte(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 0), value);
    }

    @Override
    public void get(Field.ByteArrayField<? super R> field, byte[] target, int offset) {
        this.boundsCheck(field);
        SimpleRecord.getArray(this.ba, this.fieldOffset(field), target, offset, field.length, 0);
    }

    @Override
    public void set(Field.ByteArrayField<? super R> field, byte[] source, int offset) {
        this.boundsCheck(field);
        SimpleRecord.setArray(this.ba, this.fieldOffset(field), source, offset, field.length, 0);
    }

    @Override
    public <S> void set(Field.ByteArrayField<? super R> field, Record<S> source, Field.ByteArrayField<? super S> sourceField) {
        this.boundsCheck(field);
        byte[] array = null;
        if (source instanceof SimpleRecord) {
            System.arraycopy(((SimpleRecord)source).ba, ((SimpleRecord)source).fieldOffset(sourceField), this.ba, this.fieldOffset(field), field.length << 0);
        } else if (source instanceof DynamicRecord && (array = ((DynamicRecord)source).get(sourceField)) != null) {
            SimpleRecord.setArray(this.ba, this.fieldOffset(field), array, 0, field.length, 0);
        } else {
            for (int i = 0; i < field.length; ++i) {
                SimpleRecord.setByte(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(i, 0), source.get(sourceField, i));
            }
        }
    }

    @Override
    public short get(Field.ShortArrayField<? super R> field, int index) {
        this.boundsCheck(field, index);
        return SimpleRecord.getShort(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 1));
    }

    @Override
    public void set(Field.ShortArrayField<? super R> field, int index, short value) {
        this.boundsCheck(field, index);
        SimpleRecord.setShort(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 1), value);
    }

    @Override
    public void get(Field.ShortArrayField<? super R> field, short[] target, int offset) {
        this.boundsCheck(field);
        SimpleRecord.getArray(this.ba, this.fieldOffset(field), target, offset, field.length, 1);
    }

    @Override
    public void set(Field.ShortArrayField<? super R> field, short[] source, int offset) {
        this.boundsCheck(field);
        SimpleRecord.setArray(this.ba, this.fieldOffset(field), source, offset, field.length, 1);
    }

    @Override
    public <S> void set(Field.ShortArrayField<? super R> field, Record<S> source, Field.ShortArrayField<? super S> sourceField) {
        this.boundsCheck(field);
        short[] array = null;
        if (source instanceof SimpleRecord) {
            System.arraycopy(((SimpleRecord)source).ba, ((SimpleRecord)source).fieldOffset(sourceField), this.ba, this.fieldOffset(field), field.length << 1);
        } else if (source instanceof DynamicRecord && (array = ((DynamicRecord)source).get(sourceField)) != null) {
            SimpleRecord.setArray(this.ba, this.fieldOffset(field), array, 0, field.length, 1);
        } else {
            for (int i = 0; i < field.length; ++i) {
                SimpleRecord.setShort(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(i, 1), source.get(sourceField, i));
            }
        }
    }

    @Override
    public int get(Field.IntArrayField<? super R> field, int index) {
        this.boundsCheck(field, index);
        return SimpleRecord.getInt(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 2));
    }

    @Override
    public void set(Field.IntArrayField<? super R> field, int index, int value) {
        this.boundsCheck(field, index);
        SimpleRecord.setInt(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 2), value);
    }

    @Override
    public void get(Field.IntArrayField<? super R> field, int[] target, int offset) {
        this.boundsCheck(field);
        SimpleRecord.getArray(this.ba, this.fieldOffset(field), target, offset, field.length, 2);
    }

    @Override
    public void set(Field.IntArrayField<? super R> field, int[] source, int offset) {
        this.boundsCheck(field);
        SimpleRecord.setArray(this.ba, this.fieldOffset(field), source, offset, field.length, 2);
    }

    @Override
    public <S> void set(Field.IntArrayField<? super R> field, Record<S> source, Field.IntArrayField<? super S> sourceField) {
        this.boundsCheck(field);
        int[] array = null;
        if (source instanceof SimpleRecord) {
            System.arraycopy(((SimpleRecord)source).ba, ((SimpleRecord)source).fieldOffset(sourceField), this.ba, this.fieldOffset(field), field.length << 2);
        } else if (source instanceof DynamicRecord && (array = ((DynamicRecord)source).get(sourceField)) != null) {
            SimpleRecord.setArray(this.ba, this.fieldOffset(field), array, 0, field.length, 2);
        } else {
            for (int i = 0; i < field.length; ++i) {
                SimpleRecord.setInt(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(i, 2), source.get(sourceField, i));
            }
        }
    }

    @Override
    public long get(Field.LongArrayField<? super R> field, int index) {
        this.boundsCheck(field, index);
        return SimpleRecord.getLong(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 3));
    }

    @Override
    public void set(Field.LongArrayField<? super R> field, int index, long value) {
        this.boundsCheck(field, index);
        SimpleRecord.setLong(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 3), value);
    }

    @Override
    public void get(Field.LongArrayField<? super R> field, long[] target, int offset) {
        this.boundsCheck(field);
        SimpleRecord.getArrayLong(this.ba, this.fieldOffset(field), target, offset, field.length, 3);
    }

    @Override
    public void set(Field.LongArrayField<? super R> field, long[] source, int offset) {
        this.boundsCheck(field);
        SimpleRecord.setArrayLong(this.ba, this.fieldOffset(field), source, offset, field.length, 3);
    }

    @Override
    public <S> void set(Field.LongArrayField<? super R> field, Record<S> source, Field.LongArrayField<? super S> sourceField) {
        this.boundsCheck(field);
        long[] array = null;
        if (source instanceof SimpleRecord) {
            System.arraycopy(((SimpleRecord)source).ba, ((SimpleRecord)source).fieldOffset(sourceField), this.ba, this.fieldOffset(field), field.length << 3);
        } else if (source instanceof DynamicRecord && (array = ((DynamicRecord)source).get(sourceField)) != null) {
            SimpleRecord.setArrayLong(this.ba, this.fieldOffset(field), array, 0, field.length, 3);
        } else {
            for (int i = 0; i < field.length; ++i) {
                SimpleRecord.setLong(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(i, 3), source.get(sourceField, i));
            }
        }
    }

    @Override
    public float get(Field.FloatArrayField<? super R> field, int index) {
        this.boundsCheck(field, index);
        return SimpleRecord.getFloat(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 2));
    }

    @Override
    public void set(Field.FloatArrayField<? super R> field, int index, float value) {
        this.boundsCheck(field, index);
        SimpleRecord.setFloat(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 2), value);
    }

    @Override
    public void get(Field.FloatArrayField<? super R> field, float[] target, int offset) {
        this.boundsCheck(field);
        SimpleRecord.getArray(this.ba, this.fieldOffset(field), target, offset, field.length, 2);
    }

    @Override
    public void set(Field.FloatArrayField<? super R> field, float[] source, int offset) {
        this.boundsCheck(field);
        SimpleRecord.setArray(this.ba, this.fieldOffset(field), source, offset, field.length, 2);
    }

    @Override
    public <S> void set(Field.FloatArrayField<? super R> field, Record<S> source, Field.FloatArrayField<? super S> sourceField) {
        this.boundsCheck(field);
        float[] array = null;
        if (source instanceof SimpleRecord) {
            System.arraycopy(((SimpleRecord)source).ba, ((SimpleRecord)source).fieldOffset(sourceField), this.ba, this.fieldOffset(field), field.length << 2);
        } else if (source instanceof DynamicRecord && (array = ((DynamicRecord)source).get(sourceField)) != null) {
            SimpleRecord.setArray(this.ba, this.fieldOffset(field), array, 0, field.length, 2);
        } else {
            for (int i = 0; i < field.length; ++i) {
                SimpleRecord.setFloat(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(i, 2), source.get(sourceField, i));
            }
        }
    }

    @Override
    public double get(Field.DoubleArrayField<? super R> field, int index) {
        this.boundsCheck(field, index);
        return SimpleRecord.getDouble(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 3));
    }

    @Override
    public void set(Field.DoubleArrayField<? super R> field, int index, double value) {
        this.boundsCheck(field, index);
        SimpleRecord.setDouble(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 3), value);
    }

    @Override
    public void get(Field.DoubleArrayField<? super R> field, double[] target, int offset) {
        this.boundsCheck(field);
        SimpleRecord.getArrayLong(this.ba, this.fieldOffset(field), target, offset, field.length, 3);
    }

    @Override
    public void set(Field.DoubleArrayField<? super R> field, double[] source, int offset) {
        this.boundsCheck(field);
        SimpleRecord.setArrayLong(this.ba, this.fieldOffset(field), source, offset, field.length, 3);
    }

    @Override
    public <S> void set(Field.DoubleArrayField<? super R> field, Record<S> source, Field.DoubleArrayField<? super S> sourceField) {
        this.boundsCheck(field);
        double[] array = null;
        if (source instanceof SimpleRecord) {
            System.arraycopy(((SimpleRecord)source).ba, ((SimpleRecord)source).fieldOffset(sourceField), this.ba, this.fieldOffset(field), field.length << 3);
        } else if (source instanceof DynamicRecord && (array = ((DynamicRecord)source).get(sourceField)) != null) {
            SimpleRecord.setArrayLong(this.ba, this.fieldOffset(field), array, 0, field.length, 3);
        } else {
            for (int i = 0; i < field.length; ++i) {
                SimpleRecord.setDouble(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(i, 3), source.get(sourceField, i));
            }
        }
    }

    @Override
    public char get(Field.CharArrayField<? super R> field, int index) {
        this.boundsCheck(field, index);
        return SimpleRecord.getChar(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 1));
    }

    @Override
    public void set(Field.CharArrayField<? super R> field, int index, char value) {
        this.boundsCheck(field, index);
        SimpleRecord.setChar(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(index, 1), value);
    }

    @Override
    public void get(Field.CharArrayField<? super R> field, char[] target, int offset) {
        this.boundsCheck(field);
        SimpleRecord.getArray(this.ba, this.fieldOffset(field), target, offset, field.length, 1);
    }

    @Override
    public void set(Field.CharArrayField<? super R> field, char[] source, int offset) {
        this.boundsCheck(field);
        SimpleRecord.setArray(this.ba, this.fieldOffset(field), source, offset, field.length, 1);
    }

    @Override
    public <S> void set(Field.CharArrayField<? super R> field, Record<S> source, Field.CharArrayField<? super S> sourceField) {
        this.boundsCheck(field);
        char[] array = null;
        if (source instanceof SimpleRecord) {
            System.arraycopy(((SimpleRecord)source).ba, ((SimpleRecord)source).fieldOffset(sourceField), this.ba, this.fieldOffset(field), field.length << 1);
        } else if (source instanceof DynamicRecord && (array = ((DynamicRecord)source).get(sourceField)) != null) {
            SimpleRecord.setArray(this.ba, this.fieldOffset(field), array, 0, field.length, 1);
        } else {
            for (int i = 0; i < field.length; ++i) {
                SimpleRecord.setChar(this.ba, (long)this.fieldOffset(field) + SimpleRecord.offset(i, 1), source.get(sourceField, i));
            }
        }
    }

    private static long byteOffset(long i) {
        return (long)base + i;
    }

    private static long offset(long index, int typeSizeShift) {
        return index << typeSizeShift;
    }

    private static boolean getBoolean(byte[] array, long i) {
        return unsafe.getBoolean(array, SimpleRecord.byteOffset(i));
    }

    private static void setBoolean(byte[] array, long i, boolean value) {
        unsafe.putBoolean(array, SimpleRecord.byteOffset(i), value);
    }

    private static byte getByte(byte[] array, long i) {
        return unsafe.getByte(array, SimpleRecord.byteOffset(i));
    }

    private static void setByte(byte[] array, long i, byte value) {
        unsafe.putByte(array, SimpleRecord.byteOffset(i), value);
    }

    private static short getShort(byte[] array, long i) {
        return unsafe.getShort(array, SimpleRecord.byteOffset(i));
    }

    private static void setShort(byte[] array, long i, short value) {
        unsafe.putShort(array, SimpleRecord.byteOffset(i), value);
    }

    private static int getInt(byte[] array, long i) {
        return unsafe.getInt(array, SimpleRecord.byteOffset(i));
    }

    private static void setInt(byte[] array, long i, int value) {
        unsafe.putInt(array, SimpleRecord.byteOffset(i), value);
    }

    private static long getLong(byte[] array, long i) {
        return unsafe.getLong(array, SimpleRecord.byteOffset(i));
    }

    private static void setLong(byte[] array, long i, long value) {
        unsafe.putLong(array, SimpleRecord.byteOffset(i), value);
    }

    private static char getChar(byte[] array, long i) {
        return unsafe.getChar(array, SimpleRecord.byteOffset(i));
    }

    private static void setChar(byte[] array, long i, char value) {
        unsafe.putChar(array, SimpleRecord.byteOffset(i), value);
    }

    private static float getFloat(byte[] array, long i) {
        return unsafe.getFloat(array, SimpleRecord.byteOffset(i));
    }

    private static void setFloat(byte[] array, long i, float value) {
        unsafe.putFloat(array, SimpleRecord.byteOffset(i), value);
    }

    private static double getDouble(byte[] array, long i) {
        return unsafe.getDouble(array, SimpleRecord.byteOffset(i));
    }

    private static void setDouble(byte[] array, long i, double value) {
        unsafe.putDouble(array, SimpleRecord.byteOffset(i), value);
    }

    private static void getArray(byte[] array, long i, Object target, int offset, int length, int shift) {
        unsafe.copyMemory(array, SimpleRecord.byteOffset(i), target, base + (offset << shift), length << shift);
    }

    private static void setArray(byte[] array, long i, Object source, int offset, int length, int shift) {
        unsafe.copyMemory(source, base + (offset << shift), array, SimpleRecord.byteOffset(i), length << shift);
    }

    private static void getArrayLong(byte[] array, long i, Object target, int offset, int length, int shift) {
        unsafe.copyMemory(array, SimpleRecord.byteOffset(i), target, baseLong + (offset << shift), length << shift);
    }

    private static void setArrayLong(byte[] array, long i, Object source, int offset, int length, int shift) {
        unsafe.copyMemory(source, baseLong + (offset << shift), array, SimpleRecord.byteOffset(i), length << shift);
    }

    static {
        try {
            if (unsafe.arrayIndexScale(boolean[].class) != 1) {
                throw new AssertionError((Object)("Strange boolean array scale: " + unsafe.arrayIndexScale(boolean[].class)));
            }
            if (unsafe.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError((Object)("Strange byte array scale: " + unsafe.arrayIndexScale(byte[].class)));
            }
            if (unsafe.arrayIndexScale(short[].class) != 2) {
                throw new AssertionError((Object)("Strange short array scale: " + unsafe.arrayIndexScale(short[].class)));
            }
            if (unsafe.arrayIndexScale(char[].class) != 2) {
                throw new AssertionError((Object)("Strange char array scale: " + unsafe.arrayIndexScale(char[].class)));
            }
            if (unsafe.arrayIndexScale(int[].class) != 4) {
                throw new AssertionError((Object)("Strange int array scale: " + unsafe.arrayIndexScale(int[].class)));
            }
            if (unsafe.arrayIndexScale(float[].class) != 4) {
                throw new AssertionError((Object)("Strange float array scale: " + unsafe.arrayIndexScale(float[].class)));
            }
            if (unsafe.arrayIndexScale(long[].class) != 8) {
                throw new AssertionError((Object)("Strange long array scale: " + unsafe.arrayIndexScale(long[].class)));
            }
            if (unsafe.arrayIndexScale(double[].class) != 8) {
                throw new AssertionError((Object)("Strange double array scale: " + unsafe.arrayIndexScale(double[].class)));
            }
            base = unsafe.arrayBaseOffset(byte[].class);
            baseLong = unsafe.arrayBaseOffset(long[].class);
            if (unsafe.arrayBaseOffset(boolean[].class) != base) {
                throw new AssertionError((Object)"different array base");
            }
            if (unsafe.arrayBaseOffset(short[].class) != base) {
                throw new AssertionError((Object)"different array base");
            }
            if (unsafe.arrayBaseOffset(char[].class) != base) {
                throw new AssertionError((Object)"different array base");
            }
            if (unsafe.arrayBaseOffset(int[].class) != base) {
                throw new AssertionError((Object)"different array base");
            }
            if (unsafe.arrayBaseOffset(float[].class) != base) {
                throw new AssertionError((Object)"different array base");
            }
            if (unsafe.arrayBaseOffset(long[].class) != baseLong) {
                throw new AssertionError((Object)"different array base");
            }
            if (unsafe.arrayBaseOffset(double[].class) != baseLong) {
                throw new AssertionError((Object)"different array base");
            }
            int scale = unsafe.arrayIndexScale(byte[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            shift = 31 - Integer.numberOfLeadingZeros(scale);
            if (scale != 1 || shift != 0) {
                throw new AssertionError((Object)"Strange byte array alignment");
            }
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

