/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.data.record;

import co.paralleluniverse.data.record.Field;
import co.paralleluniverse.data.record.FieldNotFoundException;
import co.paralleluniverse.data.record.Record;
import co.paralleluniverse.data.record.RecordArray;
import co.paralleluniverse.data.record.RecordDelegate;
import co.paralleluniverse.data.record.SimpleRecordArray;
import java.util.Collection;
import java.util.Objects;

public final class Records {
    public static <R> Record<R> delegate(Object owner, Record<R> record) {
        return new RecordDelegate<R>(owner, record);
    }

    public static <R> void setDelegateTarget(Record<R> record, Object owner, Record<R> newDelegate) {
        if (!(record instanceof RecordDelegate)) {
            throw new UnsupportedOperationException("Record " + record + " is not a record delegate");
        }
        ((RecordDelegate)record).setDelegate(owner, newDelegate);
    }

    public static <R> Record<R> getDelegateTarget(Record<R> record, Object owner) {
        if (!(record instanceof RecordDelegate)) {
            return record;
        }
        return ((RecordDelegate)record).getDelegate(owner);
    }

    public static <R> void copy(Record<R> source, Record<R> target) {
        Records.copy(source, target, true);
    }

    public static <R> void copy(Record<R> source, Record<R> target, boolean copyTransient) {
        Records.copy(source, target, target.fields());
    }

    public static <R> void copy(Record<R> source, Record<R> target, Collection<Field<? super R, ?>> fields) {
        Records.copy(source, target, fields, true);
    }

    public static <R> void copy(Record<R> source, Record<R> target, Collection<Field<? super R, ?>> fields, boolean copyTransient) {
        for (Field<R, ?> field : fields) {
            if (!copyTransient && field.isTransient()) continue;
            try {
                switch (field.type()) {
                    case 1: {
                        target.set((Field.BooleanField)field, source.get((Field.BooleanField)field));
                        break;
                    }
                    case 2: {
                        target.set((Field.ByteField)field, source.get((Field.ByteField)field));
                        break;
                    }
                    case 3: {
                        target.set((Field.ShortField)field, source.get((Field.ShortField)field));
                        break;
                    }
                    case 4: {
                        target.set((Field.IntField)field, source.get((Field.IntField)field));
                        break;
                    }
                    case 5: {
                        target.set((Field.LongField)field, source.get((Field.LongField)field));
                        break;
                    }
                    case 6: {
                        target.set((Field.FloatField)field, source.get((Field.FloatField)field));
                        break;
                    }
                    case 7: {
                        target.set((Field.DoubleField)field, source.get((Field.DoubleField)field));
                        break;
                    }
                    case 8: {
                        target.set((Field.CharField)field, source.get((Field.CharField)field));
                        break;
                    }
                    case 9: {
                        target.set((Field.ObjectField)field, source.get((Field.ObjectField)field));
                        break;
                    }
                    case 11: {
                        target.set((Field.BooleanArrayField)field, source, (Field.BooleanArrayField)field);
                        break;
                    }
                    case 12: {
                        target.set((Field.ByteArrayField)field, source, (Field.ByteArrayField)field);
                        break;
                    }
                    case 13: {
                        target.set((Field.ShortArrayField)field, source, (Field.ShortArrayField)field);
                        break;
                    }
                    case 14: {
                        target.set((Field.IntArrayField)field, source, (Field.IntArrayField)field);
                        break;
                    }
                    case 15: {
                        target.set((Field.LongArrayField)field, source, (Field.LongArrayField)field);
                        break;
                    }
                    case 16: {
                        target.set((Field.FloatArrayField)field, source, (Field.FloatArrayField)field);
                        break;
                    }
                    case 17: {
                        target.set((Field.DoubleArrayField)field, source, (Field.DoubleArrayField)field);
                        break;
                    }
                    case 18: {
                        target.set((Field.CharArrayField)field, source, (Field.CharArrayField)field);
                        break;
                    }
                    case 19: {
                        target.set((Field.ObjectArrayField)field, source, (Field.ObjectArrayField)field);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (FieldNotFoundException fieldNotFoundException) {}
        }
    }

    public static <R> Record<R> clone(Record<R> source) {
        return Records.clone(source, true);
    }

    public static <R> Record<R> clone(Record<R> source, boolean copyTransients) {
        Record<R> target = source.type().newInstance();
        Records.copy(source, target, copyTransients);
        return target;
    }

    public static <R> void clear(Record<R> record) {
        block22: for (Field<R, ?> field : record.fields()) {
            try {
                switch (field.type()) {
                    case 1: {
                        record.set((Field.BooleanField)field, false);
                        break;
                    }
                    case 2: {
                        record.set((Field.ByteField)field, (byte)0);
                        break;
                    }
                    case 3: {
                        record.set((Field.ShortField)field, (short)0);
                        break;
                    }
                    case 4: {
                        record.set((Field.IntField)field, 0);
                        break;
                    }
                    case 5: {
                        record.set((Field.LongField)field, 0L);
                        break;
                    }
                    case 6: {
                        record.set((Field.FloatField)field, 0.0f);
                        break;
                    }
                    case 7: {
                        record.set((Field.DoubleField)field, 0.0);
                        break;
                    }
                    case 8: {
                        record.set((Field.CharField)field, '\u0000');
                        break;
                    }
                    case 9: {
                        record.set((Field.ObjectField)field, null);
                        break;
                    }
                    case 11: {
                        int i;
                        Field.ArrayField f = (Field.BooleanArrayField)field;
                        for (i = 0; i < f.length; ++i) {
                            record.set((Field.BooleanArrayField<R>)f, i, false);
                        }
                        continue block22;
                    }
                    case 12: {
                        int i;
                        Field.ArrayField f = (Field.ByteArrayField)field;
                        for (i = 0; i < ((Field.ByteArrayField)f).length; ++i) {
                            record.set((Field.ByteArrayField<R>)f, i, (byte)0);
                        }
                        continue block22;
                    }
                    case 13: {
                        int i;
                        Field.ArrayField f = (Field.ShortArrayField)field;
                        for (i = 0; i < ((Field.ShortArrayField)f).length; ++i) {
                            record.set((Field.ShortArrayField<R>)f, i, (short)0);
                        }
                        continue block22;
                    }
                    case 14: {
                        int i;
                        Field.ArrayField f = (Field.IntArrayField)field;
                        for (i = 0; i < ((Field.IntArrayField)f).length; ++i) {
                            record.set((Field.IntArrayField<R>)f, i, 0);
                        }
                        continue block22;
                    }
                    case 15: {
                        int i;
                        Field.ArrayField f = (Field.LongArrayField)field;
                        for (i = 0; i < ((Field.LongArrayField)f).length; ++i) {
                            record.set((Field.LongArrayField<R>)f, i, 0L);
                        }
                        continue block22;
                    }
                    case 16: {
                        int i;
                        Field.ArrayField f = (Field.FloatArrayField)field;
                        for (i = 0; i < ((Field.FloatArrayField)f).length; ++i) {
                            record.set((Field.FloatArrayField<R>)f, i, 0.0f);
                        }
                        continue block22;
                    }
                    case 17: {
                        int i;
                        Field.ArrayField f = (Field.DoubleArrayField)field;
                        for (i = 0; i < ((Field.DoubleArrayField)f).length; ++i) {
                            record.set((Field.DoubleArrayField<R>)f, i, 0.0);
                        }
                        continue block22;
                    }
                    case 18: {
                        int i;
                        Field.ArrayField f = (Field.CharArrayField)field;
                        for (i = 0; i < ((Field.CharArrayField)f).length; ++i) {
                            record.set((Field.CharArrayField<R>)f, i, '\u0000');
                        }
                        continue block22;
                    }
                    case 19: {
                        int i;
                        Field.ArrayField f = (Field.ObjectArrayField)field;
                        for (i = 0; i < ((Field.ObjectArrayField)f).length; ++i) {
                            record.set(f, i, null);
                        }
                        continue block22;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (FieldNotFoundException fieldNotFoundException) {}
        }
    }

    public static <R> void clear(RecordArray<R> recordArray) {
        if (!(recordArray instanceof SimpleRecordArray)) {
            throw new UnsupportedOperationException();
        }
        ((SimpleRecordArray)recordArray).clear();
    }

    public static <R> boolean deepEquals(Record<R> a, Record<R> b) {
        if (a == b) {
            return true;
        }
        if (a == null | b == null) {
            return false;
        }
        if (!a.fields().equals(b.fields())) {
            return false;
        }
        block22: for (Field<R, ?> field : a.fields()) {
            try {
                switch (field.type()) {
                    case 1: {
                        if (a.get((Field.BooleanField)field) == b.get((Field.BooleanField)field)) continue block22;
                        return false;
                    }
                    case 2: {
                        if (a.get((Field.ByteField)field) == b.get((Field.ByteField)field)) continue block22;
                        return false;
                    }
                    case 3: {
                        if (a.get((Field.ShortField)field) == b.get((Field.ShortField)field)) continue block22;
                        return false;
                    }
                    case 4: {
                        if (a.get((Field.IntField)field) == b.get((Field.IntField)field)) continue block22;
                        return false;
                    }
                    case 5: {
                        if (a.get((Field.LongField)field) == b.get((Field.LongField)field)) continue block22;
                        return false;
                    }
                    case 6: {
                        if (a.get((Field.FloatField)field) == b.get((Field.FloatField)field)) continue block22;
                        return false;
                    }
                    case 7: {
                        if (a.get((Field.DoubleField)field) == b.get((Field.DoubleField)field)) continue block22;
                        return false;
                    }
                    case 8: {
                        if (a.get((Field.CharField)field) == b.get((Field.CharField)field)) continue block22;
                        return false;
                    }
                    case 9: {
                        if (Objects.equals(a.get((Field.ObjectField)field), b.get((Field.ObjectField)field))) continue block22;
                        return false;
                    }
                    case 11: {
                        int i;
                        Field.ArrayField f = (Field.BooleanArrayField)field;
                        for (i = 0; i < f.length; ++i) {
                            if (a.get((Field.BooleanArrayField<R>)f, i) == b.get((Field.BooleanArrayField<R>)f, i)) continue;
                            return false;
                        }
                        continue block22;
                    }
                    case 12: {
                        int i;
                        Field.ArrayField f = (Field.ByteArrayField)field;
                        for (i = 0; i < ((Field.ByteArrayField)f).length; ++i) {
                            if (a.get((Field.ByteArrayField<R>)f, i) == b.get((Field.ByteArrayField<R>)f, i)) continue;
                            return false;
                        }
                        continue block22;
                    }
                    case 13: {
                        int i;
                        Field.ArrayField f = (Field.ShortArrayField)field;
                        for (i = 0; i < ((Field.ShortArrayField)f).length; ++i) {
                            if (a.get((Field.ShortArrayField<R>)f, i) == b.get((Field.ShortArrayField<R>)f, i)) continue;
                            return false;
                        }
                        continue block22;
                    }
                    case 14: {
                        int i;
                        Field.ArrayField f = (Field.IntArrayField)field;
                        for (i = 0; i < ((Field.IntArrayField)f).length; ++i) {
                            if (a.get((Field.IntArrayField<R>)f, i) == b.get((Field.IntArrayField<R>)f, i)) continue;
                            return false;
                        }
                        continue block22;
                    }
                    case 15: {
                        int i;
                        Field.ArrayField f = (Field.LongArrayField)field;
                        for (i = 0; i < ((Field.LongArrayField)f).length; ++i) {
                            if (a.get((Field.LongArrayField<R>)f, i) == b.get((Field.LongArrayField<R>)f, i)) continue;
                            return false;
                        }
                        continue block22;
                    }
                    case 16: {
                        int i;
                        Field.ArrayField f = (Field.FloatArrayField)field;
                        for (i = 0; i < ((Field.FloatArrayField)f).length; ++i) {
                            if (a.get((Field.FloatArrayField<R>)f, i) == b.get((Field.FloatArrayField<R>)f, i)) continue;
                            return false;
                        }
                        continue block22;
                    }
                    case 17: {
                        int i;
                        Field.ArrayField f = (Field.DoubleArrayField)field;
                        for (i = 0; i < ((Field.DoubleArrayField)f).length; ++i) {
                            if (a.get((Field.DoubleArrayField<R>)f, i) == b.get((Field.DoubleArrayField<R>)f, i)) continue;
                            return false;
                        }
                        continue block22;
                    }
                    case 18: {
                        int i;
                        Field.ArrayField f = (Field.CharArrayField)field;
                        for (i = 0; i < ((Field.CharArrayField)f).length; ++i) {
                            if (a.get((Field.CharArrayField<R>)f, i) == b.get((Field.CharArrayField<R>)f, i)) continue;
                            return false;
                        }
                        continue block22;
                    }
                    case 19: {
                        int i;
                        Field.ArrayField f = (Field.ObjectArrayField)field;
                        for (i = 0; i < ((Field.ObjectArrayField)f).length; ++i) {
                            if (!Objects.equals(a.get(f, i), b.get(f, i))) continue;
                            return false;
                        }
                        continue block22;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            catch (FieldNotFoundException e) {
                return false;
            }
        }
        return true;
    }

    private Records() {
    }
}

