/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.data.record;

import co.paralleluniverse.data.record.Record;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Array;
import java.util.Objects;

public abstract class Field<R, V> {
    public static final int TRANSIENT = 1;
    static final int BOOLEAN = 1;
    static final int BYTE = 2;
    static final int SHORT = 3;
    static final int INT = 4;
    static final int LONG = 5;
    static final int FLOAT = 6;
    static final int DOUBLE = 7;
    static final int CHAR = 8;
    static final int OBJECT = 9;
    static final int BOOLEAN_ARRAY = 11;
    static final int BYTE_ARRAY = 12;
    static final int SHORT_ARRAY = 13;
    static final int INT_ARRAY = 14;
    static final int LONG_ARRAY = 15;
    static final int FLOAT_ARRAY = 16;
    static final int DOUBLE_ARRAY = 17;
    static final int CHAR_ARRAY = 18;
    static final int OBJECT_ARRAY = 19;
    static final int BOOLEAN_SIZE = 1;
    static final int BYTE_SIZE = 1;
    static final int SHORT_SIZE = 2;
    static final int CHAR_SIZE = 2;
    static final int INT_SIZE = 4;
    static final int FLOAT_SIZE = 4;
    static final int LONG_SIZE = 8;
    static final int DOUBLE_SIZE = 8;
    final String name;
    final int id;
    final int flags;

    public static <R> BooleanField<R> booleanField(String name, int id, int flags) {
        return new BooleanField(name, id, flags);
    }

    public static <R> BooleanField<R> booleanField(String name, int id) {
        return Field.booleanField(name, id, 0);
    }

    public static <R> ByteField<R> byteField(String name, int id, int flags) {
        return new ByteField(name, id, flags);
    }

    public static <R> ByteField<R> byteField(String name, int id) {
        return Field.byteField(name, id, 0);
    }

    public static <R> ShortField<R> shortField(String name, int id, int flags) {
        return new ShortField(name, id, flags);
    }

    public static <R> ShortField<R> shortField(String name, int id) {
        return Field.shortField(name, id, 0);
    }

    public static <R> IntField<R> intField(String name, int id, int flags) {
        return new IntField(name, id, flags);
    }

    public static <R> IntField<R> intField(String name, int id) {
        return Field.intField(name, id, 0);
    }

    public static <R> LongField<R> longField(String name, int id, int flags) {
        return new LongField(name, id, flags);
    }

    public static <R> LongField<R> longField(String name, int id) {
        return Field.longField(name, id, 0);
    }

    public static <R> FloatField<R> floatField(String name, int id, int flags) {
        return new FloatField(name, id, flags);
    }

    public static <R> FloatField<R> floatField(String name, int id) {
        return Field.floatField(name, id, 0);
    }

    public static <R> DoubleField<R> doubleField(String name, int id, int flags) {
        return new DoubleField(name, id, flags);
    }

    public static <R> DoubleField<R> doubleField(String name, int id) {
        return Field.doubleField(name, id, 0);
    }

    public static <R> CharField<R> charField(String name, int id, int flags) {
        return new CharField(name, id, flags);
    }

    public static <R> CharField<R> charField(String name, int id) {
        return Field.charField(name, id, 0);
    }

    public static <R, V> ObjectField<R, V> objectField(String name, TypeToken<V> type, int id, int flags) {
        return new ObjectField(name, type.getRawType(), id, flags);
    }

    public static <R, V> ObjectField<R, V> objectField(String name, TypeToken<V> type, int id) {
        return Field.objectField(name, type, id, 0);
    }

    public static <R, V> ObjectField<R, V> objectField(String name, Class<V> type, int id, int flags) {
        return new ObjectField(name, type, id, flags);
    }

    public static <R, V> ObjectField<R, V> objectField(String name, Class<V> type, int id) {
        return Field.objectField(name, type, id, 0);
    }

    public static <R> BooleanArrayField<R> booleanArrayField(String name, int length, int id, int flags) {
        return new BooleanArrayField(name, length, id, flags);
    }

    public static <R> BooleanArrayField<R> booleanArrayField(String name, int length, int id) {
        return Field.booleanArrayField(name, length, id, 0);
    }

    public static <R> ByteArrayField<R> byteArrayField(String name, int length, int id, int flags) {
        return new ByteArrayField(name, length, id, flags);
    }

    public static <R> ByteArrayField<R> byteArrayField(String name, int length, int id) {
        return Field.byteArrayField(name, length, id, 0);
    }

    public static <R> ShortArrayField<R> shortArrayField(String name, int length, int id, int flags) {
        return new ShortArrayField(name, length, id, flags);
    }

    public static <R> ShortArrayField<R> shortArrayField(String name, int length, int id) {
        return Field.shortArrayField(name, length, id, 0);
    }

    public static <R> IntArrayField<R> intArrayField(String name, int length, int id, int flags) {
        return new IntArrayField(name, length, id, flags);
    }

    public static <R> IntArrayField<R> intArrayField(String name, int length, int id) {
        return Field.intArrayField(name, length, id, 0);
    }

    public static <R> LongArrayField<R> longArrayField(String name, int length, int id, int flags) {
        return new LongArrayField(name, length, id, flags);
    }

    public static <R> LongArrayField<R> longArrayField(String name, int length, int id) {
        return Field.longArrayField(name, length, id, 0);
    }

    public static <R> FloatArrayField<R> floatArrayField(String name, int length, int id, int flags) {
        return new FloatArrayField(name, length, id, flags);
    }

    public static <R> FloatArrayField<R> floatArrayField(String name, int length, int id) {
        return Field.floatArrayField(name, length, id, 0);
    }

    public static <R> DoubleArrayField<R> doubleArrayField(String name, int length, int id, int flags) {
        return new DoubleArrayField(name, length, id, flags);
    }

    public static <R> DoubleArrayField<R> doubleArrayField(String name, int length, int id) {
        return Field.doubleArrayField(name, length, id, 0);
    }

    public static <R> CharArrayField<R> charArrayField(String name, int length, int id, int flags) {
        return new CharArrayField(name, length, id, flags);
    }

    public static <R> CharArrayField<R> charArrayField(String name, int length, int id) {
        return Field.charArrayField(name, length, id, 0);
    }

    public static <R, V> ObjectArrayField<R, V> objectArrayField(String name, Class<V> type, int length, int id, int flags) {
        return new ObjectArrayField(name, type, length, id, flags);
    }

    public static <R, V> ObjectArrayField<R, V> objectArrayField(String name, Class<V> type, int length, int id) {
        return ObjectArrayField.objectArrayField(name, type, length, id, 0);
    }

    Field(String name, int id, int flags) {
        this.name = name;
        this.id = id;
        this.flags = flags;
    }

    public final int id() {
        if (this.id == -1) {
            throw new UnsupportedOperationException("id not set");
        }
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public int flags() {
        return this.flags;
    }

    public boolean isTransient() {
        return (this.flags & 1) != 0;
    }

    abstract int type();

    abstract int size();

    public abstract Class<?> typeClass();

    abstract void set(Record<? extends R> var1, V var2);

    abstract V get(Record<? extends R> var1);

    public final int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.type();
        hash = 97 * hash + this.id;
        hash = 97 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public String toString() {
        return this.name;
    }

    public static final class ObjectArrayField<R, V>
    extends ArrayField<R, V> {
        private final Class<V[]> clazz;

        ObjectArrayField(String name, Class<V> elemClazz, int length, int id, int flags) {
            super(name, length, id, flags);
            this.clazz = Array.newInstance(elemClazz, 0).getClass();
        }

        @Override
        int type() {
            return 19;
        }

        @Override
        int size() {
            return 0;
        }

        @Override
        public Class<?> typeClass() {
            return this.clazz;
        }

        @Override
        V get(Record<? extends R> record, int index) {
            return record.get(this, index);
        }

        @Override
        void set(Record<? extends R> record, int index, V value) {
            record.set(this, index, value);
        }

        @Override
        void get(Record<? extends R> record, V[] target, int offset) {
            for (int i = 0; i < this.length; ++i) {
                target[offset + i] = record.get(this, i);
            }
        }

        @Override
        void set(Record<? extends R> record, V[] source, int offset) {
            for (int i = 0; i < this.length; ++i) {
                record.set(this, i, source[offset + i]);
            }
        }
    }

    public static final class CharArrayField<R>
    extends ArrayField<R, Character> {
        CharArrayField(String name, int length, int id, int flags) {
            super(name, length, id, flags);
        }

        @Override
        int type() {
            return 18;
        }

        @Override
        int size() {
            return 2 * this.length;
        }

        @Override
        public Class<?> typeClass() {
            return char[].class;
        }

        @Override
        Character get(Record<? extends R> record, int index) {
            return Character.valueOf(record.get(this, index));
        }

        @Override
        void set(Record<? extends R> record, int index, Character value) {
            record.set(this, index, value.charValue());
        }

        void get(Record<? extends R> record, Character[] target, int offset) {
            for (int i = 0; i < this.length; ++i) {
                target[offset + i] = Character.valueOf(record.get(this, i));
            }
        }

        void set(Record<? extends R> record, Character[] source, int offset) {
            for (int i = 0; i < this.length; ++i) {
                record.set(this, i, source[offset + i].charValue());
            }
        }
    }

    public static final class DoubleArrayField<R>
    extends ArrayField<R, Double> {
        DoubleArrayField(String name, int length, int id, int flags) {
            super(name, length, id, flags);
        }

        @Override
        int type() {
            return 17;
        }

        @Override
        int size() {
            return 8 * this.length;
        }

        @Override
        public Class<?> typeClass() {
            return double[].class;
        }

        @Override
        Double get(Record<? extends R> record, int index) {
            return record.get(this, index);
        }

        @Override
        void set(Record<? extends R> record, int index, Double value) {
            record.set(this, index, value);
        }

        void get(Record<? extends R> record, Double[] target, int offset) {
            for (int i = 0; i < this.length; ++i) {
                target[offset + i] = record.get(this, i);
            }
        }

        void set(Record<? extends R> record, Double[] source, int offset) {
            for (int i = 0; i < this.length; ++i) {
                record.set(this, i, source[offset + i]);
            }
        }
    }

    public static final class FloatArrayField<R>
    extends ArrayField<R, Float> {
        FloatArrayField(String name, int length, int id, int flags) {
            super(name, length, id, flags);
        }

        @Override
        int type() {
            return 16;
        }

        @Override
        int size() {
            return 4 * this.length;
        }

        @Override
        public Class<?> typeClass() {
            return float[].class;
        }

        @Override
        Float get(Record<? extends R> record, int index) {
            return Float.valueOf(record.get(this, index));
        }

        @Override
        void set(Record<? extends R> record, int index, Float value) {
            record.set(this, index, value.floatValue());
        }

        void get(Record<? extends R> record, Float[] target, int offset) {
            for (int i = 0; i < this.length; ++i) {
                target[offset + i] = Float.valueOf(record.get(this, i));
            }
        }

        void set(Record<? extends R> record, Float[] source, int offset) {
            for (int i = 0; i < this.length; ++i) {
                record.set(this, i, source[offset + i].floatValue());
            }
        }
    }

    public static final class LongArrayField<R>
    extends ArrayField<R, Long> {
        LongArrayField(String name, int length, int id, int flags) {
            super(name, length, id, flags);
        }

        @Override
        int type() {
            return 15;
        }

        @Override
        int size() {
            return 8 * this.length;
        }

        @Override
        public Class<?> typeClass() {
            return long[].class;
        }

        @Override
        Long get(Record<? extends R> record, int index) {
            return record.get(this, index);
        }

        @Override
        void set(Record<? extends R> record, int index, Long value) {
            record.set(this, index, value);
        }

        void get(Record<? extends R> record, Long[] target, int offset) {
            for (int i = 0; i < this.length; ++i) {
                target[offset + i] = record.get(this, i);
            }
        }

        void set(Record<? extends R> record, Long[] source, int offset) {
            for (int i = 0; i < this.length; ++i) {
                record.set(this, i, source[offset + i]);
            }
        }
    }

    public static final class IntArrayField<R>
    extends ArrayField<R, Integer> {
        IntArrayField(String name, int length, int id, int flags) {
            super(name, length, id, flags);
        }

        @Override
        int type() {
            return 14;
        }

        @Override
        int size() {
            return 4 * this.length;
        }

        @Override
        public Class<?> typeClass() {
            return int[].class;
        }

        @Override
        Integer get(Record<? extends R> record, int index) {
            return record.get(this, index);
        }

        @Override
        void set(Record<? extends R> record, int index, Integer value) {
            record.set(this, index, (int)value);
        }

        void get(Record<? extends R> record, Integer[] target, int offset) {
            for (int i = 0; i < this.length; ++i) {
                target[offset + i] = record.get(this, i);
            }
        }

        void set(Record<? extends R> record, Integer[] source, int offset) {
            for (int i = 0; i < this.length; ++i) {
                record.set(this, i, (int)source[offset + i]);
            }
        }
    }

    public static final class ShortArrayField<R>
    extends ArrayField<R, Short> {
        ShortArrayField(String name, int length, int id, int flags) {
            super(name, length, id, flags);
        }

        @Override
        int type() {
            return 13;
        }

        @Override
        int size() {
            return 2 * this.length;
        }

        @Override
        public Class<?> typeClass() {
            return short[].class;
        }

        @Override
        Short get(Record<? extends R> record, int index) {
            return record.get(this, index);
        }

        @Override
        void set(Record<? extends R> record, int index, Short value) {
            record.set(this, index, value);
        }

        void get(Record<? extends R> record, Short[] target, int offset) {
            for (int i = 0; i < this.length; ++i) {
                target[offset + i] = record.get(this, i);
            }
        }

        void set(Record<? extends R> record, Short[] source, int offset) {
            for (int i = 0; i < this.length; ++i) {
                record.set(this, i, source[offset + i]);
            }
        }
    }

    public static final class ByteArrayField<R>
    extends ArrayField<R, Byte> {
        ByteArrayField(String name, int length, int id, int flags) {
            super(name, length, id, flags);
        }

        @Override
        int type() {
            return 12;
        }

        @Override
        int size() {
            return 1 * this.length;
        }

        @Override
        public Class<?> typeClass() {
            return byte[].class;
        }

        @Override
        Byte get(Record<? extends R> record, int index) {
            return record.get(this, index);
        }

        @Override
        void set(Record<? extends R> record, int index, Byte value) {
            record.set(this, index, value);
        }

        void get(Record<? extends R> record, Byte[] target, int offset) {
            for (int i = 0; i < this.length; ++i) {
                target[offset + i] = record.get(this, i);
            }
        }

        void set(Record<? extends R> record, Byte[] source, int offset) {
            for (int i = 0; i < this.length; ++i) {
                record.set(this, i, source[offset + i]);
            }
        }
    }

    public static final class BooleanArrayField<R>
    extends ArrayField<R, Boolean> {
        BooleanArrayField(String name, int length, int id, int flags) {
            super(name, length, id, flags);
        }

        @Override
        int type() {
            return 11;
        }

        @Override
        int size() {
            return 1 * this.length;
        }

        @Override
        public Class<?> typeClass() {
            return boolean[].class;
        }

        @Override
        Boolean get(Record<? extends R> record, int index) {
            return record.get(this, index);
        }

        @Override
        void set(Record<? extends R> record, int index, Boolean value) {
            record.set(this, index, value);
        }

        void get(Record<? extends R> record, Boolean[] target, int offset) {
            for (int i = 0; i < this.length; ++i) {
                target[offset + i] = record.get(this, i);
            }
        }

        void set(Record<? extends R> record, Boolean[] source, int offset) {
            for (int i = 0; i < this.length; ++i) {
                record.set(this, i, source[offset + i]);
            }
        }
    }

    public static class ObjectField<R, V>
    extends ScalarField<R, V> {
        private final Class<?> clazz;

        ObjectField(String name, Class<?> clazz, int id, int flags) {
            super(name, id, flags);
            this.clazz = clazz;
        }

        @Override
        int type() {
            return 9;
        }

        @Override
        int size() {
            return 0;
        }

        @Override
        public Class<?> typeClass() {
            return this.clazz;
        }

        @Override
        void set(Record<? extends R> record, V value) {
            record.set(this, value);
        }

        @Override
        V get(Record<? extends R> record) {
            return record.get(this);
        }
    }

    public static final class CharField<R>
    extends ScalarField<R, Character> {
        CharField(String name, int id, int flags) {
            super(name, id, flags);
        }

        @Override
        int type() {
            return 8;
        }

        @Override
        int size() {
            return 2;
        }

        @Override
        public Class<?> typeClass() {
            return Character.TYPE;
        }

        @Override
        void set(Record<? extends R> record, Character value) {
            record.set(this, value.charValue());
        }

        @Override
        Character get(Record<? extends R> record) {
            return Character.valueOf(record.get(this));
        }
    }

    public static final class DoubleField<R>
    extends ScalarField<R, Double> {
        DoubleField(String name, int id, int flags) {
            super(name, id, flags);
        }

        @Override
        int type() {
            return 7;
        }

        @Override
        int size() {
            return 8;
        }

        @Override
        public Class<?> typeClass() {
            return Double.TYPE;
        }

        @Override
        void set(Record<? extends R> record, Double value) {
            record.set(this, value);
        }

        @Override
        Double get(Record<? extends R> record) {
            return record.get(this);
        }
    }

    public static final class FloatField<R>
    extends ScalarField<R, Float> {
        FloatField(String name, int id, int flags) {
            super(name, id, flags);
        }

        @Override
        int type() {
            return 6;
        }

        @Override
        int size() {
            return 4;
        }

        @Override
        public Class<?> typeClass() {
            return Float.TYPE;
        }

        @Override
        void set(Record<? extends R> record, Float value) {
            record.set(this, value.floatValue());
        }

        @Override
        Float get(Record<? extends R> record) {
            return Float.valueOf(record.get(this));
        }
    }

    public static final class LongField<R>
    extends ScalarField<R, Long> {
        LongField(String name, int id, int flags) {
            super(name, id, flags);
        }

        @Override
        int type() {
            return 5;
        }

        @Override
        int size() {
            return 8;
        }

        @Override
        public Class<?> typeClass() {
            return Long.TYPE;
        }

        @Override
        void set(Record<? extends R> record, Long value) {
            record.set(this, value);
        }

        @Override
        Long get(Record<? extends R> record) {
            return record.get(this);
        }
    }

    public static final class IntField<R>
    extends ScalarField<R, Integer> {
        IntField(String name, int id, int flags) {
            super(name, id, flags);
        }

        @Override
        int type() {
            return 4;
        }

        @Override
        int size() {
            return 4;
        }

        @Override
        public Class<?> typeClass() {
            return Integer.TYPE;
        }

        @Override
        void set(Record<? extends R> record, Integer value) {
            record.set(this, value);
        }

        @Override
        Integer get(Record<? extends R> record) {
            return record.get(this);
        }
    }

    public static final class ShortField<R>
    extends ScalarField<R, Short> {
        ShortField(String name, int id, int flags) {
            super(name, id, flags);
        }

        @Override
        int type() {
            return 3;
        }

        @Override
        int size() {
            return 2;
        }

        @Override
        public Class<?> typeClass() {
            return Short.TYPE;
        }

        @Override
        void set(Record<? extends R> record, Short value) {
            record.set(this, value);
        }

        @Override
        Short get(Record<? extends R> record) {
            return record.get(this);
        }
    }

    public static final class ByteField<R>
    extends ScalarField<R, Byte> {
        ByteField(String name, int id, int flags) {
            super(name, id, flags);
        }

        @Override
        int type() {
            return 2;
        }

        @Override
        int size() {
            return 1;
        }

        @Override
        public Class<?> typeClass() {
            return Byte.TYPE;
        }

        @Override
        void set(Record<? extends R> record, Byte value) {
            record.set(this, value);
        }

        @Override
        Byte get(Record<? extends R> record) {
            return record.get(this);
        }
    }

    public static final class BooleanField<R>
    extends ScalarField<R, Boolean> {
        BooleanField(String name, int id, int flags) {
            super(name, id, flags);
        }

        @Override
        int type() {
            return 1;
        }

        @Override
        int size() {
            return 1;
        }

        @Override
        public Class<?> typeClass() {
            return Boolean.TYPE;
        }

        @Override
        void set(Record<? extends R> record, Boolean value) {
            record.set(this, value);
        }

        @Override
        Boolean get(Record<? extends R> record) {
            return record.get(this);
        }
    }

    public static abstract class ArrayField<R, V>
    extends Field<R, V[]> {
        public final int length;

        ArrayField(String name, int length, int id, int flags) {
            super(name, id, flags);
            this.length = length;
        }

        abstract V get(Record<? extends R> var1, int var2);

        abstract void set(Record<? extends R> var1, int var2, V var3);

        abstract void get(Record<? extends R> var1, V[] var2, int var3);

        abstract void set(Record<? extends R> var1, V[] var2, int var3);

        @Override
        final V[] get(Record<? extends R> record) {
            Object[] array = new Object[this.length];
            this.get(record, array, 0);
            return array;
        }

        @Override
        final void set(Record<? extends R> record, V[] array) {
            this.set(record, array, 0);
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ArrayField)) {
                return false;
            }
            ArrayField other = (ArrayField)obj;
            return this.id == other.id && this.type() == other.type() && this.length == other.length && Objects.equals(this.name(), other.name());
        }
    }

    public static abstract class ScalarField<R, V>
    extends Field<R, V> {
        ScalarField(String name, int id, int flags) {
            super(name, id, flags);
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Field)) {
                return false;
            }
            Field other = (Field)obj;
            return this.id == other.id && this.type() == other.type() && Objects.equals(this.name(), other.name());
        }
    }
}

