/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.data.record;

import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.data.record.DynamicRecord;
import co.paralleluniverse.data.record.Field;
import co.paralleluniverse.data.record.ReadOnlyFieldException;
import co.paralleluniverse.data.record.Record;
import co.paralleluniverse.data.record.RecordType;
import java.lang.reflect.Method;

class DynamicReflectionRecord<R>
extends DynamicRecord<R> {
    DynamicReflectionRecord(RecordType<R> recordType, Object target) {
        super(recordType, target);
    }

    private Method setter(Field<? super R, ?> field, RecordType.Entry entry) {
        Method m = entry.setter;
        if (m == null) {
            throw new ReadOnlyFieldException(field, this.obj);
        }
        return m;
    }

    @Override
    public boolean get(Field.BooleanField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.field != null) {
                return (Boolean)entry.field.get(this.obj);
            }
            return (Boolean)entry.getter.invoke(this.obj, new Object[0]);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.BooleanField<? super R> field, boolean value) {
        try {
            RecordType.Entry entry = this.entry(field);
            this.checkReadOnly(entry, field);
            if (entry.field != null) {
                entry.field.set(this.obj, value);
            } else {
                this.setter(field, entry).invoke(this.obj, value);
            }
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public byte get(Field.ByteField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.field != null) {
                return (Byte)entry.field.get(this.obj);
            }
            return (Byte)entry.getter.invoke(this.obj, new Object[0]);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.ByteField<? super R> field, byte value) {
        try {
            RecordType.Entry entry = this.entry(field);
            this.checkReadOnly(entry, field);
            if (entry.field != null) {
                entry.field.set(this.obj, value);
            } else {
                this.setter(field, entry).invoke(this.obj, value);
            }
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public short get(Field.ShortField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.field != null) {
                return (Short)entry.field.get(this.obj);
            }
            return (Short)entry.getter.invoke(this.obj, new Object[0]);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.ShortField<? super R> field, short value) {
        try {
            RecordType.Entry entry = this.entry(field);
            this.checkReadOnly(entry, field);
            if (entry.field != null) {
                entry.field.set(this.obj, value);
            } else {
                this.setter(field, entry).invoke(this.obj, value);
            }
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public int get(Field.IntField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.field != null) {
                return (Integer)entry.field.get(this.obj);
            }
            return (Integer)entry.getter.invoke(this.obj, new Object[0]);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.IntField<? super R> field, int value) {
        try {
            RecordType.Entry entry = this.entry(field);
            this.checkReadOnly(entry, field);
            if (entry.field != null) {
                entry.field.set(this.obj, value);
            } else {
                this.setter(field, entry).invoke(this.obj, value);
            }
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public long get(Field.LongField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.field != null) {
                return (Long)entry.field.get(this.obj);
            }
            return (Long)entry.getter.invoke(this.obj, new Object[0]);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.LongField<? super R> field, long value) {
        try {
            RecordType.Entry entry = this.entry(field);
            this.checkReadOnly(entry, field);
            if (entry.field != null) {
                entry.field.set(this.obj, value);
            } else {
                this.setter(field, entry).invoke(this.obj, value);
            }
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public float get(Field.FloatField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.field != null) {
                return ((Float)entry.field.get(this.obj)).floatValue();
            }
            return ((Float)entry.getter.invoke(this.obj, new Object[0])).floatValue();
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.FloatField<? super R> field, float value) {
        try {
            RecordType.Entry entry = this.entry(field);
            this.checkReadOnly(entry, field);
            if (entry.field != null) {
                entry.field.set(this.obj, Float.valueOf(value));
            } else {
                this.setter(field, entry).invoke(this.obj, Float.valueOf(value));
            }
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public double get(Field.DoubleField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.field != null) {
                return (Double)entry.field.get(this.obj);
            }
            return (Double)entry.getter.invoke(this.obj, new Object[0]);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.DoubleField<? super R> field, double value) {
        try {
            RecordType.Entry entry = this.entry(field);
            this.checkReadOnly(entry, field);
            if (entry.field != null) {
                entry.field.set(this.obj, value);
            } else {
                this.setter(field, entry).invoke(this.obj, value);
            }
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public char get(Field.CharField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.field != null) {
                return ((Character)entry.field.get(this.obj)).charValue();
            }
            return ((Character)entry.getter.invoke(this.obj, new Object[0])).charValue();
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.CharField<? super R> field, char value) {
        try {
            RecordType.Entry entry = this.entry(field);
            this.checkReadOnly(entry, field);
            if (entry.field != null) {
                entry.field.set(this.obj, Character.valueOf(value));
            } else {
                this.setter(field, entry).invoke(this.obj, Character.valueOf(value));
            }
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <V> V get(Field.ObjectField<? super R, V> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.field != null) {
                return (V)entry.field.get(this.obj);
            }
            return (V)entry.getter.invoke(this.obj, new Object[0]);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <V> void set(Field.ObjectField<? super R, V> field, V value) {
        try {
            RecordType.Entry entry = this.entry(field);
            this.checkReadOnly(entry, field);
            if (entry.field != null) {
                entry.field.set(this.obj, value);
            } else {
                this.setter(field, entry).invoke(this.obj, value);
            }
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    boolean[] get(Field.BooleanArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return (boolean[])entry.field.get(this.obj);
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public boolean get(Field.BooleanArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return (Boolean)entry.getter.invoke(this.obj, index);
            }
            return ((boolean[])entry.field.get(this.obj))[index];
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.BooleanArrayField<? super R> field, int index, boolean value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invoke(this.obj, index, value);
            } else {
                ((boolean[])entry.field.get((Object)this.obj))[index] = value;
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void get(Field.BooleanArrayField<? super R> field, boolean[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = (Boolean)entry.getter.invoke(this.obj, i);
                }
            } else {
                System.arraycopy((boolean[])entry.field.get(this.obj), 0, target, offset, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.BooleanArrayField<? super R> field, boolean[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, (boolean[])entry.field.get(this.obj), 0, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <S> void set(Field.BooleanArrayField<? super R> field, Record<S> source, Field.BooleanArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, (boolean[])entry.field.get(this.obj), 0);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    byte[] get(Field.ByteArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return (byte[])entry.field.get(this.obj);
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public byte get(Field.ByteArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return (Byte)entry.getter.invoke(this.obj, index);
            }
            return ((byte[])entry.field.get(this.obj))[index];
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.ByteArrayField<? super R> field, int index, byte value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invoke(this.obj, index, value);
            } else {
                ((byte[])entry.field.get((Object)this.obj))[index] = value;
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void get(Field.ByteArrayField<? super R> field, byte[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = (Byte)entry.getter.invoke(this.obj, i);
                }
            } else {
                System.arraycopy((byte[])entry.field.get(this.obj), 0, target, offset, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.ByteArrayField<? super R> field, byte[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, (byte[])entry.field.get(this.obj), 0, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <S> void set(Field.ByteArrayField<? super R> field, Record<S> source, Field.ByteArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, (byte[])entry.field.get(this.obj), 0);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    short[] get(Field.ShortArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return (short[])entry.field.get(this.obj);
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public short get(Field.ShortArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return (Short)entry.getter.invoke(this.obj, index);
            }
            return ((short[])entry.field.get(this.obj))[index];
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.ShortArrayField<? super R> field, int index, short value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invoke(this.obj, index, value);
            } else {
                ((short[])entry.field.get((Object)this.obj))[index] = value;
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void get(Field.ShortArrayField<? super R> field, short[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = (Short)entry.getter.invoke(this.obj, i);
                }
            } else {
                System.arraycopy((short[])entry.field.get(this.obj), 0, target, offset, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.ShortArrayField<? super R> field, short[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, (short[])entry.field.get(this.obj), 0, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <S> void set(Field.ShortArrayField<? super R> field, Record<S> source, Field.ShortArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, (short[])entry.field.get(this.obj), 0);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    int[] get(Field.IntArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return (int[])entry.field.get(this.obj);
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public int get(Field.IntArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return (Integer)entry.getter.invoke(this.obj, index);
            }
            return ((int[])entry.field.get(this.obj))[index];
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.IntArrayField<? super R> field, int index, int value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invoke(this.obj, index, value);
            } else {
                ((int[])entry.field.get((Object)this.obj))[index] = value;
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void get(Field.IntArrayField<? super R> field, int[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = (Integer)entry.getter.invoke(this.obj, i);
                }
            } else {
                System.arraycopy((int[])entry.field.get(this.obj), 0, target, offset, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.IntArrayField<? super R> field, int[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, (int[])entry.field.get(this.obj), 0, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <S> void set(Field.IntArrayField<? super R> field, Record<S> source, Field.IntArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, (int[])entry.field.get(this.obj), 0);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    long[] get(Field.LongArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return (long[])entry.field.get(this.obj);
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public long get(Field.LongArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return (Long)entry.getter.invoke(this.obj, index);
            }
            return ((long[])entry.field.get(this.obj))[index];
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.LongArrayField<? super R> field, int index, long value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invoke(this.obj, index, value);
            } else {
                ((long[])entry.field.get((Object)this.obj))[index] = value;
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void get(Field.LongArrayField<? super R> field, long[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = (Long)entry.getter.invoke(this.obj, i);
                }
            } else {
                System.arraycopy((long[])entry.field.get(this.obj), 0, target, offset, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.LongArrayField<? super R> field, long[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, (long[])entry.field.get(this.obj), 0, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <S> void set(Field.LongArrayField<? super R> field, Record<S> source, Field.LongArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, (long[])entry.field.get(this.obj), 0);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    float[] get(Field.FloatArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return (float[])entry.field.get(this.obj);
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public float get(Field.FloatArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return ((Float)entry.getter.invoke(this.obj, index)).floatValue();
            }
            return ((float[])entry.field.get(this.obj))[index];
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.FloatArrayField<? super R> field, int index, float value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invoke(this.obj, index, Float.valueOf(value));
            } else {
                ((float[])entry.field.get((Object)this.obj))[index] = value;
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void get(Field.FloatArrayField<? super R> field, float[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = ((Float)entry.getter.invoke(this.obj, i)).floatValue();
                }
            } else {
                System.arraycopy((float[])entry.field.get(this.obj), 0, target, offset, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.FloatArrayField<? super R> field, float[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, Float.valueOf(source[offset + i]));
                }
            } else {
                System.arraycopy(source, offset, (float[])entry.field.get(this.obj), 0, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <S> void set(Field.FloatArrayField<? super R> field, Record<S> source, Field.FloatArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, Float.valueOf(source.get(sourceField, i)));
                }
            } else {
                source.get(sourceField, (float[])entry.field.get(this.obj), 0);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    double[] get(Field.DoubleArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return (double[])entry.field.get(this.obj);
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public double get(Field.DoubleArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return (Double)entry.getter.invoke(this.obj, index);
            }
            return ((double[])entry.field.get(this.obj))[index];
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.DoubleArrayField<? super R> field, int index, double value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invoke(this.obj, index, value);
            } else {
                ((double[])entry.field.get((Object)this.obj))[index] = value;
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void get(Field.DoubleArrayField<? super R> field, double[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = (Double)entry.getter.invoke(this.obj, i);
                }
            } else {
                System.arraycopy((double[])entry.field.get(this.obj), 0, target, offset, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.DoubleArrayField<? super R> field, double[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, (double[])entry.field.get(this.obj), 0, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <S> void set(Field.DoubleArrayField<? super R> field, Record<S> source, Field.DoubleArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, (double[])entry.field.get(this.obj), 0);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    char[] get(Field.CharArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return (char[])entry.field.get(this.obj);
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public char get(Field.CharArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return ((Character)entry.getter.invoke(this.obj, index)).charValue();
            }
            return ((char[])entry.field.get(this.obj))[index];
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.CharArrayField<? super R> field, int index, char value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invoke(this.obj, index, Character.valueOf(value));
            } else {
                ((char[])entry.field.get((Object)this.obj))[index] = value;
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void get(Field.CharArrayField<? super R> field, char[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = ((Character)entry.getter.invoke(this.obj, i)).charValue();
                }
            } else {
                System.arraycopy((char[])entry.field.get(this.obj), 0, target, offset, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public void set(Field.CharArrayField<? super R> field, char[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, Character.valueOf(source[offset + i]));
                }
            } else {
                System.arraycopy(source, offset, (char[])entry.field.get(this.obj), 0, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <S> void set(Field.CharArrayField<? super R> field, Record<S> source, Field.CharArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, Character.valueOf(source.get(sourceField, i)));
                }
            } else {
                source.get(sourceField, (char[])entry.field.get(this.obj), 0);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    <V> V[] get(Field.ObjectArrayField<? super R, V> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return (Object[])entry.field.get(this.obj);
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <V> V get(Field.ObjectArrayField<? super R, V> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return (V)entry.getter.invoke(this.obj, index);
            }
            return (V)((Object[])entry.field.get(this.obj))[index];
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <V> void set(Field.ObjectArrayField<? super R, V> field, int index, V value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invoke(this.obj, index, value);
            } else {
                ((Object[])entry.field.get((Object)this.obj))[index] = value;
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <V> void get(Field.ObjectArrayField<? super R, V> field, V[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = entry.getter.invoke(this.obj, i);
                }
            } else {
                System.arraycopy((Object[])entry.field.get(this.obj), 0, target, offset, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <V> void set(Field.ObjectArrayField<? super R, V> field, V[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, (Object[])entry.field.get(this.obj), 0, field.length);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }

    @Override
    public <S, V> void set(Field.ObjectArrayField<? super R, V> field, Record<S> source, Field.ObjectArrayField<? super S, V> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invoke(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, (Object[])entry.field.get(this.obj), 0);
            }
        }
        catch (Exception e) {
            throw Exceptions.rethrow((Throwable)Exceptions.unwrap((Throwable)e));
        }
    }
}

