/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.data.record;

import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.data.record.DynamicRecord;
import co.paralleluniverse.data.record.Field;
import co.paralleluniverse.data.record.ReadOnlyFieldException;
import co.paralleluniverse.data.record.Record;
import co.paralleluniverse.data.record.RecordType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class DynamicMethodHandleRecord<R>
extends DynamicRecord<R> {
    static MethodHandle getGetterMethodHandle(Field<?, ?> field, java.lang.reflect.Field f, Method getter) {
        try {
            if (f == null && getter == null) {
                return null;
            }
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return DynamicMethodHandleRecord.fixMethodHandleType(field, getter != null ? lookup.unreflect(getter) : lookup.unreflectGetter(f));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    static MethodHandle getSetterMethodHandle(Field<?, ?> field, java.lang.reflect.Field f, Method setter) {
        try {
            if (f == null && setter == null) {
                return null;
            }
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return DynamicMethodHandleRecord.fixMethodHandleType(field, f != null ? (field instanceof Field.ScalarField && !Modifier.isFinal(f.getModifiers()) ? lookup.unreflectSetter(f) : null) : (setter != null ? lookup.unreflect(setter) : null));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle fixMethodHandleType(Field field, MethodHandle mh) throws IllegalAccessException {
        if (mh == null) {
            return null;
        }
        MethodType origType = mh.type();
        Class<?>[] params = origType.parameterArray();
        params[0] = Object.class;
        for (int i = 1; i < params.length; ++i) {
            if (params[i].isPrimitive()) continue;
            params[i] = Object.class;
        }
        Class<Object[]> rtype = origType.returnType();
        if (field instanceof Field.ArrayField && rtype.isArray()) {
            if (!rtype.getComponentType().isPrimitive()) {
                rtype = Object[].class;
            }
        } else if (!rtype.isPrimitive()) {
            rtype = Object.class;
        }
        MethodType mt = MethodType.methodType(rtype, params);
        return mh.asType(mt);
    }

    DynamicMethodHandleRecord(RecordType<R> recordType, Object target) {
        super(recordType, target);
    }

    private MethodHandle setter(Field<? super R, ?> field, RecordType.Entry entry) {
        MethodHandle mh = entry.setterHandle;
        if (mh == null) {
            throw new ReadOnlyFieldException(field, this.obj);
        }
        return mh;
    }

    private MethodHandle setter(Field<? super R, ?> field) {
        return this.setter(field, this.entry(field));
    }

    @Override
    public boolean get(Field.BooleanField<? super R> field) {
        try {
            return this.entry(field).getterHandle.invokeExact(this.obj);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.BooleanField<? super R> field, boolean value) {
        try {
            this.setter(field).invokeExact(this.obj, value);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public byte get(Field.ByteField<? super R> field) {
        try {
            return this.entry(field).getterHandle.invokeExact(this.obj);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.ByteField<? super R> field, byte value) {
        try {
            this.setter(field).invokeExact(this.obj, value);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public short get(Field.ShortField<? super R> field) {
        try {
            return this.entry(field).getterHandle.invokeExact(this.obj);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.ShortField<? super R> field, short value) {
        try {
            this.setter(field).invokeExact(this.obj, value);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public int get(Field.IntField<? super R> field) {
        try {
            return this.entry(field).getterHandle.invokeExact(this.obj);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.IntField<? super R> field, int value) {
        try {
            this.setter(field).invokeExact(this.obj, value);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public long get(Field.LongField<? super R> field) {
        try {
            return this.entry(field).getterHandle.invokeExact(this.obj);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.LongField<? super R> field, long value) {
        try {
            this.setter(field).invokeExact(this.obj, value);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public float get(Field.FloatField<? super R> field) {
        try {
            return this.entry(field).getterHandle.invokeExact(this.obj);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.FloatField<? super R> field, float value) {
        try {
            this.setter(field).invokeExact(this.obj, value);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public double get(Field.DoubleField<? super R> field) {
        try {
            return this.entry(field).getterHandle.invokeExact(this.obj);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.DoubleField<? super R> field, double value) {
        try {
            this.setter(field).invokeExact(this.obj, value);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public char get(Field.CharField<? super R> field) {
        try {
            return this.entry(field).getterHandle.invokeExact(this.obj);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.CharField<? super R> field, char value) {
        try {
            this.setter(field).invokeExact(this.obj, value);
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <V> V get(Field.ObjectField<? super R, V> field) {
        try {
            return (V)this.entry(field).getterHandle.invokeExact(this.obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <V> void set(Field.ObjectField<? super R, V> field, V value) {
        try {
            this.setter(field).invokeExact(this.obj, value);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    boolean[] get(Field.BooleanArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return entry.getterHandle.invokeExact(this.obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public boolean get(Field.BooleanArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return entry.getterHandle.invokeExact(this.obj, index);
            }
            return entry.getterHandle.invokeExact(this.obj)[index];
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.BooleanArrayField<? super R> field, int index, boolean value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invokeExact(this.obj, index, value);
            } else {
                entry.getterHandle.invokeExact((Object)this.obj)[index] = value;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void get(Field.BooleanArrayField<? super R> field, boolean[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = entry.getterHandle.invokeExact(this.obj, i);
                }
            } else {
                System.arraycopy(entry.getterHandle.invokeExact(this.obj), 0, target, offset, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.BooleanArrayField<? super R> field, boolean[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, entry.getterHandle.invokeExact(this.obj), 0, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <S> void set(Field.BooleanArrayField<? super R> field, Record<S> source, Field.BooleanArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, entry.getterHandle.invokeExact(this.obj), 0);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    byte[] get(Field.ByteArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return entry.getterHandle.invokeExact(this.obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public byte get(Field.ByteArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return entry.getterHandle.invokeExact(this.obj, index);
            }
            return entry.getterHandle.invokeExact(this.obj)[index];
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.ByteArrayField<? super R> field, int index, byte value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invokeExact(this.obj, index, value);
            } else {
                entry.getterHandle.invokeExact((Object)this.obj)[index] = value;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void get(Field.ByteArrayField<? super R> field, byte[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = entry.getterHandle.invokeExact(this.obj, i);
                }
            } else {
                System.arraycopy(entry.getterHandle.invokeExact(this.obj), 0, target, offset, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.ByteArrayField<? super R> field, byte[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, entry.getterHandle.invokeExact(this.obj), 0, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <S> void set(Field.ByteArrayField<? super R> field, Record<S> source, Field.ByteArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, entry.getterHandle.invokeExact(this.obj), 0);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    short[] get(Field.ShortArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return entry.getterHandle.invokeExact(this.obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public short get(Field.ShortArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return entry.getterHandle.invokeExact(this.obj, index);
            }
            return entry.getterHandle.invokeExact(this.obj)[index];
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.ShortArrayField<? super R> field, int index, short value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invokeExact(this.obj, index, value);
            } else {
                entry.getterHandle.invokeExact((Object)this.obj)[index] = value;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void get(Field.ShortArrayField<? super R> field, short[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = entry.getterHandle.invokeExact(this.obj, i);
                }
            } else {
                System.arraycopy(entry.getterHandle.invokeExact(this.obj), 0, target, offset, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.ShortArrayField<? super R> field, short[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, entry.getterHandle.invokeExact(this.obj), 0, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <S> void set(Field.ShortArrayField<? super R> field, Record<S> source, Field.ShortArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, entry.getterHandle.invokeExact(this.obj), 0);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    int[] get(Field.IntArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return entry.getterHandle.invokeExact(this.obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public int get(Field.IntArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return entry.getterHandle.invokeExact(this.obj, index);
            }
            return entry.getterHandle.invokeExact(this.obj)[index];
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.IntArrayField<? super R> field, int index, int value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invokeExact(this.obj, index, value);
            } else {
                entry.getterHandle.invokeExact((Object)this.obj)[index] = value;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void get(Field.IntArrayField<? super R> field, int[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = entry.getterHandle.invokeExact(this.obj, i);
                }
            } else {
                System.arraycopy(entry.getterHandle.invokeExact(this.obj), 0, target, offset, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.IntArrayField<? super R> field, int[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, entry.getterHandle.invokeExact(this.obj), 0, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <S> void set(Field.IntArrayField<? super R> field, Record<S> source, Field.IntArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, entry.getterHandle.invokeExact(this.obj), 0);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    long[] get(Field.LongArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return entry.getterHandle.invokeExact(this.obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public long get(Field.LongArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return entry.getterHandle.invokeExact(this.obj, index);
            }
            return entry.getterHandle.invokeExact(this.obj)[index];
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.LongArrayField<? super R> field, int index, long value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invokeExact(this.obj, index, value);
            } else {
                entry.getterHandle.invokeExact((Object)this.obj)[index] = value;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void get(Field.LongArrayField<? super R> field, long[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = entry.getterHandle.invokeExact(this.obj, i);
                }
            } else {
                System.arraycopy(entry.getterHandle.invokeExact(this.obj), 0, target, offset, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.LongArrayField<? super R> field, long[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, entry.getterHandle.invokeExact(this.obj), 0, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <S> void set(Field.LongArrayField<? super R> field, Record<S> source, Field.LongArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, entry.getterHandle.invokeExact(this.obj), 0);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    float[] get(Field.FloatArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return entry.getterHandle.invokeExact(this.obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public float get(Field.FloatArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return entry.getterHandle.invokeExact(this.obj, index);
            }
            return entry.getterHandle.invokeExact(this.obj)[index];
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.FloatArrayField<? super R> field, int index, float value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invokeExact(this.obj, index, value);
            } else {
                entry.getterHandle.invokeExact((Object)this.obj)[index] = value;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void get(Field.FloatArrayField<? super R> field, float[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = entry.getterHandle.invokeExact(this.obj, i);
                }
            } else {
                System.arraycopy(entry.getterHandle.invokeExact(this.obj), 0, target, offset, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.FloatArrayField<? super R> field, float[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, entry.getterHandle.invokeExact(this.obj), 0, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <S> void set(Field.FloatArrayField<? super R> field, Record<S> source, Field.FloatArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, entry.getterHandle.invokeExact(this.obj), 0);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    double[] get(Field.DoubleArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return entry.getterHandle.invokeExact(this.obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public double get(Field.DoubleArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return entry.getterHandle.invokeExact(this.obj, index);
            }
            return entry.getterHandle.invokeExact(this.obj)[index];
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.DoubleArrayField<? super R> field, int index, double value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invokeExact(this.obj, index, value);
            } else {
                entry.getterHandle.invokeExact((Object)this.obj)[index] = value;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void get(Field.DoubleArrayField<? super R> field, double[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = entry.getterHandle.invokeExact(this.obj, i);
                }
            } else {
                System.arraycopy(entry.getterHandle.invokeExact(this.obj), 0, target, offset, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.DoubleArrayField<? super R> field, double[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, entry.getterHandle.invokeExact(this.obj), 0, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <S> void set(Field.DoubleArrayField<? super R> field, Record<S> source, Field.DoubleArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, entry.getterHandle.invokeExact(this.obj), 0);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    char[] get(Field.CharArrayField<? super R> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return entry.getterHandle.invokeExact(this.obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public char get(Field.CharArrayField<? super R> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return entry.getterHandle.invokeExact(this.obj, index);
            }
            return entry.getterHandle.invokeExact(this.obj)[index];
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.CharArrayField<? super R> field, int index, char value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invokeExact(this.obj, index, value);
            } else {
                entry.getterHandle.invokeExact((Object)this.obj)[index] = value;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void get(Field.CharArrayField<? super R> field, char[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = entry.getterHandle.invokeExact(this.obj, i);
                }
            } else {
                System.arraycopy(entry.getterHandle.invokeExact(this.obj), 0, target, offset, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public void set(Field.CharArrayField<? super R> field, char[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, entry.getterHandle.invokeExact(this.obj), 0, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <S> void set(Field.CharArrayField<? super R> field, Record<S> source, Field.CharArrayField<? super S> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, entry.getterHandle.invokeExact(this.obj), 0);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    <V> V[] get(Field.ObjectArrayField<? super R, V> field) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return null;
            }
            return entry.getterHandle.invokeExact(this.obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <V> V get(Field.ObjectArrayField<? super R, V> field, int index) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                return (V)entry.getterHandle.invokeExact(this.obj, index);
            }
            return (V)entry.getterHandle.invokeExact(this.obj)[index];
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <V> void set(Field.ObjectArrayField<? super R, V> field, int index, V value) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                this.setter(field, entry).invokeExact(this.obj, index, value);
            } else {
                entry.getterHandle.invokeExact((Object)this.obj)[index] = value;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <V> void get(Field.ObjectArrayField<? super R, V> field, V[] target, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    target[offset + i] = entry.getterHandle.invokeExact(this.obj, i);
                }
            } else {
                System.arraycopy(entry.getterHandle.invokeExact(this.obj), 0, target, offset, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <V> void set(Field.ObjectArrayField<? super R, V> field, V[] source, int offset) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source[offset + i]);
                }
            } else {
                System.arraycopy(source, offset, entry.getterHandle.invokeExact(this.obj), 0, field.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }

    @Override
    public <S, V> void set(Field.ObjectArrayField<? super R, V> field, Record<S> source, Field.ObjectArrayField<? super S, V> sourceField) {
        try {
            RecordType.Entry entry = this.entry(field);
            if (entry.indexed) {
                for (int i = 0; i < field.length; ++i) {
                    this.setter(field, entry).invokeExact(this.obj, i, source.get(sourceField, i));
                }
            } else {
                source.get(sourceField, entry.getterHandle.invokeExact(this.obj), 0);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Exceptions.rethrow((Throwable)t);
        }
    }
}

