/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors.behaviors;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.MessageProcessor;
import co.paralleluniverse.actors.behaviors.FromMessage;
import co.paralleluniverse.actors.behaviors.IdMessage;
import java.util.Objects;

public abstract class MessageSelector<M1, M2>
implements MessageProcessor<Object, M2> {
    public static <M> MessageSelector<Object, M> select() {
        return new MessageSelector<Object, M>(){

            @Override
            public boolean matches(Object m) {
                return true;
            }
        };
    }

    public <M extends M1> MessageSelector<M1, M> ofType(final Class<M> type) {
        return new MessageSelector<M1, M>(){

            @Override
            public boolean matches(M1 m) {
                return MessageSelector.this.matches(m) && type.isInstance(m);
            }
        };
    }

    public <M extends FromMessage> MessageSelector<M, M> from(final ActorRef<?> actor) {
        return new MessageSelector<M, M>(){

            @Override
            public boolean matches(M m) {
                return MessageSelector.this.matches(m) && m instanceof FromMessage && Objects.equals(actor, m.getFrom());
            }
        };
    }

    public <M extends IdMessage> MessageSelector<M, M> withId(final Object id) {
        return new MessageSelector<M, M>(){

            @Override
            public boolean matches(M m) {
                return MessageSelector.this.matches(m) && m instanceof IdMessage && Objects.equals(id, m.getId());
            }
        };
    }

    protected abstract boolean matches(M1 var1);

    @Override
    public final M2 process(Object m) {
        return (M2)(this.matches(m) ? m : null);
    }

    private MessageSelector() {
    }
}

