/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors.behaviors;

import co.paralleluniverse.actors.Actor;
import co.paralleluniverse.actors.ActorLoader;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.MailboxConfig;
import co.paralleluniverse.actors.behaviors.BehaviorActor;
import co.paralleluniverse.actors.behaviors.EventHandler;
import co.paralleluniverse.actors.behaviors.EventSource;
import co.paralleluniverse.actors.behaviors.Initializer;
import co.paralleluniverse.actors.behaviors.RequestMessage;
import co.paralleluniverse.fibers.FiberFactory;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.StrandFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Instrumented
public class EventSourceActor<Event>
extends BehaviorActor {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourceActor.class);
    private final List<EventHandler<Event>> handlers = new ArrayList<EventHandler<Event>>();
    private final List<EventHandler<Event>> nonUpgradedHandlers = new ArrayList<EventHandler<Event>>();

    public EventSourceActor(String name, Initializer initializer, Strand strand, MailboxConfig mailboxConfig) {
        super(name, initializer, strand, mailboxConfig);
    }

    @Override
    protected EventSource<Event> makeRef(ActorRef<Object> ref) {
        return new EventSource(ref);
    }

    @Override
    public EventSource<Event> ref() {
        return (EventSource)super.ref();
    }

    @Override
    protected EventSource<Event> self() {
        return this.ref();
    }

    @Override
    public EventSource<Event> spawn(StrandFactory sf) {
        return (EventSource)super.spawn(sf);
    }

    @Override
    public EventSource<Event> spawn(FiberFactory ff) {
        return (EventSource)super.spawn(ff);
    }

    @Override
    public EventSource<Event> spawn() {
        return (EventSource)super.spawn();
    }

    @Override
    public EventSource<Event> spawnThread() {
        return (EventSource)super.spawnThread();
    }

    public static <Event> EventSourceActor<Event> currentEventSourceActor() {
        return (EventSourceActor)Actor.currentActor();
    }

    @Override
    public Logger log() {
        return LOG;
    }

    public EventSourceActor(String name, Initializer initializer, MailboxConfig mailboxConfig) {
        this(name, initializer, null, mailboxConfig);
    }

    public EventSourceActor(String name, Initializer initializer) {
        this(name, initializer, null, null);
    }

    public EventSourceActor(Initializer initializer, MailboxConfig mailboxConfig) {
        this(null, initializer, null, mailboxConfig);
    }

    public EventSourceActor(Initializer initializer) {
        this(null, initializer, null, null);
    }

    public EventSourceActor(String name, MailboxConfig mailboxConfig) {
        this(name, null, null, mailboxConfig);
    }

    public EventSourceActor(String name) {
        this(name, null, null, null);
    }

    public EventSourceActor(MailboxConfig mailboxConfig) {
        this(null, null, null, mailboxConfig);
    }

    public EventSourceActor() {
        this(null, null, null, null);
    }

    @Instrumented(suspendableCallSites={}, suspendableCallSitesOffsetsAfterInstr={}, methodStart=182, methodEnd=188, methodOptimized=true)
    protected boolean addHandler(EventHandler<Event> handler) throws SuspendExecution, InterruptedException {
        this.verifyInActor();
        EventHandler<Event> _handler = ActorLoader.getReplacementFor(handler);
        this.log().info("{} adding handler {}", (Object)this, _handler);
        boolean res = this.handlers.add(_handler);
        this.nonUpgradedHandlers.add(handler);
        return res;
    }

    @Instrumented(suspendableCallSites={}, suspendableCallSitesOffsetsAfterInstr={}, methodStart=192, methodEnd=202, methodOptimized=true)
    protected boolean removeHandler(EventHandler<Event> handler) throws SuspendExecution, InterruptedException {
        this.verifyInActor();
        this.log().info("{} removing handler {}", (Object)this, handler);
        int index = -1;
        index = this.handlers.indexOf(handler);
        if (index == -1) {
            index = this.nonUpgradedHandlers.indexOf(handler);
        }
        if (index == -1) {
            return false;
        }
        this.handlers.remove(index);
        this.nonUpgradedHandlers.remove(index);
        return true;
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={206}, suspendableCallSitesOffsetsAfterInstr={99}, methodStart=206, methodEnd=207, methodOptimized=false)
    protected void notify(Event var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={217, 217, 219, 219, 222, 225}, suspendableCallSitesOffsetsAfterInstr={220, 319, 440, 539, 641, 706}, methodStart=211, methodEnd=226, methodOptimized=false)
    protected final void handleMessage(Object var1_1) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @Instrumented(suspendableCallSites={230}, suspendableCallSitesOffsetsAfterInstr={2}, methodStart=230, methodEnd=232, methodOptimized=true)
    protected void onTerminate(Throwable cause) throws SuspendExecution, InterruptedException {
        super.onTerminate(cause);
        this.handlers.clear();
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={245}, suspendableCallSitesOffsetsAfterInstr={245}, methodStart=235, methodEnd=247, methodOptimized=false)
    private void notifyHandlers(Event var1_1) throws InterruptedException, SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class HandlerMessage<Event>
    extends RequestMessage {
        final EventHandler<Event> handler;
        final boolean add;

        public HandlerMessage(ActorRef<?> from, Object id, EventHandler<Event> handler, boolean add) {
            super(from, id);
            this.handler = handler;
            this.add = add;
        }

        @Override
        protected String contentString() {
            return super.contentString() + " handler: " + this.handler + " add: " + this.add;
        }
    }
}

