/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors;

import co.paralleluniverse.actors.ActorImpl;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ActorUtil;
import co.paralleluniverse.actors.LifecycleListener;
import co.paralleluniverse.actors.LifecycleMessage;
import co.paralleluniverse.actors.RemoteActorProxyFactoryService;
import co.paralleluniverse.concurrent.util.MapUtil;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.channels.SendPort;
import co.paralleluniverse.strands.queues.QueueCapacityExceededException;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

@Instrumented
public abstract class FakeActor<Message>
extends ActorImpl<Message> {
    private static final Throwable NATURAL = new Throwable();
    private final Set<LifecycleListener> lifecycleListeners = Collections.newSetFromMap(MapUtil.newConcurrentHashMap());
    private final Set<ActorImpl> observed = Collections.newSetFromMap(MapUtil.newConcurrentHashMap());
    private volatile Throwable deathCause;

    public FakeActor(String name, SendPort<Message> mailbox) {
        super(name, mailbox, null);
    }

    protected Message filterMessage(Object m) {
        if (m instanceof LifecycleMessage) {
            return this.handleLifecycleMessage((LifecycleMessage)m);
        }
        return (Message)m;
    }

    @Override
    public boolean trySend(Message message) {
        this.record(1, "ActorRef", "trySend", "Sending %s -> %s", (Object)message, (Object)this);
        Message msg = this.filterMessage(message);
        if (msg == null) {
            return true;
        }
        if (this.mailbox().trySend(msg)) {
            return true;
        }
        this.record(1, "ActorRef", "trySend", "Message not sent. Mailbox is not ready.");
        return false;
    }

    @Override
    protected void internalSendNonSuspendable(Object message) {
        this.record(1, "ActorRef", "internalSendNonSuspendable", "Sending %s -> %s", message, (Object)this);
        Message msg = this.filterMessage(message);
        if (msg == null) {
            return;
        }
        if (!this.mailbox().trySend(msg)) {
            throw new QueueCapacityExceededException();
        }
    }

    @Override
    protected void addLifecycleListener(LifecycleListener listener) {
        Throwable cause = this.getDeathCause();
        if (this.isDone()) {
            listener.dead(this.ref(), cause);
            return;
        }
        this.lifecycleListeners.add(listener);
        if (this.isDone()) {
            listener.dead(this.ref(), cause);
        }
    }

    protected final Throwable getDeathCause() {
        return this.deathCause == NATURAL ? null : this.deathCause;
    }

    protected final boolean isDone() {
        return this.deathCause != null;
    }

    @Override
    protected void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycleListeners.remove(listener);
    }

    @Override
    protected void removeObserverListeners(ActorRef actor) {
        Iterator<LifecycleListener> it = this.lifecycleListeners.iterator();
        while (it.hasNext()) {
            LifecycleListener lifecycleListener = it.next();
            if (!(lifecycleListener instanceof ActorImpl.ActorLifecycleListener) || !((ActorImpl.ActorLifecycleListener)lifecycleListener).getObserver().equals(actor)) continue;
            it.remove();
        }
    }

    public final Object watch(ActorRef other) {
        Object id = ActorUtil.randtag();
        ActorImpl other1 = FakeActor.getActorRefImpl(other);
        ActorImpl.ActorLifecycleListener listener = new ActorImpl.ActorLifecycleListener(this.ref(), id);
        this.record(1, "Actor", "watch", "Actor %s to watch %s (listener: %s)", (Object)this, (Object)other1, (Object)listener);
        other1.addLifecycleListener(listener);
        this.observed.add(other1);
        return id;
    }

    public final void unwatch(ActorRef other, Object watchId) {
        ActorImpl other1 = FakeActor.getActorRefImpl(other);
        ActorImpl.ActorLifecycleListener listener = new ActorImpl.ActorLifecycleListener(this.ref(), watchId);
        this.record(1, "Actor", "unwatch", "Actor %s to stop watching %s (listener: %s)", (Object)this, (Object)other1, (Object)listener);
        other1.removeLifecycleListener(listener);
        this.observed.remove(FakeActor.getActorRefImpl(other));
    }

    protected abstract Message handleLifecycleMessage(LifecycleMessage var1);

    protected void die(Throwable cause) {
        this.record(1, "Actor", "die", "Actor %s is dying of cause %s", (Object)this, (Object)cause);
        this.deathCause = cause == null ? NATURAL : cause;
        for (LifecycleListener listener : this.lifecycleListeners) {
            ActorImpl.ActorLifecycleListener l;
            this.record(1, "Actor", "die", "Actor %s notifying listener %s of death.", (Object)this, (Object)listener);
            try {
                listener.dead(this.ref(), cause);
            }
            catch (Exception e) {
                this.record(1, "Actor", "die", "Actor %s notifying listener %s of death failed with excetpion %s", (Object)this, (Object)listener, (Object)e);
            }
            if (!(listener instanceof ActorImpl.ActorLifecycleListener) || (l = (ActorImpl.ActorLifecycleListener)listener).getId() != null) continue;
            l.getObserver().getImpl().removeObserverListeners(this.ref());
        }
        this.lifecycleListeners.clear();
        for (ActorImpl a : this.observed) {
            a.removeObserverListeners(this.ref());
        }
        this.observed.clear();
    }

    protected final Object writeReplace() throws ObjectStreamException {
        return RemoteActorProxyFactoryService.create(this.ref(), null);
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={81}, suspendableCallSitesOffsetsAfterInstr={163}, methodStart=76, methodEnd=85, methodOptimized=false)
    protected void internalSend(Object var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

