/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors;

import co.paralleluniverse.actors.ActorImpl;
import co.paralleluniverse.actors.ActorRefCanonicalizerService;
import co.paralleluniverse.actors.ActorRefDelegate;
import co.paralleluniverse.actors.LostActor;
import co.paralleluniverse.common.util.DelegatingEquals;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.SendPort;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Instrumented
public class ActorRef<Message>
implements SendPort<Message>,
Serializable {
    private volatile ActorImpl<Message> impl;
    private static final Field actorImplRefField;

    protected ActorRef(ActorImpl<Message> impl) {
        this.setImpl(impl);
    }

    protected ActorRef() {
    }

    public String getName() {
        return this.getImpl().getName();
    }

    protected ActorImpl<Message> getImpl() {
        return this.impl;
    }

    void setImpl(ActorImpl<Message> impl) {
        this.impl = impl;
        ActorRef r = impl.ref;
        if (r != null && ActorRefDelegate.stripDelegates(r) != this) {
            throw new IllegalStateException("Actor " + impl + " already has a ref: " + ActorRefDelegate.stripDelegates(r));
        }
    }

    public boolean trySend(Message msg) {
        try {
            return this.getImpl().trySend(msg);
        }
        catch (RuntimeException e) {
            LostActor.instance.ref().trySend(msg);
            LostActor.instance.throwIn(e);
            return false;
        }
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    public void close(Throwable t) {
        throw new UnsupportedOperationException();
    }

    protected void interrupt() {
        this.getImpl().interrupt();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof DelegatingEquals) {
            return obj.equals(this);
        }
        if (this.getImpl() == null) {
            return false;
        }
        if (!(obj instanceof ActorRef)) {
            return false;
        }
        ActorRef other = (ActorRef)obj;
        return this.getImpl().equals(other.getImpl());
    }

    public int hashCode() {
        return 581 + Objects.hashCode(this.getImpl());
    }

    public String toString() {
        return "ActorRef@" + Integer.toHexString(System.identityHashCode(this)) + "{" + this.getImpl() + '}';
    }

    Object readResolve() {
        if (this.impl == null) {
            return null;
        }
        ActorRef<Message> ref = ActorRefCanonicalizerService.getRef(this.impl, this);
        if (this.impl.ref == null) {
            ActorRef.setRef(this.impl, ref);
        }
        return ref;
    }

    private static <T> void setRef(ActorImpl<T> impl, ActorRef<T> ref) {
        try {
            actorImplRefField.set(impl, ref);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        try {
            actorImplRefField = ActorImpl.class.getDeclaredField("ref");
            actorImplRefField.setAccessible(true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={75, 81}, suspendableCallSitesOffsetsAfterInstr={142, 242}, methodStart=72, methodEnd=84, methodOptimized=false)
    public void send(Message var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={97, 99}, suspendableCallSitesOffsetsAfterInstr={109, 186}, methodStart=96, methodEnd=102, methodOptimized=false)
    public void sendSync(Message var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Instrumented(suspendableCallSites={122}, suspendableCallSitesOffsetsAfterInstr={2}, methodStart=122, methodEnd=123, methodOptimized=true)
    public boolean send(Message message, long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
        this.send(message);
        return true;
    }

    @Instrumented(suspendableCallSites={143}, suspendableCallSitesOffsetsAfterInstr={2}, methodStart=143, methodEnd=144, methodOptimized=true)
    public boolean send(Message message, Timeout timeout) throws SuspendExecution, InterruptedException {
        this.send(message);
        return true;
    }
}

