/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.PoissonDist;
import umontreal.ssj.randvar.RandomVariateGenInt;
import umontreal.ssj.rng.RandomStream;

public class PoissonGen
extends RandomVariateGenInt {
    protected double lambda;

    public PoissonGen(RandomStream s, double lambda) {
        super(s, new PoissonDist(lambda));
        this.setParams(lambda);
    }

    public PoissonGen(RandomStream s, PoissonDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getLambda());
        }
    }

    public static int nextInt(RandomStream s, double lambda) {
        return PoissonDist.inverseF(lambda, s.nextDouble());
    }

    public double getLambda() {
        return this.lambda;
    }

    protected void setParams(double lam) {
        if (lam <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.lambda = lam;
    }
}

