/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.randvar.ChiSquareNoncentralGen;
import umontreal.ssj.randvar.GammaAcceptanceRejectionGen;
import umontreal.ssj.randvar.PoissonTIACGen;
import umontreal.ssj.rng.RandomStream;

public class ChiSquareNoncentralPoisGen
extends ChiSquareNoncentralGen {
    public ChiSquareNoncentralPoisGen(RandomStream stream, double nu, double lambda) {
        super(stream, null);
        this.setParams(nu, lambda);
        if (lambda > 4.29E9) {
            throw new UnsupportedOperationException("   lambda too large");
        }
    }

    @Override
    public double nextDouble() {
        return ChiSquareNoncentralPoisGen.poisGenere(this.stream, this.nu, this.lambda);
    }

    public static double nextDouble(RandomStream stream, double nu, double lambda) {
        return ChiSquareNoncentralPoisGen.poisGenere(stream, nu, lambda);
    }

    private static double poisGenere(RandomStream s, double nu, double lambda) {
        int j = PoissonTIACGen.nextInt(s, 0.5 * lambda);
        return GammaAcceptanceRejectionGen.nextDouble(s, 0.5 * nu + (double)j, 0.5);
    }
}

