/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.hups;

import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.rng.RandomStream;
import umontreal.ssj.util.PrintfFormat;

public class DigitalNet
extends PointSet {
    protected int b = 0;
    protected int numCols = 0;
    protected int numRows = 0;
    protected int outDigits = 0;
    private int[][] originalMat;
    protected int[][] genMat;
    protected int[][] digitalShift;
    protected double normFactor;
    protected double[] factor;
    private int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67};
    private int[][] FaureFactor = new int[][]{{1}, {1, 2}, {2, 3, 1, 4}, {2, 3, 4, 5, 1, 6}, {3, 4, 7, 8, 2, 5, 6, 9, 1, 10}, {5, 8, 3, 4, 9, 10, 2, 6, 7, 11, 1, 12}, {5, 7, 10, 12, 3, 6, 11, 14, 4, 13, 2, 8, 9, 15, 1, 16}, {7, 8, 11, 12, 4, 5, 14, 15, 3, 6, 13, 16, 2, 9, 10, 17, 1, 18}, {5, 9, 14, 18, 7, 10, 13, 16, 4, 6, 17, 19, 3, 8, 15, 20, 2, 11, 12, 21, 1, 22}, {8, 11, 18, 21, 12, 17, 9, 13, 16, 20, 5, 6, 23, 24, 4, 7, 22, 25, 3, 10, 19, 26, 2, 14, 15, 27, 1, 28}, {12, 13, 18, 19, 11, 14, 17, 20, 7, 9, 22, 24, 4, 8, 23, 27, 5, 6, 25, 26, 3, 10, 21, 28, 2, 15, 16, 29, 1, 30}, {8, 14, 23, 29, 10, 11, 26, 27, 13, 17, 20, 24, 7, 16, 21, 30, 5, 15, 22, 32, 6, 31, 4, 9, 28, 33, 3, 12, 25, 34, 2, 18, 19, 35, 1, 36}, {16, 18, 23, 25, 11, 15, 26, 30, 12, 17, 24, 29, 9, 32, 13, 19, 22, 28, 6, 7, 34, 35, 5, 8, 33, 36, 4, 10, 31, 37, 3, 14, 27, 38, 2, 20, 21, 39, 1, 40}, {12, 18, 25, 31, 9, 19, 24, 34, 8, 16, 27, 35, 10, 13, 30, 33, 15, 20, 23, 28, 5, 17, 26, 38, 6, 7, 36, 37, 4, 11, 32, 39, 3, 14, 29, 40, 2, 21, 22, 41, 1, 42}, {13, 18, 29, 34, 11, 17, 30, 36, 10, 14, 33, 37, 7, 20, 27, 40, 9, 21, 26, 38, 15, 22, 25, 32, 6, 8, 39, 41, 5, 19, 28, 42, 4, 12, 35, 43, 3, 16, 31, 44, 2, 23, 24, 45, 1, 46}, {14, 19, 34, 39, 23, 30, 12, 22, 31, 41, 8, 11, 20, 24, 29, 33, 42, 45, 10, 16, 37, 43, 7, 15, 38, 46, 17, 25, 28, 36, 5, 21, 32, 48, 6, 9, 44, 47, 4, 13, 40, 49, 3, 18, 35, 50, 2, 26, 27, 51, 1, 52}, {25, 26, 33, 34, 18, 23, 36, 41, 14, 21, 38, 45, 24, 27, 32, 35, 11, 16, 43, 48, 9, 13, 46, 50, 8, 22, 37, 51, 7, 17, 42, 52, 19, 28, 31, 40, 6, 10, 49, 53, 5, 12, 47, 54, 4, 15, 44, 55, 3, 20, 39, 56, 2, 29, 30, 57, 1, 58}, {22, 25, 36, 39, 17, 18, 43, 44, 24, 28, 33, 37, 13, 14, 47, 48, 16, 19, 42, 45, 9, 27, 34, 52, 8, 23, 38, 53, 11, 50, 7, 26, 35, 54, 21, 29, 32, 40, 6, 10, 51, 55, 5, 12, 49, 56, 4, 15, 46, 57, 3, 20, 41, 58, 2, 30, 31, 59, 1, 60}, {18, 26, 41, 49, 14, 24, 43, 53, 12, 28, 39, 55, 29, 30, 37, 38, 10, 20, 47, 57, 16, 21, 46, 51, 8, 25, 42, 59, 13, 31, 36, 54, 9, 15, 52, 58, 7, 19, 48, 60, 23, 32, 35, 44, 5, 27, 40, 62, 6, 11, 56, 61, 4, 17, 50, 63, 3, 22, 45, 64, 2, 33, 34, 65, 1, 66}};

    @Override
    public double getCoordinate(int i, int j) {
        int[] bdigit = new int[this.numCols];
        int[] gdigit = new int[this.numCols];
        int idigits = this.intToDigitsGray(this.b, i, this.numCols, bdigit, gdigit);
        double result = 0.0;
        if (this.digitalShift != null && this.dimShift < j) {
            this.addRandomShift(this.dimShift, j, this.shiftStream);
        }
        for (int l = 0; l < this.outDigits; ++l) {
            int sum = this.digitalShift == null ? 0 : this.digitalShift[j][l];
            if (l < this.numRows) {
                for (int c = 0; c < idigits; ++c) {
                    sum += this.genMat[j * this.numCols + c][l] * gdigit[c];
                }
            }
            result += (double)(sum % this.b) * this.factor[l];
        }
        if (this.digitalShift != null) {
            result += this.EpsilonHalf;
        }
        return result;
    }

    @Override
    public PointSetIterator iterator() {
        return new DigitalNetIterator();
    }

    public double getCoordinateNoGray(int i, int j) {
        int[] bdigit = new int[this.numCols];
        int idigits = 0;
        int c = 0;
        while (i > 0) {
            ++idigits;
            bdigit[c] = i % this.b;
            i /= this.b;
            ++c;
        }
        if (this.digitalShift != null && this.dimShift < j) {
            this.addRandomShift(this.dimShift, j, this.shiftStream);
        }
        double result = 0.0;
        for (int l = 0; l < this.outDigits; ++l) {
            int sum = this.digitalShift == null ? 0 : this.digitalShift[j][l];
            if (l < this.numRows) {
                for (c = 0; c < idigits; ++c) {
                    sum += this.genMat[j * this.numCols + c][l] * bdigit[c];
                }
            }
            result += (double)(sum % this.b) * this.factor[l];
        }
        if (this.digitalShift != null) {
            result += this.EpsilonHalf;
        }
        return result;
    }

    public PointSetIterator iteratorNoGray() {
        return new DigitalNetIteratorNoGray();
    }

    @Override
    public void addRandomShift(int d1, int d2, RandomStream stream) {
        if (null == stream) {
            throw new IllegalArgumentException(PrintfFormat.NEWLINE + "   Calling addRandomShift with null stream");
        }
        if (0 == d2) {
            d2 = Math.max(1, this.dim);
        }
        if (this.digitalShift == null) {
            this.digitalShift = new int[d2][this.outDigits];
            this.capacityShift = d2;
        } else if (d2 > this.capacityShift) {
            int d3;
            for (d3 = Math.max(4, this.capacityShift); d2 > d3; d3 *= 2) {
            }
            int[][] temp = new int[d3][this.outDigits];
            this.capacityShift = d3;
            for (int i = 0; i < d1; ++i) {
                for (int j = 0; j < this.outDigits; ++j) {
                    temp[i][j] = this.digitalShift[i][j];
                }
            }
            this.digitalShift = temp;
        }
        for (int i = d1; i < d2; ++i) {
            for (int j = 0; j < this.outDigits; ++j) {
                this.digitalShift[i][j] = stream.nextInt(0, this.b - 1);
            }
        }
        this.dimShift = d2;
        this.shiftStream = stream;
    }

    @Override
    public void addRandomShift(RandomStream stream) {
        this.addRandomShift(0, this.dim, stream);
    }

    @Override
    public void clearRandomShift() {
        super.clearRandomShift();
        this.digitalShift = null;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        if (this.b > 0) {
            sb.append(", base = ");
            sb.append(this.b);
        }
        sb.append(", Num cols = ");
        sb.append(this.numCols);
        sb.append(", Num rows = ");
        sb.append(this.numRows);
        sb.append(", outDigits = ");
        sb.append(this.outDigits);
        return sb.toString();
    }

    protected void printMat(int N, int[][][] A, String name) {
        for (int i = 0; i < N; ++i) {
            System.out.println("-------------------------------------" + PrintfFormat.NEWLINE + name + "   dim = " + i);
            for (int l = 0; l < this.numRows; ++l) {
                for (int c = 0; c < this.numCols; ++c) {
                    System.out.print(A[i][l][c] + "  ");
                }
                System.out.println("");
            }
        }
        System.out.println("");
    }

    protected void printMat0(int[][] A, String name) {
        System.out.println("-------------------------------------" + PrintfFormat.NEWLINE + name);
        for (int l = 0; l < this.numCols; ++l) {
            for (int c = 0; c < this.numCols; ++c) {
                System.out.print(A[l][c] + "  ");
            }
            System.out.println("");
        }
        System.out.println("");
    }

    private void leftMultiplyMat(int j, int[][] Mj) {
        for (int l = 0; l < this.numRows; ++l) {
            for (int c = 0; c < this.numCols; ++c) {
                int sum = 0;
                for (int i = 0; i <= l; ++i) {
                    sum += Mj[l][i] * this.originalMat[j * this.numCols + c][i];
                }
                this.genMat[j * this.numCols + c][l] = sum % this.b;
            }
        }
    }

    private void leftMultiplyMatDiag(int j, int[][] Mj) {
        for (int l = 0; l < this.numRows; ++l) {
            for (int c = 0; c < this.numCols; ++c) {
                int sum = Mj[l][l] * this.originalMat[j * this.numCols + c][l];
                this.genMat[j * this.numCols + c][l] = sum % this.b;
            }
        }
    }

    private void rightMultiplyMat(int j, int[][] Mj) {
        for (int l = 0; l < this.numRows; ++l) {
            for (int c = 0; c < this.numCols; ++c) {
                int sum = 0;
                for (int i = 0; i <= c; ++i) {
                    sum += this.originalMat[j * this.numCols + i][l] * Mj[i][c];
                }
                this.genMat[j * this.numCols + c][l] = sum % this.b;
            }
        }
    }

    private int getFaureIndex(String method, int sb, int flag) {
        int ib;
        if (sb >= this.b) {
            throw new IllegalArgumentException(PrintfFormat.NEWLINE + "   sb >= base in " + method);
        }
        if (sb < 1) {
            throw new IllegalArgumentException(PrintfFormat.NEWLINE + "   sb = 0 in " + method);
        }
        if (flag > 2 || flag < 0) {
            throw new IllegalArgumentException(PrintfFormat.NEWLINE + "   lowerFlag not in {0, 1, 2} in " + method);
        }
        for (ib = 0; ib < this.primes.length && this.primes[ib] < this.b; ++ib) {
        }
        if (ib >= this.primes.length) {
            throw new IllegalArgumentException("base too large in " + method);
        }
        if (this.b != this.primes[ib]) {
            throw new IllegalArgumentException("Faure factors are not implemented for this base in " + method);
        }
        return ib;
    }

    public void leftMatrixScramble(RandomStream stream) {
        int j;
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] scrambleMat = new int[this.dim][this.numRows][this.numRows];
        for (j = 0; j < this.dim; ++j) {
            for (int l = 0; l < this.numRows; ++l) {
                for (int c = 0; c < this.numRows; ++c) {
                    scrambleMat[j][l][c] = c == l ? stream.nextInt(1, this.b - 1) : (c < l ? stream.nextInt(0, this.b - 1) : 0);
                }
            }
        }
        for (j = 0; j < this.dim; ++j) {
            this.leftMultiplyMat(j, scrambleMat[j]);
        }
    }

    public void leftMatrixScrambleDiag(RandomStream stream) {
        int j;
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] scrambleMat = new int[this.dim][this.numRows][this.numRows];
        for (j = 0; j < this.dim; ++j) {
            for (int l = 0; l < this.numRows; ++l) {
                for (int c = 0; c < this.numRows; ++c) {
                    scrambleMat[j][l][c] = c == l ? stream.nextInt(1, this.b - 1) : 0;
                }
            }
        }
        for (j = 0; j < this.dim; ++j) {
            this.leftMultiplyMatDiag(j, scrambleMat[j]);
        }
    }

    private void LMSFaurePermut(String method, RandomStream stream, int sb, int lowerFlag) {
        int j;
        int ib = this.getFaureIndex(method, sb, lowerFlag);
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] scrambleMat = new int[this.dim][this.numRows][this.numRows];
        for (j = 0; j < this.dim; ++j) {
            for (int l = 0; l < this.numRows; ++l) {
                for (int c = 0; c < this.numRows; ++c) {
                    int jb;
                    if (c == l) {
                        jb = stream.nextInt(0, sb - 1);
                        scrambleMat[j][l][c] = this.FaureFactor[ib][jb];
                        continue;
                    }
                    if (c < l) {
                        if (lowerFlag == 2) {
                            scrambleMat[j][l][c] = stream.nextInt(0, this.b - 1);
                            continue;
                        }
                        if (lowerFlag == 1) {
                            jb = stream.nextInt(0, sb - 1);
                            scrambleMat[j][l][c] = this.FaureFactor[ib][jb];
                            continue;
                        }
                        scrambleMat[j][l][c] = 0;
                        continue;
                    }
                    scrambleMat[j][l][c] = 0;
                }
            }
        }
        if (lowerFlag == 0) {
            for (j = 0; j < this.dim; ++j) {
                this.leftMultiplyMatDiag(j, scrambleMat[j]);
            }
        } else {
            for (j = 0; j < this.dim; ++j) {
                this.leftMultiplyMat(j, scrambleMat[j]);
            }
        }
    }

    public void leftMatrixScrambleFaurePermut(RandomStream stream, int sb) {
        this.LMSFaurePermut("leftMatrixScrambleFaurePermut", stream, sb, 2);
    }

    public void leftMatrixScrambleFaurePermutDiag(RandomStream stream, int sb) {
        this.LMSFaurePermut("leftMatrixScrambleFaurePermutDiag", stream, sb, 0);
    }

    public void leftMatrixScrambleFaurePermutAll(RandomStream stream, int sb) {
        this.LMSFaurePermut("leftMatrixScrambleFaurePermutAll", stream, sb, 1);
    }

    public void iBinomialMatrixScramble(RandomStream stream) {
        int j;
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] scrambleMat = new int[this.dim][this.numRows][this.numRows];
        for (j = 0; j < this.dim; ++j) {
            int c;
            int l;
            int diag = stream.nextInt(1, this.b - 1);
            for (l = 0; l < this.numRows; ++l) {
                scrambleMat[j][l][l] = diag;
                for (c = l + 1; c < this.numRows; ++c) {
                    scrambleMat[j][l][c] = 0;
                }
            }
            for (l = 1; l < this.numRows; ++l) {
                int col1 = stream.nextInt(0, this.b - 1);
                c = 0;
                while (l + c < this.numRows) {
                    scrambleMat[j][l + c][c] = col1;
                    ++c;
                }
            }
        }
        for (j = 0; j < this.dim; ++j) {
            this.leftMultiplyMat(j, scrambleMat[j]);
        }
    }

    private void iBMSFaurePermut(String method, RandomStream stream, int sb, int lowerFlag) {
        int j;
        int ib = this.getFaureIndex(method, sb, lowerFlag);
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] scrambleMat = new int[this.dim][this.numRows][this.numRows];
        for (j = 0; j < this.dim; ++j) {
            int c;
            int l;
            int jb = stream.nextInt(0, sb - 1);
            int diag = this.FaureFactor[ib][jb];
            for (l = 0; l < this.numRows; ++l) {
                scrambleMat[j][l][l] = diag;
                for (c = l + 1; c < this.numRows; ++c) {
                    scrambleMat[j][l][c] = 0;
                }
            }
            for (l = 1; l < this.numRows; ++l) {
                int col1;
                if (lowerFlag == 2) {
                    col1 = stream.nextInt(0, this.b - 1);
                } else if (lowerFlag == 1) {
                    jb = stream.nextInt(0, sb - 1);
                    col1 = this.FaureFactor[ib][jb];
                } else {
                    col1 = 0;
                }
                c = 0;
                while (l + c < this.numRows) {
                    scrambleMat[j][l + c][c] = col1;
                    ++c;
                }
            }
        }
        if (lowerFlag > 0) {
            for (j = 0; j < this.dim; ++j) {
                this.leftMultiplyMat(j, scrambleMat[j]);
            }
        } else {
            for (j = 0; j < this.dim; ++j) {
                this.leftMultiplyMatDiag(j, scrambleMat[j]);
            }
        }
    }

    public void iBinomialMatrixScrambleFaurePermut(RandomStream stream, int sb) {
        this.iBMSFaurePermut("iBinomialMatrixScrambleFaurePermut", stream, sb, 2);
    }

    public void iBinomialMatrixScrambleFaurePermutDiag(RandomStream stream, int sb) {
        this.iBMSFaurePermut("iBinomialMatrixScrambleFaurePermutDiag", stream, sb, 0);
    }

    public void iBinomialMatrixScrambleFaurePermutAll(RandomStream stream, int sb) {
        this.iBMSFaurePermut("iBinomialMatrixScrambleFaurePermutAll", stream, sb, 1);
    }

    public void stripedMatrixScramble(RandomStream stream) {
        int j;
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] scrambleMat = new int[this.dim][this.numRows][this.numRows];
        for (j = 0; j < this.dim; ++j) {
            for (int c = 0; c < this.numRows; ++c) {
                int l;
                int diag = stream.nextInt(1, this.b - 1);
                for (l = 0; l < c; ++l) {
                    scrambleMat[j][l][c] = 0;
                }
                for (l = c; l < this.numRows; ++l) {
                    scrambleMat[j][l][c] = diag;
                }
            }
        }
        for (j = 0; j < this.dim; ++j) {
            this.leftMultiplyMat(j, scrambleMat[j]);
        }
    }

    public void stripedMatrixScrambleFaurePermutAll(RandomStream stream, int sb) {
        int j;
        int ib = this.getFaureIndex("stripedMatrixScrambleFaurePermutAll", sb, 1);
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][][] scrambleMat = new int[this.dim][this.numRows][this.numRows];
        for (j = 0; j < this.dim; ++j) {
            for (int c = 0; c < this.numRows; ++c) {
                int l;
                int jb = stream.nextInt(0, sb - 1);
                int diag = this.FaureFactor[ib][jb];
                for (l = 0; l < c; ++l) {
                    scrambleMat[j][l][c] = 0;
                }
                for (l = c; l < this.numRows; ++l) {
                    scrambleMat[j][l][c] = diag;
                }
            }
        }
        for (j = 0; j < this.dim; ++j) {
            this.leftMultiplyMat(j, scrambleMat[j]);
        }
    }

    public void rightMatrixScramble(RandomStream stream) {
        if (this.originalMat == null) {
            this.originalMat = this.genMat;
            this.genMat = new int[this.dim * this.numCols][this.numRows];
        }
        int[][] scrambleMat = new int[this.numCols][this.numCols];
        for (int c = 0; c < this.numCols; ++c) {
            int l;
            for (l = 0; l < c; ++l) {
                scrambleMat[l][c] = stream.nextInt(0, this.b - 1);
            }
            scrambleMat[c][c] = stream.nextInt(1, this.b - 1);
            for (l = c + 1; l < this.numCols; ++l) {
                scrambleMat[l][c] = 0;
            }
        }
        for (int j = 0; j < this.dim; ++j) {
            this.rightMultiplyMat(j, scrambleMat);
        }
    }

    public void unrandomize() {
        this.resetGeneratorMatrices();
        this.digitalShift = null;
    }

    public void resetGeneratorMatrices() {
        if (this.originalMat != null) {
            this.genMat = this.originalMat;
            this.originalMat = null;
        }
    }

    public void eraseOriginalGeneratorMatrices() {
        this.originalMat = null;
    }

    public void printGeneratorMatrices(int s) {
        for (int j = 0; j < s; ++j) {
            System.out.println("dim = " + (j + 1) + PrintfFormat.NEWLINE);
            for (int l = 0; l < this.numRows; ++l) {
                for (int c = 0; c < this.numCols; ++c) {
                    System.out.print(this.genMat[j * this.numCols + c][l] + "  ");
                }
                System.out.println("");
            }
            System.out.println("----------------------------------");
        }
    }

    protected int intToDigitsGray(int b, int i, int numDigits, int[] bary, int[] gray) {
        if (i == 0) {
            return 0;
        }
        int idigits = 0;
        int c = 0;
        while (i > 0) {
            ++idigits;
            bary[c] = i % b;
            i /= b;
            ++c;
        }
        gray[idigits - 1] = bary[idigits - 1];
        for (c = 0; c < idigits - 1; ++c) {
            int diff = bary[c] - bary[c + 1];
            gray[c] = diff < 0 ? diff + b : diff;
        }
        for (c = idigits; c < numDigits; ++c) {
            bary[c] = 0;
            gray[c] = 0;
        }
        return idigits;
    }

    protected class DigitalNetIteratorNoGray
    extends DigitalNetIterator {
        @Override
        public void setCurPointIndex(int i) {
            if (i == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = i;
            this.curCoordIndex = 0;
            if (DigitalNet.this.dimShift < this.dimS) {
                DigitalNet.this.addRandomShift(DigitalNet.this.dimShift, this.dimS, DigitalNet.this.shiftStream);
            }
            this.idigits = DigitalNet.this.intToDigitsGray(DigitalNet.this.b, i, DigitalNet.this.numCols, this.bdigit, this.gdigit);
            for (int j = 0; j < this.dimS; ++j) {
                for (int l = 0; l < DigitalNet.this.outDigits; ++l) {
                    int sum = DigitalNet.this.digitalShift == null ? 0 : DigitalNet.this.digitalShift[j][l];
                    if (l < DigitalNet.this.numRows) {
                        for (int c = 0; c < this.idigits; ++c) {
                            sum += DigitalNet.this.genMat[j * DigitalNet.this.numCols + c][l] * this.bdigit[c];
                        }
                    }
                    this.cachedCurPoint[j * DigitalNet.this.outDigits + l] = sum % DigitalNet.this.b;
                }
            }
        }

        @Override
        public int resetToNextPoint() {
            ++this.curPointIndex;
            this.curCoordIndex = 0;
            if (this.curPointIndex >= DigitalNet.this.numPoints) {
                return this.curPointIndex;
            }
            int pos = 0;
            while (this.bdigit[pos] == DigitalNet.this.b - 1) {
                this.bdigit[pos] = 0;
                ++pos;
            }
            int n = pos;
            this.bdigit[n] = this.bdigit[n] + 1;
            int lsup = DigitalNet.this.numRows;
            if (DigitalNet.this.outDigits < DigitalNet.this.numRows) {
                lsup = DigitalNet.this.outDigits;
            }
            for (int j = 0; j < this.dimS; ++j) {
                for (int l = 0; l < lsup; ++l) {
                    for (int c = 0; c <= pos; ++c) {
                        int n2 = j * DigitalNet.this.outDigits + l;
                        this.cachedCurPoint[n2] = this.cachedCurPoint[n2] + DigitalNet.this.genMat[j * DigitalNet.this.numCols + c][l];
                    }
                    int n3 = j * DigitalNet.this.outDigits + l;
                    this.cachedCurPoint[n3] = this.cachedCurPoint[n3] % DigitalNet.this.b;
                }
            }
            return this.curPointIndex;
        }
    }

    protected class DigitalNetIterator
    extends PointSet.DefaultPointSetIterator {
        protected int idigits;
        protected int[] bdigit;
        protected int[] gdigit;
        protected int dimS;
        protected int[] cachedCurPoint;

        public DigitalNetIterator() {
            this.bdigit = new int[DigitalNet.this.numCols];
            this.gdigit = new int[DigitalNet.this.numCols];
            this.dimS = DigitalNet.this.dim;
            this.cachedCurPoint = new int[(DigitalNet.this.dim + 1) * DigitalNet.this.outDigits];
            this.init();
        }

        public void init() {
            this.resetCurPointIndex();
        }

        @Override
        public double nextDouble() {
            return this.nextCoordinate() + this.EpsilonHalf;
        }

        @Override
        public double nextCoordinate() {
            if (this.curPointIndex >= DigitalNet.this.numPoints || this.curCoordIndex >= this.dimS) {
                this.outOfBounds();
            }
            int start = DigitalNet.this.outDigits * this.curCoordIndex++;
            double sum = 0.0;
            for (int k = 0; k < DigitalNet.this.outDigits; ++k) {
                sum += (double)this.cachedCurPoint[start + k] * DigitalNet.this.factor[k];
            }
            if (DigitalNet.this.digitalShift != null) {
                sum += this.EpsilonHalf;
            }
            return sum;
        }

        @Override
        public void resetCurPointIndex() {
            int i;
            if (DigitalNet.this.digitalShift == null) {
                for (i = 0; i < this.cachedCurPoint.length; ++i) {
                    this.cachedCurPoint[i] = 0;
                }
            } else {
                if (DigitalNet.this.dimShift < this.dimS) {
                    DigitalNet.this.addRandomShift(DigitalNet.this.dimShift, this.dimS, DigitalNet.this.shiftStream);
                }
                for (int j = 0; j < this.dimS; ++j) {
                    for (int k = 0; k < DigitalNet.this.outDigits; ++k) {
                        this.cachedCurPoint[j * DigitalNet.this.outDigits + k] = DigitalNet.this.digitalShift[j][k];
                    }
                }
            }
            for (i = 0; i < DigitalNet.this.numCols; ++i) {
                this.bdigit[i] = 0;
            }
            for (i = 0; i < DigitalNet.this.numCols; ++i) {
                this.gdigit[i] = 0;
            }
            this.curPointIndex = 0;
            this.curCoordIndex = 0;
            this.idigits = 0;
        }

        @Override
        public void setCurPointIndex(int i) {
            if (i == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = i;
            this.curCoordIndex = 0;
            if (DigitalNet.this.digitalShift != null && DigitalNet.this.dimShift < this.dimS) {
                DigitalNet.this.addRandomShift(DigitalNet.this.dimShift, this.dimS, DigitalNet.this.shiftStream);
            }
            this.idigits = DigitalNet.this.intToDigitsGray(DigitalNet.this.b, i, DigitalNet.this.numCols, this.bdigit, this.gdigit);
            for (int j = 0; j < this.dimS; ++j) {
                for (int l = 0; l < DigitalNet.this.outDigits; ++l) {
                    int sum = DigitalNet.this.digitalShift == null ? 0 : DigitalNet.this.digitalShift[j][l];
                    if (l < DigitalNet.this.numRows) {
                        for (int c = 0; c < this.idigits; ++c) {
                            sum += DigitalNet.this.genMat[j * DigitalNet.this.numCols + c][l] * this.gdigit[c];
                        }
                    }
                    this.cachedCurPoint[j * DigitalNet.this.outDigits + l] = sum % DigitalNet.this.b;
                }
            }
        }

        @Override
        public int resetToNextPoint() {
            ++this.curPointIndex;
            this.curCoordIndex = 0;
            if (this.curPointIndex >= DigitalNet.this.numPoints) {
                return this.curPointIndex;
            }
            int pos = 0;
            while (this.gdigit[pos] == DigitalNet.this.b - 1) {
                this.gdigit[pos] = 0;
                ++pos;
            }
            int n = pos;
            this.gdigit[n] = this.gdigit[n] + 1;
            int lsup = DigitalNet.this.numRows;
            if (DigitalNet.this.outDigits < DigitalNet.this.numRows) {
                lsup = DigitalNet.this.outDigits;
            }
            for (int j = 0; j < this.dimS; ++j) {
                for (int l = 0; l < lsup; ++l) {
                    int n2 = j * DigitalNet.this.outDigits + l;
                    this.cachedCurPoint[n2] = this.cachedCurPoint[n2] + DigitalNet.this.genMat[j * DigitalNet.this.numCols + pos][l];
                    int n3 = j * DigitalNet.this.outDigits + l;
                    this.cachedCurPoint[n3] = this.cachedCurPoint[n3] % DigitalNet.this.b;
                }
            }
            return this.curPointIndex;
        }
    }
}

