/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.util;

public class Misc {
    private Misc() {
    }

    public static double quickSelect(double[] A, int n, int k) {
        double[] U = new double[n];
        double[] V = new double[n];
        double p = A[k - 1];
        int u = 0;
        int v = 0;
        int indV = 0;
        for (int i = 0; i < n; ++i) {
            if (A[i] <= p) {
                ++v;
                if (A[i] == p) continue;
                U[u++] = A[i];
                continue;
            }
            V[indV++] = A[i];
        }
        if (k <= u) {
            return Misc.quickSelect(U, u, k);
        }
        if (k > v) {
            return Misc.quickSelect(V, indV, k - v);
        }
        return p;
    }

    public static int quickSelect(int[] A, int n, int k) {
        int[] U = new int[n];
        int[] V = new int[n];
        int p = A[k - 1];
        int u = 0;
        int v = 0;
        int indV = 0;
        for (int i = 0; i < n; ++i) {
            if (A[i] <= p) {
                ++v;
                if (A[i] == p) continue;
                U[u++] = A[i];
                continue;
            }
            V[indV++] = A[i];
        }
        if (k <= u) {
            return Misc.quickSelect(U, u, k);
        }
        if (k > v) {
            return Misc.quickSelect(V, indV, k - v);
        }
        return p;
    }

    public static double getMedian(double[] A, int n) {
        int k = (n + 1) / 2;
        double med = Misc.quickSelect(A, n, k);
        if ((n & 1) == 0) {
            double y = Misc.quickSelect(A, n, k + 1);
            med = (med + y) / 2.0;
        }
        return med;
    }

    public static double getMedian(int[] A, int n) {
        int k = (n + 1) / 2;
        double med = Misc.quickSelect(A, n, k);
        if ((n & 1) == 0) {
            double y = Misc.quickSelect(A, n, k + 1);
            med = (med + y) / 2.0;
        }
        return med;
    }

    public static int getTimeInterval(double[] times, int start, int end, double t) {
        if (start < 0) {
            throw new IllegalArgumentException("The starting index must not be negative");
        }
        int n = end - start;
        if (n < 0) {
            throw new IllegalArgumentException("The ending index must be greater than or equal to the starting index");
        }
        if (t < times[start]) {
            return -1;
        }
        if (t >= times[end]) {
            return n;
        }
        int start0 = start;
        int mid = (start + end) / 2;
        while (t < times[mid] || t >= times[mid + 1]) {
            if (start == end) {
                throw new IllegalStateException();
            }
            if (t < times[mid]) {
                end = mid - 1;
            } else {
                start = mid + 1;
            }
            mid = (start + end) / 2;
        }
        return mid - start0;
    }

    public static void interpol(int n, double[] X, double[] Y, double[] C) {
        int j;
        for (j = 0; j <= n; ++j) {
            C[j] = Y[j];
        }
        for (int i = 1; i <= n; ++i) {
            for (j = n; j >= i; --j) {
                C[j] = X[j] == X[j - i] ? 0.0 : (C[j] - C[j - 1]) / (X[j] - X[j - i]);
            }
        }
    }

    public static double evalPoly(int n, double[] X, double[] C, double z) {
        double v = C[n];
        for (int j = n - 1; j >= 0; --j) {
            v = v * (z - X[j]) + C[j];
        }
        return v;
    }

    public static double evalPoly(double[] C, int n, double x) {
        double v = C[n];
        for (int j = n - 1; j >= 0; --j) {
            v = v * x + C[j];
        }
        return v;
    }
}

