/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.CSU_C09_CSPCSSORCOBROBXORCRXARXR;
import ca.uhn.hl7v2.model.v231.group.CSU_C09_PV1PV2;
import ca.uhn.hl7v2.model.v231.segment.CSR;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.model.v231.segment.PD1;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR
extends AbstractGroup {
    public CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(NTE.class, false, true, false);
            this.add(CSU_C09_PV1PV2.class, false, false, false);
            this.add(CSR.class, true, false, false);
            this.add(CSU_C09_CSPCSSORCOBROBXORCRXARXR.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CSU_C09_PIDPD1NTEPV1PV2CSRCSPCSSORCOBROBXORCRXARXR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public PID getPID() {
        PID retVal = (PID)this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = (PD1)this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public CSU_C09_PV1PV2 getPV1PV2() {
        CSU_C09_PV1PV2 retVal = (CSU_C09_PV1PV2)this.getTyped("PV1PV2", CSU_C09_PV1PV2.class);
        return retVal;
    }

    public CSR getCSR() {
        CSR retVal = (CSR)this.getTyped("CSR", CSR.class);
        return retVal;
    }

    public CSU_C09_CSPCSSORCOBROBXORCRXARXR getCSPCSSORCOBROBXORCRXARXR() {
        CSU_C09_CSPCSSORCOBROBXORCRXARXR retVal = (CSU_C09_CSPCSSORCOBROBXORCRXARXR)this.getTyped("CSPCSSORCOBROBXORCRXARXR", CSU_C09_CSPCSSORCOBROBXORCRXARXR.class);
        return retVal;
    }

    public CSU_C09_CSPCSSORCOBROBXORCRXARXR getCSPCSSORCOBROBXORCRXARXR(int rep) {
        CSU_C09_CSPCSSORCOBROBXORCRXARXR retVal = (CSU_C09_CSPCSSORCOBROBXORCRXARXR)this.getTyped("CSPCSSORCOBROBXORCRXARXR", rep, CSU_C09_CSPCSSORCOBROBXORCRXARXR.class);
        return retVal;
    }

    public int getCSPCSSORCOBROBXORCRXARXRReps() {
        return this.getReps("CSPCSSORCOBROBXORCRXARXR");
    }

    public List<CSU_C09_CSPCSSORCOBROBXORCRXARXR> getCSPCSSORCOBROBXORCRXARXRAll() throws HL7Exception {
        return this.getAllAsList("CSPCSSORCOBROBXORCRXARXR", CSU_C09_CSPCSSORCOBROBXORCRXARXR.class);
    }

    public void insertCSPCSSORCOBROBXORCRXARXR(CSU_C09_CSPCSSORCOBROBXORCRXARXR structure, int rep) throws HL7Exception {
        super.insertRepetition("CSPCSSORCOBROBXORCRXARXR", (Structure)structure, rep);
    }

    public CSU_C09_CSPCSSORCOBROBXORCRXARXR insertCSPCSSORCOBROBXORCRXARXR(int rep) throws HL7Exception {
        return (CSU_C09_CSPCSSORCOBROBXORCRXARXR)super.insertRepetition("CSPCSSORCOBROBXORCRXARXR", rep);
    }

    public CSU_C09_CSPCSSORCOBROBXORCRXARXR removeCSPCSSORCOBROBXORCRXARXR(int rep) throws HL7Exception {
        return (CSU_C09_CSPCSSORCOBROBXORCRXARXR)super.removeRepetition("CSPCSSORCOBROBXORCRXARXR", rep);
    }
}

