/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.ADT_A45_MERGE_INFO;
import ca.uhn.hl7v2.model.v23.segment.EVN;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.PD1;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADT_A45
extends AbstractMessage {
    public ADT_A45() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ADT_A45(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(ADT_A45_MERGE_INFO.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ADT_A45 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public ADT_A45_MERGE_INFO getMERGE_INFO() {
        return (ADT_A45_MERGE_INFO)this.getTyped("MERGE_INFO", ADT_A45_MERGE_INFO.class);
    }

    public ADT_A45_MERGE_INFO getMERGE_INFO(int rep) {
        return (ADT_A45_MERGE_INFO)this.getTyped("MERGE_INFO", rep, ADT_A45_MERGE_INFO.class);
    }

    public int getMERGE_INFOReps() {
        return this.getReps("MERGE_INFO");
    }

    public List<ADT_A45_MERGE_INFO> getMERGE_INFOAll() throws HL7Exception {
        return this.getAllAsList("MERGE_INFO", ADT_A45_MERGE_INFO.class);
    }

    public void insertMERGE_INFO(ADT_A45_MERGE_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("MERGE_INFO", (Structure)structure, rep);
    }

    public ADT_A45_MERGE_INFO insertMERGE_INFO(int rep) throws HL7Exception {
        return (ADT_A45_MERGE_INFO)super.insertRepetition("MERGE_INFO", rep);
    }

    public ADT_A45_MERGE_INFO removeMERGE_INFO(int rep) throws HL7Exception {
        return (ADT_A45_MERGE_INFO)super.removeRepetition("MERGE_INFO", rep);
    }
}

