/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String FILE_PATH_SEP = System.getProperty("file.separator");
    private static final Logger ourLog = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copyWhileDataAvailable(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (input.available() > 0 && -1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void deleteAllFromDirectory(File theWorkfilesDir) {
        File[] listFiles = theWorkfilesDir.listFiles();
        if (listFiles.length == 0) {
            return;
        }
        ourLog.info("Deleting {} files from {}", (Object)listFiles.length, (Object)theWorkfilesDir.getAbsoluteFile());
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File next = fileArray[n2];
            ourLog.info("Deleting existing file: " + next);
            next.delete();
            ++n2;
        }
    }

    public static void deleteAllFromDirectoryExcept(File theDirectory, List<File> theExcept) throws IOException {
        File[] listFiles = theDirectory.listFiles();
        if (listFiles.length == 0) {
            return;
        }
        ourLog.info("Deleting unneeded files from {}", (Object)theDirectory.getAbsoluteFile());
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File nextFile = fileArray[n2];
            boolean keep = false;
            for (File nextExcept : theExcept) {
                if (!nextFile.getCanonicalPath().equals(nextExcept.getCanonicalPath())) continue;
                keep = true;
                break;
            }
            if (!keep) {
                ourLog.info("Deleting existing file: " + nextFile);
                nextFile.delete();
            }
            ++n2;
        }
    }

    public static byte[] readClasspathIntoByteArray(String theString) throws IOException {
        InputStream res = IOUtils.class.getResourceAsStream(theString);
        return IOUtils.readInputStreamIntoByteArray(res);
    }

    public static byte[] readInputStreamIntoByteArraWhileDataAvailable(InputStream res) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copyWhileDataAvailable(res, bos);
        return bos.toByteArray();
    }

    public static byte[] readInputStreamIntoByteArray(InputStream res) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy(res, bos);
        return bos.toByteArray();
    }
}

