/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.sign;

import ca.uhn.hl7v2.hoh.sign.ISigner;
import ca.uhn.hl7v2.hoh.sign.SignatureFailureException;
import ca.uhn.hl7v2.hoh.sign.SignatureVerificationException;
import ca.uhn.hl7v2.hoh.util.StringUtils;
import ca.uhn.hl7v2.hoh.util.repackage.Base64;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignerDigestMismatchException;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BouncyCastleCmsMessageSigner
implements ISigner {
    static final String MSG_KEY_IS_NOT_A_PRIVATE_KEY = "Key is not a private key: ";
    static final String MSG_KEY_IS_NOT_A_PUBLIC_KEY = "Key is not a public key: ";
    static final String MSG_KEYSTORE_DOES_NOT_CONTAIN_KEY_WITH_ALIAS = "Keystore does not contain key with alias: ";
    private static final Logger ourLog = LoggerFactory.getLogger(BouncyCastleCmsMessageSigner.class);
    private String myAlgorithm = "SHA512withRSA";
    private String myAliasPassword;
    private String myKeyAlias;
    private KeyStore myKeyStore;
    private PrivateKey myPrivateKey;
    private PublicKey myPublicKey;

    private PrivateKey getPrivateKey() throws GeneralSecurityException, SignatureFailureException {
        if (this.myKeyStore == null) {
            throw new SignatureFailureException("Keystore is not set");
        }
        if (StringUtils.isBlank(this.myKeyAlias)) {
            throw new SignatureFailureException("Key alias is not set");
        }
        if (StringUtils.isBlank(this.myAliasPassword)) {
            throw new SignatureFailureException("Key alias password is not set");
        }
        if (this.myPrivateKey == null) {
            this.myPrivateKey = (PrivateKey)this.myKeyStore.getKey(this.myKeyAlias, this.myAliasPassword.toCharArray());
            if (this.myPrivateKey == null) {
                if (this.myKeyStore.containsAlias(this.myKeyAlias)) {
                    if (this.myKeyStore.isCertificateEntry(this.myKeyAlias)) {
                        throw new SignatureFailureException(MSG_KEY_IS_NOT_A_PRIVATE_KEY + this.myKeyAlias);
                    }
                } else {
                    throw new SignatureFailureException(MSG_KEYSTORE_DOES_NOT_CONTAIN_KEY_WITH_ALIAS + this.myKeyAlias);
                }
            }
        }
        return this.myPrivateKey;
    }

    private PublicKey getPublicKey() throws SignatureFailureException {
        block7: {
            if (this.myKeyStore == null) {
                throw new SignatureFailureException("Keystore is not set");
            }
            if (StringUtils.isBlank(this.myKeyAlias)) {
                throw new SignatureFailureException("Key alias is not set");
            }
            if (this.myPublicKey == null) {
                try {
                    Certificate pubCert = this.myKeyStore.getCertificate(this.myKeyAlias);
                    PublicKey publicKey = this.myPublicKey = pubCert != null ? pubCert.getPublicKey() : null;
                    if (this.myPublicKey != null) break block7;
                    if (this.myKeyStore.containsAlias(this.myKeyAlias)) {
                        if (this.myKeyStore.isKeyEntry(this.myKeyAlias)) {
                            throw new SignatureFailureException(MSG_KEY_IS_NOT_A_PUBLIC_KEY + this.myKeyAlias);
                        }
                        break block7;
                    }
                    throw new SignatureFailureException(MSG_KEYSTORE_DOES_NOT_CONTAIN_KEY_WITH_ALIAS + this.myKeyAlias);
                }
                catch (KeyStoreException e) {
                    throw new SignatureFailureException("Failed to retrieve key with alias " + this.myKeyAlias + " from keystore", e);
                }
            }
        }
        return this.myPublicKey;
    }

    public void setAliasPassword(String theAliasPassword) {
        this.myAliasPassword = theAliasPassword;
    }

    public void setKeyAlias(String theKeyAlias) {
        this.myKeyAlias = theKeyAlias;
    }

    public void setKeyStore(KeyStore theKeyStore) {
        if (theKeyStore == null) {
            throw new NullPointerException("Keystore can not be null");
        }
        this.myKeyStore = theKeyStore;
    }

    @Override
    public String sign(byte[] theBytes) throws SignatureFailureException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            CMSProcessableByteArray msg = new CMSProcessableByteArray(theBytes);
            X509Certificate signCert = (X509Certificate)this.myKeyStore.getCertificate(this.myKeyAlias);
            certList.add(signCert);
            JcaCertStore certs = new JcaCertStore(certList);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            ContentSigner sha1Signer = new JcaContentSignerBuilder(this.myAlgorithm).setProvider("BC").build(this.getPrivateKey());
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(sha1Signer, signCert));
            gen.addCertificates((Store)certs);
            CMSSignedData sigData = gen.generate((CMSTypedData)msg, false);
            return String.valueOf(this.myAlgorithm) + ' ' + Base64.encodeBase64String(sigData.getEncoded());
        }
        catch (Exception e) {
            throw new SignatureFailureException(e);
        }
    }

    @Override
    public void verify(byte[] theBytes, String theSignature) throws SignatureVerificationException, SignatureFailureException {
        PublicKey pubKey = this.getPublicKey();
        try {
            int spaceIndex = theSignature.indexOf(32);
            if (spaceIndex == -1) {
                throw new SignatureVerificationException("No algorithm found in signature block: " + theSignature);
            }
            theSignature = theSignature.substring(spaceIndex + 1);
            CMSProcessableByteArray content = new CMSProcessableByteArray(theBytes);
            CMSSignedData s = new CMSSignedData((CMSProcessable)content, Base64.decodeBase64(theSignature));
            ourLog.debug("Verifying message against public key with alias[{}]", (Object)this.myKeyAlias);
            SignerInformationVerifier vib = new JcaSimpleSignerInfoVerifierBuilder().build(pubKey);
            SignerInformationStore signers = s.getSignerInfos();
            boolean verified = false;
            for (SignerInformation signer : signers.getSigners()) {
                try {
                    ourLog.debug("Signer: {}", (Object)signer.getSID());
                    if (!signer.verify(vib)) continue;
                    verified = true;
                }
                catch (CMSSignerDigestMismatchException e) {
                    throw new SignatureVerificationException((Exception)((Object)e));
                }
            }
            if (!verified) {
                throw new SignatureVerificationException();
            }
        }
        catch (SignatureVerificationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SignatureFailureException(e);
        }
    }
}

