/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import ca.uhn.hl7v2.hoh.encoder.AbstractHl7OverHttpEncoder;
import ca.uhn.hl7v2.hoh.util.StringUtils;
import ca.uhn.hl7v2.hoh.util.VersionLogger;
import ca.uhn.hl7v2.hoh.util.repackage.Base64;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hl7OverHttpRequestEncoder
extends AbstractHl7OverHttpEncoder {
    private static final Logger ourLog = LoggerFactory.getLogger(Hl7OverHttpRequestEncoder.class);
    private String myHost;
    private int myPort;
    private boolean myAcceptGzip = false;

    public void setHost(String theHost) {
        this.myHost = theHost;
    }

    public void setPort(int thePort) {
        this.myPort = thePort;
    }

    @Override
    protected void addSpecificHeaders() {
        if (StringUtils.isNotBlank(this.getUsername()) && StringUtils.isNotBlank(this.getPassword())) {
            String encoded;
            String authorizationUnescaped = String.valueOf(StringUtils.defaultString(this.getUsername())) + ":" + StringUtils.defaultString(this.getPassword());
            try {
                encoded = Base64.encodeBase64String(authorizationUnescaped.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Could not find US-ASCII encoding. This shouldn't happen!");
            }
            this.getHeaders().put("Authorization", "Basic " + encoded);
        }
        if (this.myAcceptGzip) {
            this.getHeaders().put("Accept-Encoding", "gzip");
        }
        this.getHeaders().put("User-Agent", "HAPI (HL7 over HTTP) Client " + VersionLogger.getVersion());
        StringBuilder hostBuilder = new StringBuilder();
        if (StringUtils.isNotBlank(this.myHost)) {
            hostBuilder.append(this.myHost);
            if (this.myPort > 0) {
                hostBuilder.append(":");
                hostBuilder.append(this.myPort);
            } else {
                ourLog.warn("Host has been set, but port has not");
            }
        } else {
            ourLog.warn("Host has not been set");
        }
        this.getHeaders().put("Host", hostBuilder.toString());
    }

    @Override
    protected void setActionLineAppropriately() {
        this.setActionLine("POST " + this.getPath() + " HTTP/1.1");
    }
}

