/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.BaseRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IRuleApplier;
import java.util.HashSet;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

class OperationRule
extends BaseRule
implements IAuthRule {
    private String myOperationName;
    private boolean myAppliesToServer;
    private HashSet<Class<? extends IBaseResource>> myAppliesToTypes;
    private List<IIdType> myAppliesToIds;
    private HashSet<Class<? extends IBaseResource>> myAppliesToInstancesOfType;

    public OperationRule(String theRuleName) {
        super(theRuleName);
    }

    public void setOperationName(String theOperationName) {
        this.myOperationName = theOperationName;
    }

    public String getOperationName() {
        return this.myOperationName;
    }

    @Override
    public AuthorizationInterceptor.Verdict applyRule(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IBaseResource theInputResource, IIdType theInputResourceId, IBaseResource theOutputResource, IRuleApplier theRuleApplier) {
        FhirContext ctx = theRequestDetails.getServer().getFhirContext();
        boolean applies = false;
        block0 : switch (theOperation) {
            case EXTENDED_OPERATION_SERVER: {
                if (!this.myAppliesToServer) break;
                applies = true;
                break;
            }
            case EXTENDED_OPERATION_TYPE: {
                if (this.myAppliesToTypes == null) break;
                for (Class<? extends IBaseResource> next : this.myAppliesToTypes) {
                    String resName = ctx.getResourceDefinition(next).getName();
                    if (!resName.equals(theRequestDetails.getResourceName())) continue;
                    applies = true;
                    break block0;
                }
                break;
            }
            case EXTENDED_OPERATION_INSTANCE: {
                if (theInputResourceId == null) break;
                if (this.myAppliesToIds != null) {
                    String instanceId = theInputResourceId.toUnqualifiedVersionless().getValue();
                    for (IIdType next : this.myAppliesToIds) {
                        if (!next.toUnqualifiedVersionless().getValue().equals(instanceId)) continue;
                        applies = true;
                        break;
                    }
                }
                if (this.myAppliesToInstancesOfType == null) break;
                for (Class<? extends IBaseResource> next : this.myAppliesToInstancesOfType) {
                    String resName = ctx.getResourceDefinition(next).getName();
                    if (!resName.equals(theInputResourceId.getResourceType())) continue;
                    applies = true;
                    break block0;
                }
                break;
            }
            default: {
                return null;
            }
        }
        if (!applies) {
            return null;
        }
        if (this.myOperationName != null && !this.myOperationName.equals(theRequestDetails.getOperation())) {
            return null;
        }
        return this.newVerdict();
    }

    public void appliesToServer() {
        this.myAppliesToServer = true;
    }

    public void appliesToTypes(HashSet<Class<? extends IBaseResource>> theAppliesToTypes) {
        this.myAppliesToTypes = theAppliesToTypes;
    }

    public void appliesToInstances(List<IIdType> theAppliesToIds) {
        this.myAppliesToIds = theAppliesToIds;
    }

    public void appliesToInstancesOfType(HashSet<Class<? extends IBaseResource>> theAppliesToTypes) {
        this.myAppliesToInstancesOfType = theAppliesToTypes;
    }
}

