/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.Constants;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHighlighterInterceptor
extends InterceptorAdapter {
    private static final Logger ourLog = LoggerFactory.getLogger(ResponseHighlighterInterceptor.class);
    private static final String[] PARAM_FORMAT_VALUE_JSON = new String[]{"json"};
    private static final String[] PARAM_FORMAT_VALUE_XML = new String[]{"xml"};
    public static final String PARAM_RAW = "_raw";
    public static final String PARAM_RAW_TRUE = "true";
    public static final String PARAM_TRUE = "true";

    private String format(String theResultBody, EncodingEnum theEncodingEnum) {
        String str = StringEscapeUtils.escapeHtml4((String)theResultBody);
        if (str == null || theEncodingEnum == null) {
            return str;
        }
        StringBuilder b = new StringBuilder();
        if (theEncodingEnum == EncodingEnum.JSON) {
            boolean inValue = false;
            boolean inQuote = false;
            for (int i = 0; i < str.length(); ++i) {
                int nextChar6;
                int prevChar = i > 0 ? (int)str.charAt(i - 1) : 32;
                char nextChar = str.charAt(i);
                int nextChar2 = i + 1 < str.length() ? (int)str.charAt(i + 1) : 32;
                int nextChar3 = i + 2 < str.length() ? (int)str.charAt(i + 2) : 32;
                int nextChar4 = i + 3 < str.length() ? (int)str.charAt(i + 3) : 32;
                int nextChar5 = i + 4 < str.length() ? (int)str.charAt(i + 4) : 32;
                int n = nextChar6 = i + 5 < str.length() ? (int)str.charAt(i + 5) : 32;
                if (inQuote) {
                    b.append(nextChar);
                    if (prevChar != 92 && nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                        b.append("quot;</span>");
                        i += 5;
                        inQuote = false;
                        continue;
                    }
                    if (nextChar != '\\' || nextChar2 != 34) continue;
                    b.append("quot;</span>");
                    i += 5;
                    inQuote = false;
                    continue;
                }
                if (nextChar == ':') {
                    inValue = true;
                    b.append(nextChar);
                    continue;
                }
                if (nextChar == '[' || nextChar == '{') {
                    b.append("<span class='hlControl'>");
                    b.append(nextChar);
                    b.append("</span>");
                    inValue = false;
                    continue;
                }
                if (nextChar == '}' || nextChar == '}' || nextChar == ',') {
                    b.append("<span class='hlControl'>");
                    b.append(nextChar);
                    b.append("</span>");
                    inValue = false;
                    continue;
                }
                if (nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                    if (inValue) {
                        b.append("<span class='hlQuot'>&quot;");
                    } else {
                        b.append("<span class='hlTagName'>&quot;");
                    }
                    inQuote = true;
                    i += 5;
                    continue;
                }
                if (nextChar == ':') {
                    b.append("<span class='hlControl'>");
                    b.append(nextChar);
                    b.append("</span>");
                    inValue = true;
                    continue;
                }
                b.append(nextChar);
            }
        } else {
            boolean inQuote = false;
            boolean inTag = false;
            for (int i = 0; i < str.length(); ++i) {
                int nextChar6;
                char nextChar = str.charAt(i);
                int nextChar2 = i + 1 < str.length() ? (int)str.charAt(i + 1) : 32;
                int nextChar3 = i + 2 < str.length() ? (int)str.charAt(i + 2) : 32;
                int nextChar4 = i + 3 < str.length() ? (int)str.charAt(i + 3) : 32;
                int nextChar5 = i + 4 < str.length() ? (int)str.charAt(i + 4) : 32;
                int n = nextChar6 = i + 5 < str.length() ? (int)str.charAt(i + 5) : 32;
                if (inQuote) {
                    b.append(nextChar);
                    if (nextChar != '&' || nextChar2 != 113 || nextChar3 != 117 || nextChar4 != 111 || nextChar5 != 116 || nextChar6 != 59) continue;
                    b.append("quot;</span>");
                    i += 5;
                    inQuote = false;
                    continue;
                }
                if (inTag) {
                    if (nextChar == '&' && nextChar2 == 103 && nextChar3 == 116 && nextChar4 == 59) {
                        b.append("</span><span class='hlControl'>&gt;</span>");
                        inTag = false;
                        i += 3;
                        continue;
                    }
                    if (nextChar == ' ') {
                        b.append("</span><span class='hlAttr'>");
                        b.append(nextChar);
                        continue;
                    }
                    if (nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                        b.append("<span class='hlQuot'>&quot;");
                        inQuote = true;
                        i += 5;
                        continue;
                    }
                    b.append(nextChar);
                    continue;
                }
                if (nextChar == '&' && nextChar2 == 108 && nextChar3 == 116 && nextChar4 == 59) {
                    b.append("<span class='hlControl'>&lt;</span><span class='hlTagName'>");
                    inTag = true;
                    i += 3;
                    continue;
                }
                b.append(nextChar);
            }
        }
        return b.toString();
    }

    @Override
    public boolean handleException(RequestDetails theRequestDetails, BaseServerResponseException theException, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws ServletException, IOException {
        Set<String> accept = RestfulServerUtils.parseAcceptHeaderAndReturnHighestRankedOptions(theServletRequest);
        if (!accept.contains("text/html")) {
            return super.handleException(theRequestDetails, theException, theServletRequest, theServletResponse);
        }
        String requestedWith = theServletRequest.getHeader("X-Requested-With");
        if (requestedWith != null) {
            return super.handleException(theRequestDetails, theException, theServletRequest, theServletResponse);
        }
        if (theRequestDetails.getRequestType() != RequestTypeEnum.GET) {
            return super.handleException(theRequestDetails, theException, theServletRequest, theServletResponse);
        }
        if (theException.getOperationOutcome() == null) {
            return super.handleException(theRequestDetails, theException, theServletRequest, theServletResponse);
        }
        this.streamResponse(theRequestDetails, theServletResponse, theException.getOperationOutcome(), (ServletRequest)theServletRequest);
        return false;
    }

    @Override
    public boolean outgoingResponse(RequestDetails theRequestDetails, IBaseResource theResponseObject, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws AuthenticationException {
        String[] rawParamValues = theRequestDetails.getParameters().get(PARAM_RAW);
        if (rawParamValues != null && rawParamValues.length > 0 && rawParamValues[0].equals("true")) {
            ourLog.warn("Client is using non-standard/legacy  _raw parameter - Use _format=json or _format=xml instead, as this parmameter will be removed at some point");
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        boolean force = false;
        String[] formatParams = theRequestDetails.getParameters().get("_format");
        if (formatParams != null && formatParams.length > 0) {
            String formatParam = formatParams[0];
            if (Constants.FORMATS_HTML.contains(formatParam)) {
                force = true;
            } else if ("html/xml".equals(formatParam)) {
                force = true;
                theRequestDetails.getParameters().put("_format", PARAM_FORMAT_VALUE_XML);
            } else if ("html/json".equals(formatParam)) {
                force = true;
                theRequestDetails.getParameters().put("_format", PARAM_FORMAT_VALUE_JSON);
            } else {
                return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
            }
        }
        Set<String> highestRankedAcceptValues = RestfulServerUtils.parseAcceptHeaderAndReturnHighestRankedOptions(theServletRequest);
        if (!force && !highestRankedAcceptValues.contains("text/html")) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        if (!force && StringUtils.isNotBlank((CharSequence)theServletRequest.getHeader("X-Requested-With"))) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        if (!force && StringUtils.isNotBlank((CharSequence)theServletRequest.getHeader("Origin"))) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        if (!force && theRequestDetails.getRequestType() != RequestTypeEnum.GET) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        if (!force && "Binary".equals(theRequestDetails.getResourceName())) {
            return super.outgoingResponse(theRequestDetails, theResponseObject, theServletRequest, theServletResponse);
        }
        this.streamResponse(theRequestDetails, theServletResponse, theResponseObject, (ServletRequest)theServletRequest);
        return false;
    }

    private void streamResponse(RequestDetails theRequestDetails, HttpServletResponse theServletResponse, IBaseResource resource, ServletRequest theServletRequest) {
        IParser p;
        Map<String, String[]> parameters = theRequestDetails.getParameters();
        if (parameters.containsKey("_format")) {
            p = RestfulServerUtils.getNewParser(theRequestDetails.getServer().getFhirContext(), theRequestDetails);
        } else {
            EncodingEnum defaultResponseEncoding = theRequestDetails.getServer().getDefaultResponseEncoding();
            p = defaultResponseEncoding.newParser(theRequestDetails.getServer().getFhirContext());
            RestfulServerUtils.configureResponseParser(theRequestDetails, p);
        }
        boolean prettyPrintResponse = true;
        String[] prettyParams = parameters.get("_pretty");
        if (prettyParams != null && prettyParams.length > 0 && "false".equals(prettyParams[0])) {
            prettyPrintResponse = false;
        }
        if (prettyPrintResponse) {
            p.setPrettyPrint(prettyPrintResponse);
        }
        EncodingEnum encoding = p.getEncoding();
        String encoded = p.encodeResourceToString(resource);
        theServletResponse.setContentType("text/html; charset=UTF-8");
        StringBuilder b = new StringBuilder();
        b.append("<html lang=\"en\">\n");
        b.append("\t<head>\n");
        b.append("\t\t<meta charset=\"utf-8\" />\n");
        b.append("       <style>\n");
        b.append(".hlQuot {\n");
        b.append("  color: #88F;\n");
        b.append("}\n");
        b.append(".hlAttr {\n");
        b.append("  color: #888;\n");
        b.append("}\n");
        b.append(".hlTagName {\n");
        b.append("  color: #006699;\n");
        b.append("}\n");
        b.append(".hlControl {\n");
        b.append("  color: #660000;\n");
        b.append("}\n");
        b.append(".hlText {\n");
        b.append("  color: #000000;\n");
        b.append("}\n");
        b.append(".hlUrlBase {\n");
        b.append("}");
        b.append(".headersDiv {\n");
        b.append("  background: #EEE;");
        b.append("}");
        b.append(".headerName {\n");
        b.append("  color: #888;\n");
        b.append("  font-family: monospace;\n");
        b.append("}");
        b.append(".headerValue {\n");
        b.append("  color: #88F;\n");
        b.append("  font-family: monospace;\n");
        b.append("}");
        b.append("BODY {\n");
        b.append("  font-family: Arial;\n");
        b.append("}");
        b.append("       </style>\n");
        b.append("\t</head>\n");
        b.append("\n");
        b.append("\t<body>");
        b.append("<p>");
        b.append("This result is being rendered in HTML for easy viewing. ");
        b.append("You may access this content as ");
        b.append("<a href=\"");
        b.append(this.createLinkHref(parameters, "json"));
        b.append("\">Raw JSON</a> or ");
        b.append("<a href=\"");
        b.append(this.createLinkHref(parameters, "xml"));
        b.append("\">Raw XML</a>, ");
        b.append(" or view this content in ");
        b.append("<a href=\"");
        b.append(this.createLinkHref(parameters, "html/json"));
        b.append("\">HTML JSON</a> ");
        b.append("or ");
        b.append("<a href=\"");
        b.append(this.createLinkHref(parameters, "html/xml"));
        b.append("\">HTML XML</a>.");
        Date startTime = (Date)theServletRequest.getAttribute(RestfulServer.REQUEST_START_TIME);
        if (startTime != null) {
            long time = System.currentTimeMillis() - startTime.getTime();
            b.append(" Response generated in ");
            b.append(time);
            b.append("ms.");
        }
        b.append("</p>");
        b.append("\n");
        b.append("<pre>");
        b.append(this.format(encoded, encoding));
        b.append("</pre>");
        b.append("   </body>");
        b.append("</html>");
        String out = b.toString();
        try {
            theServletResponse.getWriter().append(out);
            theServletResponse.getWriter().close();
        }
        catch (IOException e) {
            throw new InternalErrorException(e);
        }
    }

    private String createLinkHref(Map<String, String[]> parameters, String formatValue) {
        StringBuilder rawB = new StringBuilder();
        for (String next : parameters.keySet()) {
            if ("_format".equals(next)) continue;
            for (String nextValue : parameters.get(next)) {
                if (StringUtils.isBlank((CharSequence)nextValue)) continue;
                if (rawB.length() == 0) {
                    rawB.append('?');
                } else {
                    rawB.append('&');
                }
                rawB.append(UrlUtil.escape(next));
                rawB.append('=');
                rawB.append(UrlUtil.escape(nextValue));
            }
        }
        if (rawB.length() == 0) {
            rawB.append('?');
        } else {
            rawB.append('&');
        }
        rawB.append("_format").append('=').append(formatValue);
        String link = rawB.toString();
        return link;
    }
}

