/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.param.ResourceParameter;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.interceptor.BaseValidatingInterceptor;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.ValidationResult;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidatingInterceptor
extends BaseValidatingInterceptor<String> {
    public static final String DEFAULT_RESPONSE_HEADER_NAME = "X-FHIR-Request-Validation";
    private static final Logger ourLog = LoggerFactory.getLogger(RequestValidatingInterceptor.class);

    @Override
    public boolean incomingRequestPostProcessed(RequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        EncodingEnum encoding = RestfulServerUtils.determineRequestEncodingNoDefault(theRequestDetails);
        if (encoding == null) {
            ourLog.trace("Incoming request does not appear to be FHIR, not going to validate");
            return true;
        }
        Charset charset = ResourceParameter.determineRequestCharset(theRequestDetails);
        String requestText = new String(theRequestDetails.loadRequestContents(), charset);
        if (StringUtils.isBlank((CharSequence)requestText)) {
            ourLog.trace("Incoming request does not have a body");
            return true;
        }
        this.validate(requestText, theRequestDetails);
        return true;
    }

    @Override
    public void setResponseHeaderName(String theResponseHeaderName) {
        super.setResponseHeaderName(theResponseHeaderName);
    }

    @Override
    String provideDefaultResponseHeaderName() {
        return DEFAULT_RESPONSE_HEADER_NAME;
    }

    @Override
    ValidationResult doValidate(FhirValidator theValidator, String theRequest) {
        return theValidator.validateWithResult(theRequest);
    }
}

