/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.Constants;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor
extends InterceptorAdapter {
    private static final Logger ourLog = LoggerFactory.getLogger(LoggingInterceptor.class);
    private String myErrorMessageFormat = "ERROR - ${operationType} - ${idOrResourceName}";
    private boolean myLogExceptions = true;
    private Logger myLogger = ourLog;
    private String myMessageFormat = "${operationType} - ${idOrResourceName}";

    public String getErrorMessageFormat() {
        return this.myErrorMessageFormat;
    }

    @Override
    public boolean handleException(RequestDetails theRequestDetails, BaseServerResponseException theException, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws ServletException, IOException {
        if (this.myLogExceptions) {
            MyLookup lookup = new MyLookup(theServletRequest, theException, theRequestDetails);
            StrSubstitutor subs = new StrSubstitutor((StrLookup)lookup, "${", "}", '\\');
            String line = subs.replace(this.myErrorMessageFormat);
            this.myLogger.info(line);
        }
        return true;
    }

    @Override
    public void processingCompletedNormally(ServletRequestDetails theRequestDetails) {
        MyLookup lookup = new MyLookup(theRequestDetails.getServletRequest(), theRequestDetails);
        StrSubstitutor subs = new StrSubstitutor((StrLookup)lookup, "${", "}", '\\');
        String line = subs.replace(this.myMessageFormat);
        this.myLogger.info(line);
    }

    public boolean isLogExceptions() {
        return this.myLogExceptions;
    }

    public void setErrorMessageFormat(String theErrorMessageFormat) {
        Validate.notBlank((CharSequence)theErrorMessageFormat, (String)"Message format can not be null/empty", (Object[])new Object[0]);
        this.myErrorMessageFormat = theErrorMessageFormat;
    }

    public void setLogExceptions(boolean theLogExceptions) {
        this.myLogExceptions = theLogExceptions;
    }

    public void setLogger(Logger theLogger) {
        Validate.notNull((Object)theLogger, (String)"Logger can not be null", (Object[])new Object[0]);
        this.myLogger = theLogger;
    }

    public void setLoggerName(String theLoggerName) {
        Validate.notBlank((CharSequence)theLoggerName, (String)"Logger name can not be null/empty", (Object[])new Object[0]);
        this.myLogger = LoggerFactory.getLogger((String)theLoggerName);
    }

    public void setMessageFormat(String theMessageFormat) {
        Validate.notBlank((CharSequence)theMessageFormat, (String)"Message format can not be null/empty", (Object[])new Object[0]);
        this.myMessageFormat = theMessageFormat;
    }

    private static final class MyLookup
    extends StrLookup<String> {
        private final Throwable myException;
        private final HttpServletRequest myRequest;
        private final RequestDetails myRequestDetails;

        private MyLookup(HttpServletRequest theRequest, RequestDetails theRequestDetails) {
            this.myRequest = theRequest;
            this.myRequestDetails = theRequestDetails;
            this.myException = null;
        }

        public MyLookup(HttpServletRequest theServletRequest, BaseServerResponseException theException, RequestDetails theRequestDetails) {
            this.myException = theException;
            this.myRequestDetails = theRequestDetails;
            this.myRequest = theServletRequest;
        }

        public String lookup(String theKey) {
            Date startTime;
            if ("operationType".equals(theKey)) {
                if (this.myRequestDetails.getRestOperationType() != null) {
                    return this.myRequestDetails.getRestOperationType().getCode();
                }
                return "";
            }
            if ("operationName".equals(theKey)) {
                if (this.myRequestDetails.getRestOperationType() != null) {
                    switch (this.myRequestDetails.getRestOperationType()) {
                        case EXTENDED_OPERATION_INSTANCE: 
                        case EXTENDED_OPERATION_SERVER: 
                        case EXTENDED_OPERATION_TYPE: {
                            return this.myRequestDetails.getOperation();
                        }
                    }
                    return "";
                }
                return "";
            }
            if ("id".equals(theKey)) {
                if (this.myRequestDetails.getId() != null) {
                    return this.myRequestDetails.getId().getValue();
                }
                return "";
            }
            if ("servletPath".equals(theKey)) {
                return StringUtils.defaultString((String)this.myRequest.getServletPath());
            }
            if ("idOrResourceName".equals(theKey)) {
                if (this.myRequestDetails.getId() != null) {
                    return this.myRequestDetails.getId().getValue();
                }
                if (this.myRequestDetails.getResourceName() != null) {
                    return this.myRequestDetails.getResourceName();
                }
                return "";
            }
            if (theKey.equals("requestParameters")) {
                StringBuilder b = new StringBuilder();
                for (Map.Entry<String, String[]> next : this.myRequestDetails.getParameters().entrySet()) {
                    for (String nextValue : next.getValue()) {
                        if (b.length() == 0) {
                            b.append('?');
                        } else {
                            b.append('&');
                        }
                        try {
                            b.append(URLEncoder.encode(next.getKey(), "UTF-8"));
                            b.append('=');
                            b.append(URLEncoder.encode(nextValue, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new ConfigurationException("UTF-8 not supported", e);
                        }
                    }
                }
                return b.toString();
            }
            if (theKey.startsWith("requestHeader.")) {
                String val = this.myRequest.getHeader(theKey.substring("requestHeader.".length()));
                return StringUtils.defaultString((String)val);
            }
            if (theKey.startsWith("remoteAddr")) {
                return StringUtils.defaultString((String)this.myRequest.getRemoteAddr());
            }
            if (theKey.equals("responseEncodingNoDefault")) {
                RestfulServerUtils.ResponseEncoding encoding = RestfulServerUtils.determineResponseEncodingNoDefault(this.myRequestDetails, this.myRequestDetails.getServer().getDefaultResponseEncoding());
                if (encoding != null) {
                    return encoding.getEncoding().name();
                }
                return "";
            }
            if (theKey.equals("exceptionMessage")) {
                return this.myException != null ? this.myException.getMessage() : null;
            }
            if (theKey.equals("requestUrl")) {
                return this.myRequest.getRequestURL().toString();
            }
            if (theKey.equals("requestVerb")) {
                return this.myRequest.getMethod();
            }
            if (theKey.equals("requestBodyFhir")) {
                String contentType = this.myRequest.getContentType();
                if (StringUtils.isNotBlank((CharSequence)contentType)) {
                    EncodingEnum encoding;
                    int colonIndex = contentType.indexOf(59);
                    if (colonIndex != -1) {
                        contentType = contentType.substring(0, colonIndex);
                    }
                    if ((encoding = EncodingEnum.forContentType(contentType = contentType.trim())) != null) {
                        byte[] requestContents = this.myRequestDetails.loadRequestContents();
                        return new String(requestContents, Constants.CHARSET_UTF8);
                    }
                }
                return "";
            }
            if ("processingTimeMillis".equals(theKey) && (startTime = (Date)this.myRequest.getAttribute(RestfulServer.REQUEST_START_TIME)) != null) {
                long time = System.currentTimeMillis() - startTime.getTime();
                return Long.toString(time);
            }
            return "!VAL!";
        }
    }
}

