/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import org.apache.commons.lang3.StringUtils;

public class HasParam
extends BaseParam
implements IQueryParameterType {
    private String myOwningFieldName;
    private String myParameterName;
    private String myParameterValue;
    private String myTargetResourceType;

    public HasParam() {
    }

    public HasParam(String theTargetResourceType, String theOwningFieldName, String theParameterName, String theParameterValue) {
        this();
        this.myTargetResourceType = theTargetResourceType;
        this.myOwningFieldName = theOwningFieldName;
        this.myParameterName = theParameterName;
        this.myParameterValue = theParameterValue;
    }

    @Override
    String doGetQueryParameterQualifier() {
        return this.myTargetResourceType + ':' + this.myParameterName + ':' + this.myParameterValue;
    }

    @Override
    String doGetValueAsQueryToken(FhirContext theContext) {
        return this.myParameterValue;
    }

    @Override
    void doSetValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        String qualifier = StringUtils.defaultString((String)theQualifier);
        if (!qualifier.startsWith(":")) {
            HasParam.throwInvalidSyntaxException("_has" + qualifier);
        }
        int colonIndex0 = qualifier.indexOf(58, 1);
        HasParam.validateColon(qualifier, colonIndex0);
        int colonIndex1 = qualifier.indexOf(58, colonIndex0 + 1);
        HasParam.validateColon(qualifier, colonIndex1);
        this.myTargetResourceType = qualifier.substring(1, colonIndex0);
        this.myOwningFieldName = qualifier.substring(colonIndex0 + 1, colonIndex1);
        this.myParameterName = qualifier.substring(colonIndex1 + 1);
        this.myParameterValue = theValue;
    }

    public String getOwningFieldName() {
        return this.myOwningFieldName;
    }

    public String getParameterName() {
        return this.myParameterName;
    }

    public String getParameterValue() {
        return this.myParameterValue;
    }

    public String getTargetResourceType() {
        return this.myTargetResourceType;
    }

    private static void validateColon(String theParameterName, int colonIndex) {
        if (colonIndex == -1) {
            HasParam.throwInvalidSyntaxException(theParameterName);
        }
    }

    private static void throwInvalidSyntaxException(String theParameterName) {
        throw new InvalidRequestException("Invalid _has parameter syntax: " + theParameterName);
    }
}

