/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.server.EncodingEnum;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IIdType;

public class HttpPatchClientInvocation
extends BaseHttpClientInvocation {
    private String myUrlPath;
    private Map<String, List<String>> myParams;
    private String myContents;
    private String myContentType;

    public HttpPatchClientInvocation(FhirContext theContext, IIdType theId, String theContentType, String theContents) {
        super(theContext);
        this.myUrlPath = theId.toUnqualifiedVersionless().getValue();
        this.myContentType = theContentType;
        this.myContents = theContents;
    }

    public HttpPatchClientInvocation(FhirContext theContext, String theUrlPath, String theContentType, String theContents) {
        super(theContext);
        this.myUrlPath = theUrlPath;
        this.myContentType = theContentType;
        this.myContents = theContents;
    }

    @Override
    public IHttpRequest asHttpRequest(String theUrlBase, Map<String, List<String>> theExtraParams, EncodingEnum theEncoding, Boolean thePrettyPrint) {
        StringBuilder b = new StringBuilder();
        b.append(theUrlBase);
        if (!theUrlBase.endsWith("/")) {
            b.append('/');
        }
        b.append(this.myUrlPath);
        HttpPatchClientInvocation.appendExtraParamsWithQuestionMark(this.myParams, b, b.indexOf("?") == -1);
        HttpPatchClientInvocation.appendExtraParamsWithQuestionMark(theExtraParams, b, b.indexOf("?") == -1);
        return this.createHttpRequest(b.toString(), theEncoding, RequestTypeEnum.PATCH);
    }

    @Override
    protected IHttpRequest createHttpRequest(String theUrl, EncodingEnum theEncoding, RequestTypeEnum theRequestType) {
        IHttpClient httpClient = this.getRestfulClientFactory().getHttpClient(new StringBuilder(theUrl), null, null, theRequestType, this.getHeaders());
        return httpClient.createByteRequest(this.getContext(), this.myContents, this.myContentType, null);
    }
}

