/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.method.IParameter;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IDynamicSearchResourceProvider;
import ca.uhn.fhir.rest.server.IRestfulServer;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSearchMethodBinding
extends BaseResourceReturningMethodBinding {
    private IDynamicSearchResourceProvider myProvider;
    private List<RuntimeSearchParam> mySearchParameters;
    private HashSet<String> myParamNames;
    private Integer myIdParamIndex;
    private static final Logger ourLog = LoggerFactory.getLogger(DynamicSearchMethodBinding.class);

    public DynamicSearchMethodBinding(Class<? extends IBaseResource> theReturnResourceType, Method theMethod, FhirContext theContext, IDynamicSearchResourceProvider theProvider) {
        super(theReturnResourceType, theMethod, theContext, theProvider);
        this.myProvider = theProvider;
        this.mySearchParameters = this.myProvider.getSearchParameters();
        this.myParamNames = new HashSet();
        for (RuntimeSearchParam next : this.mySearchParameters) {
            this.myParamNames.add(next.getName());
        }
        this.myIdParamIndex = MethodUtil.findIdParameterIndex(theMethod, this.getContext());
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return BundleTypeEnum.SEARCHSET;
    }

    @Override
    public List<IParameter> getParameters() {
        ArrayList<IParameter> retVal = new ArrayList<IParameter>(super.getParameters());
        for (RuntimeSearchParam runtimeSearchParam : this.mySearchParameters) {
        }
        return retVal;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE;
    }

    public IBundleProvider invokeServer(IRestfulServer theServer, RequestDetails theRequest, Object[] theMethodParams) throws InvalidRequestException, InternalErrorException {
        if (this.myIdParamIndex != null) {
            theMethodParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        Object response = this.invokeServerMethod(theServer, theRequest, theMethodParams);
        return this.toResourceList(response);
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.SEARCH_TYPE;
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        if (!theRequest.getResourceName().equals(this.getResourceName())) {
            ourLog.trace("Method {} doesn't match because resource name {} != {}", new Object[]{this.getMethod().getName(), theRequest.getResourceName(), this.getResourceName()});
            return false;
        }
        if (theRequest.getId() != null && this.myIdParamIndex == null) {
            ourLog.trace("Method {} doesn't match because ID is not null: {}", (Object)theRequest.getId());
            return false;
        }
        if (theRequest.getRequestType() == RequestTypeEnum.GET && theRequest.getOperation() != null && !"_search".equals(theRequest.getOperation())) {
            ourLog.trace("Method {} doesn't match because request type is GET but operation is not null: {}", (Object)theRequest.getId(), (Object)theRequest.getOperation());
            return false;
        }
        if (theRequest.getRequestType() == RequestTypeEnum.POST && !"_search".equals(theRequest.getOperation())) {
            ourLog.trace("Method {} doesn't match because request type is POST but operation is not _search: {}", (Object)theRequest.getId(), (Object)theRequest.getOperation());
            return false;
        }
        if (theRequest.getRequestType() != RequestTypeEnum.GET && theRequest.getRequestType() != RequestTypeEnum.POST) {
            ourLog.trace("Method {} doesn't match because request type is {}", (Object)this.getMethod());
            return false;
        }
        if (theRequest.getCompartmentName() != null) {
            ourLog.trace("Method {} doesn't match because it is for compartment {}", new Object[]{this.getMethod(), theRequest.getCompartmentName()});
            return false;
        }
        for (String next : theRequest.getParameters().keySet()) {
            if (next.charAt(0) == '_') continue;
            String nextQualified = next;
            int colonIndex = next.indexOf(58);
            int dotIndex = next.indexOf(46);
            if (colonIndex != -1 || dotIndex != -1) {
                int index = colonIndex != -1 && dotIndex != -1 ? Math.min(colonIndex, dotIndex) : (colonIndex != -1 ? colonIndex : dotIndex);
                next = next.substring(0, index);
            }
            if (this.myParamNames.contains(next)) continue;
            ourLog.trace("Method {} doesn't match because has parameter {}", new Object[]{this.getMethod(), nextQualified});
            return false;
        }
        return true;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        throw new UnsupportedOperationException("Dynamic search methods are only used for server implementations");
    }

    public Collection<? extends RuntimeSearchParam> getSearchParams() {
        return this.mySearchParameters;
    }
}

