/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.MethodUtil;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IRestfulResponse;
import ca.uhn.fhir.rest.server.IRestfulServer;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseOutcomeReturningMethodBinding
extends BaseMethodBinding<MethodOutcome> {
    static final Logger ourLog = LoggerFactory.getLogger(BaseOutcomeReturningMethodBinding.class);
    private static EnumSet<RestOperationTypeEnum> ourOperationsWhichAllowPreferHeader = EnumSet.of(RestOperationTypeEnum.CREATE, RestOperationTypeEnum.UPDATE);
    private boolean myReturnVoid;

    public BaseOutcomeReturningMethodBinding(Method theMethod, FhirContext theContext, Class<?> theMethodAnnotation, Object theProvider) {
        super(theMethod, theContext, theProvider);
        if (!theMethod.getReturnType().equals(MethodOutcome.class)) {
            if (!this.allowVoidReturnType()) {
                throw new ConfigurationException("Method " + theMethod.getName() + " in type " + theMethod.getDeclaringClass().getCanonicalName() + " is a @" + theMethodAnnotation.getSimpleName() + " method but it does not return " + MethodOutcome.class);
            }
            if (theMethod.getReturnType() == Void.TYPE) {
                this.myReturnVoid = true;
            }
        }
    }

    protected abstract void addParametersForServerRequest(RequestDetails var1, Object[] var2);

    protected boolean allowVoidReturnType() {
        return false;
    }

    protected abstract BaseHttpClientInvocation createClientInvocation(Object[] var1, IResource var2);

    protected abstract String getMatchingOperation();

    private int getOperationStatus(MethodOutcome response) {
        switch (this.getRestOperationType()) {
            case CREATE: {
                if (response == null) {
                    throw new InternalErrorException("Method " + this.getMethod().getName() + " in type " + this.getMethod().getDeclaringClass().getCanonicalName() + " returned null, which is not allowed for create operation");
                }
                if (response.getCreated() == null || Boolean.TRUE.equals(response.getCreated())) {
                    return 201;
                }
                return 200;
            }
            case UPDATE: {
                if (response == null || response.getCreated() == null || Boolean.FALSE.equals(response.getCreated())) {
                    return 200;
                }
                return 201;
            }
        }
        if (response == null) {
            if (!this.isReturnVoid()) {
                throw new InternalErrorException("Method " + this.getMethod().getName() + " in type " + this.getMethod().getDeclaringClass().getCanonicalName() + " returned null");
            }
            return 204;
        }
        if (response.getOperationOutcome() == null) {
            return 204;
        }
        return 200;
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        RequestTypeEnum requestType;
        Set<RequestTypeEnum> allowableRequestTypes = this.provideAllowableRequestTypes();
        if (!allowableRequestTypes.contains((Object)(requestType = theRequest.getRequestType()))) {
            return false;
        }
        if (!this.getResourceName().equals(theRequest.getResourceName())) {
            return false;
        }
        if (this.getMatchingOperation() == null && StringUtils.isNotBlank((CharSequence)theRequest.getOperation())) {
            return false;
        }
        return this.getMatchingOperation() == null || this.getMatchingOperation().equals(theRequest.getOperation());
    }

    @Override
    public MethodOutcome invokeClient(String theResponseMimeType, Reader theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws BaseServerResponseException {
        if (theResponseStatusCode >= 200 && theResponseStatusCode < 300) {
            if (this.myReturnVoid) {
                return null;
            }
            MethodOutcome retVal = MethodUtil.process2xxResponse(this.getContext(), theResponseStatusCode, theResponseMimeType, theResponseReader, theHeaders);
            return retVal;
        }
        throw this.processNon2xxResponseAndReturnExceptionToThrow(theResponseStatusCode, theResponseMimeType, theResponseReader);
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) throws BaseServerResponseException, IOException {
        MethodOutcome response;
        Object[] params = this.createParametersForServerRequest(theRequest);
        this.addParametersForServerRequest(theRequest, params);
        Object methodReturn = this.invokeServerMethod(theServer, theRequest, params);
        if (methodReturn instanceof IBaseOperationOutcome) {
            response = new MethodOutcome();
            response.setOperationOutcome((IBaseOperationOutcome)methodReturn);
        } else {
            response = (MethodOutcome)methodReturn;
        }
        if (response != null && response.getId() != null && response.getId().hasResourceType() && this.getContext().getResourceDefinition(response.getId().getResourceType()) == null) {
            throw new InternalErrorException("Server method returned invalid resource ID: " + response.getId().getValue());
        }
        IBaseOperationOutcome outcome = response != null ? response.getOperationOutcome() : null;
        IBaseResource resource = response != null ? response.getResource() : null;
        return this.returnResponse(theServer, theRequest, response, outcome, resource);
    }

    public boolean isReturnVoid() {
        return this.myReturnVoid;
    }

    protected abstract Set<RequestTypeEnum> provideAllowableRequestTypes();

    private Object returnResponse(IRestfulServer<?> theServer, RequestDetails theRequest, MethodOutcome response, IBaseResource originalOutcome, IBaseResource resource) throws IOException {
        String prefer;
        PreferReturnEnum preferReturn;
        boolean allowPrefer = false;
        int operationStatus = this.getOperationStatus(response);
        IBaseResource outcome = originalOutcome;
        if (ourOperationsWhichAllowPreferHeader.contains((Object)this.getRestOperationType())) {
            allowPrefer = true;
        }
        if (resource != null && allowPrefer && (preferReturn = RestfulServerUtils.parsePreferHeader(prefer = theRequest.getHeader("Prefer"))) != null && preferReturn == PreferReturnEnum.REPRESENTATION) {
            outcome = resource;
        }
        for (int i = theServer.getInterceptors().size() - 1; i >= 0; --i) {
            IServerInterceptor next = theServer.getInterceptors().get(i);
            boolean continueProcessing = next.outgoingResponse(theRequest, outcome);
            if (continueProcessing) continue;
            return null;
        }
        IRestfulResponse restfulResponse = theRequest.getResponse();
        if (response != null) {
            IIdType responseId;
            if (response.getResource() != null) {
                restfulResponse.setOperationResourceLastUpdated(RestfulServerUtils.extractLastUpdatedFromResource(response.getResource()));
            }
            if ((responseId = response.getId()) != null && responseId.getResourceType() == null && responseId.hasIdPart()) {
                responseId = responseId.withResourceType(this.getResourceName());
            }
            if (responseId != null) {
                String serverBase = theRequest.getFhirServerBase();
                responseId = RestfulServerUtils.fullyQualifyResourceIdOrReturnNull(theServer, resource, serverBase, responseId);
                restfulResponse.setOperationResourceId(responseId);
            }
        }
        boolean prettyPrint = RestfulServerUtils.prettyPrintResponse(theServer, theRequest);
        Set<SummaryEnum> summaryMode = Collections.emptySet();
        return restfulResponse.streamResponseAsResource(outcome, prettyPrint, summaryMode, operationStatus, null, theRequest.isRespondGzip(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void streamOperationOutcome(BaseServerResponseException theE, RestfulServer theServer, EncodingEnum theEncodingNotNull, HttpServletResponse theResponse, RequestDetails theRequest) throws IOException {
        theResponse.setStatus(theE.getStatusCode());
        theServer.addHeadersToResponse(theResponse);
        if (theE.getOperationOutcome() != null) {
            theResponse.setContentType(theEncodingNotNull.getResourceContentType());
            IParser parser = theEncodingNotNull.newParser(theServer.getFhirContext());
            parser.setPrettyPrint(RestfulServerUtils.prettyPrintResponse(theServer, theRequest));
            PrintWriter writer = theResponse.getWriter();
            try {
                parser.encodeResourceToWriter(theE.getOperationOutcome(), writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        theResponse.setContentType("text/plain");
        PrintWriter writer = theResponse.getWriter();
        try {
            ((Writer)writer).append(theE.getMessage());
        }
        finally {
            ((Writer)writer).close();
        }
    }

    protected static void parseContentLocation(FhirContext theContext, MethodOutcome theOutcomeToPopulate, String theLocationHeader) {
        if (StringUtils.isBlank((CharSequence)theLocationHeader)) {
            return;
        }
        IIdType id = theContext.getVersion().newIdType();
        id.setValue(theLocationHeader);
        theOutcomeToPopulate.setId(id);
    }
}

