/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.interceptor;

import ca.uhn.fhir.rest.client.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class BasicAuthInterceptor
implements IClientInterceptor {
    private String myUsername;
    private String myPassword;

    public BasicAuthInterceptor(String theUsername, String thePassword) {
        this.myUsername = theUsername;
        this.myPassword = thePassword;
    }

    @Override
    public void interceptRequest(IHttpRequest theRequest) {
        String encoded;
        String authorizationUnescaped = StringUtils.defaultString((String)this.myUsername) + ":" + StringUtils.defaultString((String)this.myPassword);
        try {
            encoded = Base64.encodeBase64String((byte[])authorizationUnescaped.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException("Could not find US-ASCII encoding. This shouldn't happen!");
        }
        theRequest.addHeader("Authorization", "Basic " + encoded);
    }

    @Override
    public void interceptResponse(IHttpResponse theResponse) throws IOException {
    }
}

