/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.apache;

import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpResponse
implements IHttpResponse {
    private static final Logger ourLog = LoggerFactory.getLogger(ApacheHttpResponse.class);
    private boolean myEntityBuffered = false;
    private final HttpResponse myResponse;
    private byte[] myEntityBytes;

    public ApacheHttpResponse(HttpResponse theResponse) {
        this.myResponse = theResponse;
    }

    public HttpResponse getResponse() {
        return this.myResponse;
    }

    @Override
    public int getStatus() {
        return this.myResponse.getStatusLine().getStatusCode();
    }

    @Override
    public String getMimeType() {
        ContentType ct = ContentType.get((HttpEntity)this.myResponse.getEntity());
        return ct != null ? ct.getMimeType() : null;
    }

    @Override
    public Map<String, List<String>> getAllHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (this.myResponse.getAllHeaders() != null) {
            for (Header next : this.myResponse.getAllHeaders()) {
                String name = next.getName().toLowerCase();
                ArrayList<String> list = (ArrayList<String>)headers.get(name);
                if (list == null) {
                    list = new ArrayList<String>();
                    headers.put(name, list);
                }
                list.add(next.getValue());
            }
        }
        return headers;
    }

    @Override
    public String getStatusInfo() {
        return this.myResponse.getStatusLine().getReasonPhrase();
    }

    @Override
    public Reader createReader() throws IOException {
        HttpEntity entity = this.myResponse.getEntity();
        if (entity == null) {
            return new StringReader("");
        }
        Charset charset = null;
        if (entity.getContentType() != null && entity.getContentType().getElements() != null && entity.getContentType().getElements().length > 0) {
            ContentType ct = ContentType.get((HttpEntity)entity);
            charset = ct.getCharset();
        }
        if (charset == null) {
            if (204 != this.myResponse.getStatusLine().getStatusCode()) {
                ourLog.warn("Response did not specify a charset.");
            }
            charset = Charset.forName("UTF-8");
        }
        InputStreamReader reader = new InputStreamReader(this.readEntity(), charset);
        return reader;
    }

    @Override
    public InputStream readEntity() throws IOException {
        if (this.myEntityBuffered) {
            return new ByteArrayInputStream(this.myEntityBytes);
        }
        if (this.myResponse.getEntity() != null) {
            return this.myResponse.getEntity().getContent();
        }
        return null;
    }

    @Override
    public void close() {
        if (this.myResponse instanceof CloseableHttpResponse) {
            try {
                ((CloseableHttpResponse)this.myResponse).close();
            }
            catch (IOException e) {
                ourLog.debug("Failed to close response", (Throwable)e);
            }
        }
    }

    @Override
    public void bufferEntitity() throws IOException {
        if (this.myEntityBuffered) {
            return;
        }
        InputStream respEntity = this.readEntity();
        if (respEntity != null) {
            this.myEntityBuffered = true;
            try {
                this.myEntityBytes = IOUtils.toByteArray((InputStream)respEntity);
            }
            catch (IllegalStateException e) {
                throw new InternalErrorException(e);
            }
        }
    }
}

